/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.core.impl.locks.NonReentrantLock;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBuilder;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.NotebookIntervalPointersEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellTypeProvider;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \"2\u00020\u0001:\u0001\"B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u001a\u0010 \u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener;", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerFactory$ChangeListener;", "document", "Lcom/intellij/openapi/editor/Document;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "getNotebook", "Lkotlin/Function0;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/notebooks/visualization/NotebookCellLines;Lkotlin/jvm/functions/Function0;)V", "lock", "Lcom/intellij/jupyter/core/core/impl/locks/NonReentrantLock;", "withNotebookWriteAccess", "", "T", "action", "onUpdated", "event", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointersEvent;", "onUpdatedImpl", "onInserted", "notebook", "ordinals", "Lkotlin/ranges/IntRange;", "ordinal", "", "onEdited", "onRemoved", "onSwapped", "firstOrdinal", "secondOrdinal", "errorIfCellsNotMatchIntervals", "lastEvent", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterIntervalPointerChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterIntervalPointerChangeListener.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,141:1\n23#2:142\n23#2:143\n1586#3:144\n1661#3,2:145\n1663#3:150\n1123#4,3:147\n*S KotlinDebug\n*F\n+ 1 JupyterIntervalPointerChangeListener.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener\n*L\n129#1:142\n133#1:143\n136#1:144\n136#1:145,2\n136#1:150\n136#1:147,3\n*E\n"})
public final class JupyterIntervalPointerChangeListener
implements NotebookIntervalPointerFactory.ChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    @NotNull
    private final NotebookCellLines cellLines;
    @NotNull
    private final Function0<JupyterNotebook> getNotebook;
    @NotNull
    private final NonReentrantLock lock;

    private JupyterIntervalPointerChangeListener(Document document, NotebookCellLines cellLines, Function0<? extends JupyterNotebook> getNotebook) {
        this.document = document;
        this.cellLines = cellLines;
        this.getNotebook = getNotebook;
        this.lock = new NonReentrantLock(false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void withNotebookWriteAccess(Function0<? extends T> action) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Object object = action.invoke();
        }
        finally {
            lock.unlock();
        }
    }

    public void onUpdated(@NotNull NotebookIntervalPointersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.withNotebookWriteAccess(() -> JupyterIntervalPointerChangeListener.onUpdated$lambda$0(this, event));
    }

    private final void onUpdatedImpl(NotebookIntervalPointersEvent event) {
        JupyterNotebook notebook = (JupyterNotebook)this.getNotebook.invoke();
        for (NotebookIntervalPointersEvent.Change c : event.getChanges()) {
            NotebookIntervalPointersEvent.Change change = c;
            if (change instanceof NotebookIntervalPointersEvent.OnEdited) {
                this.onEdited(notebook, ((NotebookIntervalPointersEvent.OnEdited)c).getOrdinal());
                continue;
            }
            if (change instanceof NotebookIntervalPointersEvent.OnInserted) {
                this.onInserted(notebook, ((NotebookIntervalPointersEvent.OnInserted)c).getOrdinals());
                continue;
            }
            if (change instanceof NotebookIntervalPointersEvent.OnRemoved) {
                this.onRemoved(notebook, ((NotebookIntervalPointersEvent.OnRemoved)c).getOrdinals());
                continue;
            }
            if (change instanceof NotebookIntervalPointersEvent.OnSwapped) {
                this.onSwapped(notebook, ((NotebookIntervalPointersEvent.OnSwapped)c).getFirstOrdinal(), ((NotebookIntervalPointersEvent.OnSwapped)c).getSecondOrdinal());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        this.errorIfCellsNotMatchIntervals(notebook, event);
    }

    private final void onInserted(JupyterNotebook notebook, IntRange ordinals) {
        int n;
        int ordinal = ordinals.getFirst();
        if (ordinal <= (n = ordinals.getLast())) {
            while (true) {
                this.onInserted(notebook, ordinal);
                if (ordinal == n) break;
                ++ordinal;
            }
        }
    }

    private final void onInserted(JupyterNotebook notebook, int ordinal) {
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)this.cellLines.getIntervals().get(ordinal);
        notebook.addCell(ordinal, (Function1<? super JupyterCellBuilder, Unit>)((Function1)arg_0 -> JupyterIntervalPointerChangeListener.onInserted$lambda$0(interval, this, arg_0)));
    }

    private final void onEdited(JupyterNotebook notebook, int ordinal) {
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)this.cellLines.getIntervals().get(ordinal);
        JupyterCell cell = notebook.getCell(ordinal);
        JupyterCellType jupyterCellType = JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(interval);
        Intrinsics.checkNotNull((Object)jupyterCellType);
        cell.setCellTypeProvider(JupyterCellTypeProvider.Companion.providerByType(jupyterCellType));
        cell.setSource(((Object)interval.getContentText(this.document)).toString());
    }

    private final void onRemoved(JupyterNotebook notebook, IntRange ordinals) {
        int ordinal;
        int n = ordinals.getFirst();
        if (n <= (ordinal = ordinals.getLast())) {
            while (true) {
                this.onRemoved(notebook, ordinal);
                if (ordinal == n) break;
                --ordinal;
            }
        }
    }

    private final void onRemoved(JupyterNotebook notebook, int ordinal) {
        notebook.removeCell(ordinal);
    }

    private final void onSwapped(JupyterNotebook notebook, int firstOrdinal, int secondOrdinal) {
        notebook.swapCellsData(firstOrdinal, secondOrdinal);
    }

    /*
     * WARNING - void declaration
     */
    private final void errorIfCellsNotMatchIntervals(JupyterNotebook notebook, NotebookIntervalPointersEvent lastEvent) {
        List intervals = NotebookCellLines.Companion.get(this.document).getIntervals();
        if (this.getNotebook.invoke() != notebook) {
            JupyterIntervalPointerChangeListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterIntervalPointerChangeListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("race condition, notebook was changed by other code under write lock");
        }
        if (notebook.cellsCount() != intervals.size()) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<JupyterCell> cells = notebook.computeCells();
            Object $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterIntervalPointerChangeListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            $this$thisLogger$iv = cells;
            List list = intervals;
            NotebookIntervalPointersEvent notebookIntervalPointersEvent = lastEvent;
            int n = intervals.size();
            int n2 = cells.size();
            Logger logger2 = logger;
            boolean $i$f$map = false;
            void var7_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void cell;
                JupyterCell jupyterCell = (JupyterCell)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                CharSequence $this$count$iv = cell.getSource();
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$count$iv.charAt(i);
                    boolean bl2 = false;
                    if (!(c == '\n')) continue;
                    ++count$iv;
                }
                collection.add(count$iv + 1);
            }
            collection = (List)destination$iv$iv;
            logger2.error(StringsKt.trimMargin$default((String)("cells.size = " + n2 + ", but intervals.size = " + n + ", last event = " + notebookIntervalPointersEvent + "\n          |intervals = " + list + ",\n          |cells sizes = " + (List)collection + "\n        "), null, (int)1, null));
        }
    }

    private static final Unit onUpdated$lambda$0(JupyterIntervalPointerChangeListener this$0, NotebookIntervalPointersEvent $event) {
        this$0.onUpdatedImpl($event);
        return Unit.INSTANCE;
    }

    private static final Unit onInserted$lambda$0(NotebookCellLines.Interval $interval, JupyterIntervalPointerChangeListener this$0, JupyterCellBuilder $this$addCell) {
        Intrinsics.checkNotNullParameter((Object)$this$addCell, (String)"$this$addCell");
        $this$addCell.setSource(((Object)$interval.getContentText(this$0.document)).toString());
        JupyterCellType jupyterCellType = JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType($interval);
        Intrinsics.checkNotNull((Object)jupyterCellType);
        $this$addCell.setCellType(jupyterCellType);
        return Unit.INSTANCE;
    }

    public /* synthetic */ JupyterIntervalPointerChangeListener(Document document, NotebookCellLines cellLines, Function0 getNotebook, DefaultConstructorMarker $constructor_marker) {
        this(document, cellLines, (Function0<? extends JupyterNotebook>)getNotebook);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener$Companion;", "", "<init>", "()V", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterIntervalPointerChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterIntervalPointerChangeListener.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1807#2,3:142\n*S KotlinDebug\n*F\n+ 1 JupyterIntervalPointerChangeListener.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener$Companion\n*L\n45#1:142,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            boolean isAlreadyInstalled;
            NotebookIntervalPointerFactory pointersFactory;
            NotebookCellLines cellLines;
            BackedNotebookVirtualFile notebookVirtualFile2;
            DocumentEx document;
            block8: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                if (!JupyterEditorExtensionsKt.isJupyter((Editor)editor)) {
                    return;
                }
                if (editor.getProject() == null) {
                    return;
                }
                DocumentEx documentEx = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                document = documentEx;
                BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
                if (backedNotebookVirtualFile == null) {
                    return;
                }
                notebookVirtualFile2 = backedNotebookVirtualFile;
                cellLines = NotebookCellLines.Companion.get((Document)document);
                NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull((Editor)editor);
                if (notebookIntervalPointerFactory == null) {
                    return;
                }
                pointersFactory = notebookIntervalPointerFactory;
                List list = pointersFactory.getChangeListeners().getListeners();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getListeners(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        NotebookIntervalPointerFactory.ChangeListener it = (NotebookIntervalPointerFactory.ChangeListener)element$iv;
                        boolean bl = false;
                        if (!(it instanceof JupyterIntervalPointerChangeListener)) continue;
                        v4 = true;
                        break block8;
                    }
                    v4 = isAlreadyInstalled = false;
                }
            }
            if (isAlreadyInstalled) {
                return;
            }
            JupyterIntervalPointerChangeListener listener2 = new JupyterIntervalPointerChangeListener((Document)document, cellLines, () -> Companion.install$lambda$1(notebookVirtualFile2), null);
            pointersFactory.getChangeListeners().addListener((EventListener)((Object)listener2), editor.getDisposable());
            listener2.withNotebookWriteAccess(() -> Companion.install$lambda$2(notebookVirtualFile2, cellLines, listener2));
        }

        private static final JupyterNotebook install$lambda$1(BackedNotebookVirtualFile $notebookVirtualFile) {
            return $notebookVirtualFile.getNotebook();
        }

        private static final Unit install$lambda$2(BackedNotebookVirtualFile $notebookVirtualFile, NotebookCellLines $cellLines, JupyterIntervalPointerChangeListener $listener) {
            JupyterNotebook notebook = $notebookVirtualFile.getNotebook();
            Iterator iterator = ((Iterable)$cellLines.getIntervals()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                NotebookCellLines.Interval interval = (NotebookCellLines.Interval)iterator.next();
                if (notebook.cellsCount() <= index) {
                    $listener.onInserted(notebook, index);
                    continue;
                }
                if (Intrinsics.areEqual((Object)notebook.getCell(index).getCellTypeProvider().getJupyterCellType(), (Object)JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(interval))) {
                    $listener.onEdited(notebook, index);
                    continue;
                }
                $listener.onRemoved(notebook, index);
                $listener.onInserted(notebook, index);
            }
            $listener.errorIfCellsNotMatchIntervals(notebook, null);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

