/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.controllers.below.execution;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.editor.controllers.below.execution.ExecutionStatusTextProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutine;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.SpinningProgressIcon;
import com.intellij.ui.components.JBBox;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0003J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\b\u0010\u001a\u001a\u00020\u0015H\u0003J\b\u0010\u001b\u001a\u00020\u0015H\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/controllers/below/execution/NotebookCellExecutionPanelController;", "Lcom/intellij/openapi/Disposable;", "initialEditorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "editorCell", "getEditorCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "setEditorCell", "scope", "Lkotlinx/coroutines/CoroutineScope;", "component", "Lcom/intellij/ui/components/JBBox;", "getComponent", "()Lcom/intellij/ui/components/JBBox;", "executionLabel", "Ljavax/swing/JLabel;", "elapsedTimeJob", "Lkotlinx/coroutines/Job;", "updateExecutionStatus", "", "nudgeTooltip", "Ljavax/swing/JComponent;", "p", "Ljava/awt/Point;", "stopElapsedTimeUpdate", "startElapsedTimeUpdateIfNotStarted", "isUnderDebugger", "", "dispose", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCellExecutionPanelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellExecutionPanelController.kt\ncom/intellij/jupyter/core/jupyter/editor/controllers/below/execution/NotebookCellExecutionPanelController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class NotebookCellExecutionPanelController
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile EditorCell editorCell;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final JBBox component;
    @NotNull
    private final JLabel executionLabel;
    @Nullable
    private Job elapsedTimeJob;
    private static final long UPDATE_ELAPSED_TIME_DELAY = 200L;

    /*
     * WARNING - void declaration
     */
    public NotebookCellExecutionPanelController(@NotNull EditorCell initialEditorCell) {
        void $this$executionLabel_u24lambda_u240;
        Object scope;
        Object object;
        Intrinsics.checkNotNullParameter((Object)initialEditorCell, (String)"initialEditorCell");
        this.editorCell = initialEditorCell;
        CoroutineScope coroutineScope = object = CoroutineScopeKt.childScope$default((CoroutineScope)JupyterCoroutine.Utils.INSTANCE.getScope(), (String)"Jupyter.BelowCellInlayController", null, (boolean)false, (int)6, null);
        NotebookCellExecutionPanelController notebookCellExecutionPanelController = this;
        boolean bl = false;
        Disposer.register((Disposable)this, () -> NotebookCellExecutionPanelController.scope$lambda$0$0((CoroutineScope)scope));
        notebookCellExecutionPanelController.scope = object;
        this.component = new JBBox(0);
        scope = object = new JLabel();
        notebookCellExecutionPanelController = this;
        boolean bl2 = false;
        $this$executionLabel_u24lambda_u240.setFont(EditorUtil.getEditorFont().deriveFont(EditorUtil.getEditorFont().getSize2D() * 0.9f));
        $this$executionLabel_u24lambda_u240.setForeground(UIUtil.getLabelInfoForeground());
        notebookCellExecutionPanelController.executionLabel = object;
        this.executionLabel.getAccessibleContext().setAccessibleName("ExecutionLabel");
        this.component.add((Component)this.executionLabel);
        initialEditorCell.getExecutionStatus().afterChange((Disposable)this, arg_0 -> NotebookCellExecutionPanelController._init_$lambda$0(this, arg_0));
        this.updateExecutionStatus();
    }

    @Nullable
    public final EditorCell getEditorCell() {
        return this.editorCell;
    }

    public final void setEditorCell(@Nullable EditorCell editorCell) {
        this.editorCell = editorCell;
    }

    @NotNull
    public final JBBox getComponent() {
        return this.component;
    }

    @RequiresEdt
    private final void updateExecutionStatus() {
        String newTipText;
        String string;
        ThreadingAssertions.assertEventDispatchThread();
        EditorCell editorCell = this.editorCell;
        if (editorCell == null) {
            return;
        }
        EditorCell myEditorCell = editorCell;
        EditorCell.ExecutionStatus executionStatus = (EditorCell.ExecutionStatus)myEditorCell.getExecutionStatus().get();
        if (executionStatus.getStatus() == ProgressStatus.RUNNING) {
            this.startElapsedTimeUpdateIfNotStarted();
        } else {
            this.stopElapsedTimeUpdate();
        }
        Icon newIcon = ExecutionStatusTextProvider.INSTANCE.calculateIcon(executionStatus);
        if (!(newIcon instanceof SpinningProgressIcon) || !(this.executionLabel.getIcon() instanceof SpinningProgressIcon)) {
            this.executionLabel.setIcon(newIcon);
        }
        JLabel jLabel = this.executionLabel;
        String string2 = ExecutionStatusTextProvider.INSTANCE.calculateLabel(executionStatus, this.isUnderDebugger());
        if (string2 != null) {
            CharSequence charSequence;
            CharSequence charSequence2 = string2;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                JLabel jLabel2 = jLabel;
                boolean bl = false;
                charSequence = null;
                jLabel = jLabel2;
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        } else {
            string = null;
        }
        jLabel.setText(string);
        String string3 = ExecutionStatusTextProvider.INSTANCE.calculateTooltip(executionStatus);
        if (string3 != null) {
            CharSequence charSequence;
            CharSequence charSequence3 = string3;
            if (StringsKt.isBlank((CharSequence)charSequence3)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence3;
            }
            v7 = (String)charSequence;
        } else {
            v7 = newTipText = null;
        }
        if (!Intrinsics.areEqual((Object)newTipText, (Object)this.executionLabel.getToolTipText())) {
            this.executionLabel.setToolTipText(newTipText);
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                Point point = this.executionLabel.getMousePosition();
                if (point != null) {
                    Point it = point;
                    boolean bl = false;
                    this.nudgeTooltip(this.executionLabel, it);
                }
            }
        }
        this.component.invalidate();
    }

    @RequiresEdt
    private final void nudgeTooltip(JComponent component2, Point p) {
        long now = System.currentTimeMillis();
        MouseEvent e1 = new MouseEvent(component2, 503, now, 0, p.x + 1, p.y, 0, false);
        MouseEvent e2 = new MouseEvent(component2, 503, now + 1L, 0, p.x, p.y, 0, false);
        component2.dispatchEvent(e1);
        component2.dispatchEvent(e2);
    }

    @RequiresEdt
    private final void stopElapsedTimeUpdate() {
        ThreadingAssertions.assertEventDispatchThread();
        Job job = this.elapsedTimeJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.elapsedTimeJob = null;
    }

    @RequiresEdt
    private final void startElapsedTimeUpdateIfNotStarted() {
        ThreadingAssertions.assertEventDispatchThread();
        Job job = this.elapsedTimeJob;
        boolean bl = job != null ? !job.isCancelled() : false;
        if (bl) {
            Job job2 = this.elapsedTimeJob;
            boolean bl2 = job2 != null ? !job2.isCompleted() : false;
            if (bl2) {
                return;
            }
        }
        this.elapsedTimeJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NotebookCellExecutionPanelController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (true) {
                            this.label = 1;
                            v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ NotebookCellExecutionPanelController this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            NotebookCellExecutionPanelController.access$updateExecutionStatus(this.this$0);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        this.label = 2;
                        v1 = DelayKt.delay((long)200L, (Continuation)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl23
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final boolean isUnderDebugger() {
        EditorCell editorCell = this.editorCell;
        if (editorCell == null) {
            return false;
        }
        EditorCell myEditorCell = editorCell;
        EditorImpl editor = myEditorCell.getEditor();
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
        if (backedNotebookVirtualFile == null) {
            return false;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        return JupyterDebugger.INSTANCE.isUnderDebugger(project2, notebookFile);
    }

    public void dispose() {
        this.editorCell = null;
        Container container = this.component.getParent();
        if (container != null) {
            container.remove((Component)this.component);
        }
        this.stopElapsedTimeUpdate();
    }

    private static final void scope$lambda$0$0(CoroutineScope $scope) {
        kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)$scope, (CancellationException)new CancellationException("Disposed NotebookCellExecutionPanelController"));
    }

    private static final Unit _init_$lambda$0(NotebookCellExecutionPanelController this$0, EditorCell.ExecutionStatus it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateExecutionStatus();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateExecutionStatus(NotebookCellExecutionPanelController $this) {
        $this.updateExecutionStatus();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/controllers/below/execution/NotebookCellExecutionPanelController$Companion;", "", "<init>", "()V", "UPDATE_ELAPSED_TIME_DELAY", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

