/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.outputs.HasExecutionCountKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterBrowserOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputApi;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputInfo;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.JupyterAppBasedApiKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.JupyterPreviewOutputsBuffer;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.JupyterWebOutputPanel;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookOffScreenManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookOffscreenCellOutput;
import com.intellij.jupyter.core.jupyter.trust.JupyterNotebookTrustManager;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.outputs.NotebookOutputComponentFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterBrowserOutputComponentFactory;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory;", "Ljavax/swing/JComponent;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterBrowserOutputDataKey;", "<init>", "()V", "componentClass", "Ljava/lang/Class;", "getComponentClass", "()Ljava/lang/Class;", "outputDataKeyClass", "getOutputDataKeyClass", "match", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$Match;", "component", "outputDataKey", "updateComponent", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "createComponent", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterBrowserOutputComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterBrowserOutputComponentFactory.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterBrowserOutputComponentFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1834#2,4:94\n*S KotlinDebug\n*F\n+ 1 JupyterBrowserOutputComponentFactory.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterBrowserOutputComponentFactory\n*L\n53#1:94,4\n*E\n"})
public final class JupyterBrowserOutputComponentFactory
implements NotebookOutputComponentFactory<JComponent, JupyterBrowserOutputDataKey> {
    @NotNull
    private final Class<JComponent> componentClass = JComponent.class;
    @NotNull
    private final Class<JupyterBrowserOutputDataKey> outputDataKeyClass = JupyterBrowserOutputDataKey.class;

    @NotNull
    public Class<JComponent> getComponentClass() {
        return this.componentClass;
    }

    @NotNull
    public Class<JupyterBrowserOutputDataKey> getOutputDataKeyClass() {
        return this.outputDataKeyClass;
    }

    @NotNull
    public NotebookOutputComponentFactory.Match match(@NotNull JComponent component2, @NotNull JupyterBrowserOutputDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        Object object = component2.getClientProperty("NotebookOutputDataKey");
        JupyterBrowserOutputDataKey jupyterBrowserOutputDataKey = object instanceof JupyterBrowserOutputDataKey ? (JupyterBrowserOutputDataKey)object : null;
        if (jupyterBrowserOutputDataKey == null) {
            return NotebookOutputComponentFactory.Match.NONE;
        }
        JupyterBrowserOutputDataKey firstKey = jupyterBrowserOutputDataKey;
        return Intrinsics.areEqual((Object)firstKey, (Object)outputDataKey) ? NotebookOutputComponentFactory.Match.SAME : (component2 instanceof JupyterWebOutputPanel ? NotebookOutputComponentFactory.Match.COMPATIBLE : NotebookOutputComponentFactory.Match.NONE);
    }

    public void updateComponent(@NotNull EditorImpl editor, @NotNull JComponent component2, @NotNull JupyterBrowserOutputDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        JupyterWebOutputPanel panel = (JupyterWebOutputPanel)component2;
        NotebookOffScreenManager notebookOffScreenManager = (NotebookOffScreenManager)editor.getUserData(JupyterWebOutputApi.Companion.getOFFSCREEN_MANAGER_KEY());
        if (notebookOffScreenManager == null) {
            return;
        }
        NotebookOffScreenManager offScreenManager = notebookOffScreenManager;
        offScreenManager.updateCellOutput$intellij_jupyter_core(panel.getCellOutput(), outputDataKey.getInfo());
        Object object = editor.getUserData(JupyterAppBasedApiKt.getOUTPUT_BUFFER_KEY());
        Intrinsics.checkNotNull((Object)object);
        JupyterPreviewOutputsBuffer outputBuffer = (JupyterPreviewOutputsBuffer)object;
        Object object2 = panel.getClientProperty(JupyterAppBasedApiKt.getOUTPUT_DISPOSABLE_KEY());
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        Disposable outputDisposable = (Disposable)object2;
        Object object3 = panel.getClientProperty(JupyterAppBasedApiKt.getOUTPUT_REMOVAL_DISPOSABLE_KEY());
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        Disposable oldOutputRemovalDisposable = (Disposable)object3;
        Disposer.dispose((Disposable)oldOutputRemovalDisposable);
        panel.putClientProperty(JupyterAppBasedApiKt.getOUTPUT_REMOVAL_DISPOSABLE_KEY(), null);
        JupyterWebOutputInfo output = outputDataKey.getInfo();
        if (output instanceof JupyterWebOutputInfo.Output) {
            int n;
            int cellIndex = ((JupyterWebOutputInfo.Output)output).getCellIndex();
            Collection<NotebookOffscreenCellOutput> collection = offScreenManager.getCellOutputs$intellij_jupyter_core().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$count$iv = collection;
            boolean $i$f$count = false;
            if (((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    NotebookOffscreenCellOutput it = (NotebookOffscreenCellOutput)element$iv;
                    boolean bl = false;
                    if (!(it.getInfo().getCellIndex() < cellIndex) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int allBeforeOutputs = n;
            int curIndex = allBeforeOutputs + ((JupyterWebOutputInfo.Output)output).getOutputIndex();
            NotebookIntervalPointer notebookIntervalPointer = NotebookIntervalPointerFactory.Companion.get((Editor)editor).getForOrdinalIfExists(((JupyterWebOutputInfo.Output)output).getCellIndex());
            Intrinsics.checkNotNull((Object)notebookIntervalPointer);
            NotebookIntervalPointer pointer = notebookIntervalPointer;
            JupyterNotebookTrustManager jupyterNotebookTrustManager = JupyterNotebookTrustManager.Companion.get((Editor)editor);
            boolean isTrusted = jupyterNotebookTrustManager != null ? jupyterNotebookTrustManager.isOutputTrusted(pointer) : false;
            outputBuffer.addOutput(((JupyterWebOutputInfo.Output)output).getId(), ((JupyterWebOutputInfo.Output)output).getOutput(), curIndex, isTrusted);
            Disposable outputRemovalDisposable = () -> JupyterBrowserOutputComponentFactory.updateComponent$lambda$1(outputBuffer, output);
            panel.putClientProperty(JupyterAppBasedApiKt.getOUTPUT_REMOVAL_DISPOSABLE_KEY(), outputRemovalDisposable);
            Disposer.register((Disposable)outputDisposable, (Disposable)outputRemovalDisposable);
        } else if (output instanceof JupyterWebOutputInfo.JavaScript) {
            outputBuffer.addJs(((JupyterWebOutputInfo.JavaScript)output).getId(), ((JupyterWebOutputInfo.JavaScript)output).getOutput());
            Disposable outputRemovalDisposable = () -> JupyterBrowserOutputComponentFactory.updateComponent$lambda$2(outputBuffer, output);
            panel.putClientProperty(JupyterAppBasedApiKt.getOUTPUT_REMOVAL_DISPOSABLE_KEY(), outputRemovalDisposable);
            Disposer.register((Disposable)outputDisposable, (Disposable)outputRemovalDisposable);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public NotebookOutputComponentFactory.CreatedComponent<JComponent> createComponent(@NotNull EditorImpl editor, @NotNull JupyterBrowserOutputDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        Pair<JComponent, Disposable> pair = JupyterWebOutputApi.Companion.get((Editor)editor).createComponent(outputDataKey.getInfo());
        JComponent component2 = (JComponent)pair.component1();
        Disposable disposable = (Disposable)pair.component2();
        component2.setFocusable(true);
        component2.putClientProperty("NotebookOutputDataKey", outputDataKey);
        return new NotebookOutputComponentFactory.CreatedComponent(component2, NotebookOutputComponentFactory.WidthStretching.STRETCH_AND_SQUEEZE, false, false, () -> JupyterBrowserOutputComponentFactory.createComponent$lambda$0(component2), HasExecutionCountKt.createExecutionCountHolder(outputDataKey), disposable, null, 128, null);
    }

    private static final void updateComponent$lambda$1(JupyterPreviewOutputsBuffer $outputBuffer, JupyterWebOutputInfo $output) {
        $outputBuffer.removeOutput(((JupyterWebOutputInfo.Output)$output).getId());
    }

    private static final void updateComponent$lambda$2(JupyterPreviewOutputsBuffer $outputBuffer, JupyterWebOutputInfo $output) {
        $outputBuffer.removeJs(((JupyterWebOutputInfo.JavaScript)$output).getId());
    }

    private static final String createComponent$lambda$0(JComponent $component) {
        Object[] objectArray = new Object[]{$component.getWidth(), $component.getHeight()};
        return JupyterBundle.message("notebook.collapsed.web.output.text", objectArray);
    }
}

