/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.BackToFrontMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.BackToFrontRepaintOutputsMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.BackToFrontScrollToOffsetMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.BackToFrontUpdateUIThemeMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.UpdateOutputs;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.WidgetStateMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.models.BackToFrontScriptMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.models.ScriptLoaderMessageType;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.webHandlers.JupyterCefWebSocketListener;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.messages.JupyterKernelToFrontEndApi;
import com.intellij.jupyter.core.jupyter.messages.JupyterMessageWrapper;
import com.intellij.jupyter.core.jupyter.messages.processors.JupyterMessageProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u001f\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J%\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0000\u00a2\u0006\u0002\b'J\u000e\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020-H&J\u001f\u0010.\u001a\u00020\u00142\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020$00H\u0000\u00a2\u0006\u0004\b1\u00102J\u0015\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u000205H\u0000\u00a2\u0006\u0002\b6J\u0010\u00107\u001a\u00020\u00142\u0006\u0010)\u001a\u000208H&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00069"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/client/JupyterWebViewClient;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefWebSocketListener;", "Lcom/intellij/openapi/Disposable$Default;", "Lcom/intellij/jupyter/core/jupyter/messages/JupyterKernelToFrontEndApi;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getVirtualFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "messageProcessors", "", "Lcom/intellij/jupyter/core/jupyter/messages/processors/JupyterMessageProcessor;", "getMessageProcessors", "()Ljava/util/List;", "updateOutputs", "", "outputs", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/messages/UpdateOutputs;", "updateOutputs$intellij_jupyter_core", "setWidgetScriptResponse", "code", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/models/ScriptLoaderMessageType;", "payload", "", "setWidgetScriptResponse$intellij_jupyter_core", "scrollToOffset", "offset", "", "scrollToOffset$intellij_jupyter_core", "updateUITheme", "background", "", "dark", "newUI", "updateUITheme$intellij_jupyter_core", "messageFromFrontEndArrived", "message", "", "processMessage", "parsedMessage", "Lcom/intellij/jupyter/core/jupyter/messages/JupyterMessageWrapper;", "repaintOutputs", "outputIds", "", "repaintOutputs$intellij_jupyter_core", "([Ljava/lang/String;)V", "setWidgetState", "state", "Lcom/fasterxml/jackson/databind/JsonNode;", "setWidgetState$intellij_jupyter_core", "sendIntellijMessage", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/messages/BackToFrontMessage;", "intellij.jupyter.core"})
public abstract class JupyterWebViewClient
implements JupyterCefWebSocketListener,
Disposable.Default,
JupyterKernelToFrontEndApi {
    @NotNull
    private final Editor editor;

    public JupyterWebViewClient(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @Override
    @NotNull
    public BackedNotebookVirtualFile getVirtualFile() {
        return JupyterEditorExtensionsKt.getNotebookFile(this.editor);
    }

    @NotNull
    protected abstract List<JupyterMessageProcessor<?>> getMessageProcessors();

    public final void updateOutputs$intellij_jupyter_core(@NotNull UpdateOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        this.sendIntellijMessage(outputs);
    }

    public final void setWidgetScriptResponse$intellij_jupyter_core(@NotNull ScriptLoaderMessageType code, @Nullable Object payload) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        this.sendIntellijMessage(new BackToFrontScriptMessage(code.getCode(), payload));
    }

    public final void scrollToOffset$intellij_jupyter_core(int offset) {
        this.sendIntellijMessage(new BackToFrontScrollToOffsetMessage(offset));
    }

    public final void updateUITheme$intellij_jupyter_core(@NotNull String background, @NotNull String dark, @NotNull String newUI) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)dark, (String)"dark");
        Intrinsics.checkNotNullParameter((Object)newUI, (String)"newUI");
        this.sendIntellijMessage(new BackToFrontUpdateUIThemeMessage(background, dark, newUI));
    }

    @Override
    public final void messageFromFrontEndArrived(@NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JupyterMessageWrapper messageWrapper = JupyterMessageWrapper.Companion.fromString(((Object)message).toString());
        this.processMessage(message, messageWrapper);
    }

    public abstract void processMessage(@NotNull CharSequence var1, @NotNull JupyterMessageWrapper var2);

    public final void repaintOutputs$intellij_jupyter_core(@NotNull String[] outputIds) {
        Intrinsics.checkNotNullParameter((Object)outputIds, (String)"outputIds");
        this.sendIntellijMessage(new BackToFrontRepaintOutputsMessage(outputIds));
    }

    public final void setWidgetState$intellij_jupyter_core(@NotNull JsonNode state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.sendIntellijMessage(new WidgetStateMessage(state));
    }

    public abstract void sendIntellijMessage(@NotNull BackToFrontMessage var1);
}

