/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.converters;

import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellIdGenerator;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookConverter;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/converters/JupyterNotebookConverterCellId;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookConverter;", "<init>", "()V", "convertAfterLoading", "", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "convertBeforeSave", "notebookCopy", "removeIds", "addCellIds", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookConverterCellId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookConverterCellId.kt\ncom/intellij/jupyter/core/jupyter/nbformat/converters/JupyterNotebookConverterCellId\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1642#2,10:55\n1915#2:65\n1916#2:67\n1652#2:68\n1#3:66\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookConverterCellId.kt\ncom/intellij/jupyter/core/jupyter/nbformat/converters/JupyterNotebookConverterCellId\n*L\n43#1:55,10\n43#1:65\n43#1:67\n43#1:68\n43#1:66\n*E\n"})
public final class JupyterNotebookConverterCellId
implements JupyterNotebookConverter {
    @Override
    public void convertAfterLoading(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.addCellIds(notebook);
    }

    @Override
    public void convertBeforeSave(@NotNull JupyterNotebook notebookCopy) {
        Intrinsics.checkNotNullParameter((Object)notebookCopy, (String)"notebookCopy");
        if (notebookCopy.getVersion().compareTo(JupyterNotebookSchemaVersionKt.getJUPYTER_NOTEBOOK_SCHEMA_VERSION_4_5()) >= 0) {
            this.addCellIds(notebookCopy);
        } else {
            this.removeIds(notebookCopy);
        }
    }

    private final void removeIds(JupyterNotebook notebook) {
        for (JupyterCell cell : notebook.computeCells()) {
            cell.setId(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCellIds(JupyterNotebook notebook) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List<JupyterCell> cells = notebook.computeCells();
        Iterable iterable = cells;
        JupyterCellIdGenerator jupyterCellIdGenerator = JupyterCellIdGenerator.INSTANCE;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JupyterCell it = (JupyterCell)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set<String> validUniqueIds = jupyterCellIdGenerator.getValidUniqueIds((List)destination$iv$iv);
        for (JupyterCell cell : cells) {
            if (CollectionsKt.contains((Iterable)validUniqueIds, (Object)cell.getId())) continue;
            cell.setId(JupyterCellIdGenerator.INSTANCE.makeRandom());
        }
    }
}

