/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerToolWindowManagerKt;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.ui.content.Content;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \f*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ShowProfilerNotificationAction;", "Lcom/intellij/notification/NotificationAction;", "project", "Lcom/intellij/openapi/project/Project;", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/ProfilerProcess;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "processRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "intellij.profiler.common"})
final class ShowProfilerNotificationAction
extends NotificationAction {
    @NotNull
    private final Project project;
    @NotNull
    private final WeakReference<ProfilerProcess<?>> processRef;

    public ShowProfilerNotificationAction(@NotNull Project project, @NotNull ProfilerProcess<?> profilerProcess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        super(CommonProfilerBundleKt.profilerMessage("run.profiler.open.action", new Object[0]));
        this.project = project;
        this.processRef = new WeakReference(profilerProcess);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Profiler");
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        ProfilerProcess profilerProcess = (ProfilerProcess)this.processRef.get();
        if (profilerProcess == null) {
            return;
        }
        ProfilerProcess profilerProcess2 = profilerProcess;
        Content content = ProfilerToolWindowManagerKt.findToolWindowContent(toolWindow2, profilerProcess2);
        if (content != null) {
            Content it = content;
            boolean bl = false;
            toolWindow2.getContentManager().setSelectedContent(it);
        }
        toolWindow2.activate(null);
    }
}

