/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.dtrace;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.profiler.dtrace.DTraceScript;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.profiler.sudo.SudoProcessHandler;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u001a\b\u0010\u0017\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u001f\u001a\u00020 *\u00060\u0019j\u0002`!\u001aY\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'2\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020)0'2#\b\u0002\u0010*\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020)0+\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u001a\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001c*\n\u0010\u0018\"\u00020\u00192\u00020\u0019\u00a8\u0006/"}, d2={"DTRACE_ATTACHED_MSG", "", "DTRACE_STOPPED_MSG", "DTRACE_FAILED_TO_GRAB_PID", "DTRACE_CANNOT_INSTRUMENT_TRANSLATED_PROCESSES", "IO_READ_TAG", "IO_WRITE_TAG", "CPU_TAG", "AGGREGATED_DATA_TAG", "IO_READ_DATA_START_MSG", "IO_WRITE_DATA_START_MSG", "CPU_DATA_START_MSG", "AGGREGATED_DATA_STOP_MSG", "USTACK_DEPTH", "", "READ_PROBE", "WRITE_PROBE", "cpuProbe", "frequency", "cpuAndIOProfilerScriptWithMarkers", "cpuProfilerScriptWithMarkers", "defaultDTracePath", "Ljava/io/File;", "tryToFindDTrace", "DTraceSettingsState", "Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "defaultDTraceSettings", "getDefaultDTraceSettings", "()Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "defaultDTraceSettings$delegate", "Lkotlin/Lazy;", "cpuProfilerScript", "Lcom/intellij/profiler/dtrace/DTraceScript;", "Lcom/intellij/profiler/dtrace/DTraceSettingsState;", "startDTraceProcessNew", "Lcom/intellij/profiler/sudo/SudoProcessHandler;", "pid", "dTraceScript", "sudoPasswordSupplier", "Lkotlin/Function0;", "onWrongSudoPassword", "", "onCantSendSudoSignal", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "signal", "intellij.profiler.common"})
public final class DTraceScriptKt {
    @NotNull
    public static final String DTRACE_ATTACHED_MSG = "DTrace attached";
    @NotNull
    public static final String DTRACE_STOPPED_MSG = "DTrace stopped";
    @NotNull
    public static final String DTRACE_FAILED_TO_GRAB_PID = "dtrace: failed to grab pid";
    @NotNull
    public static final String DTRACE_CANNOT_INSTRUMENT_TRANSLATED_PROCESSES = "DTrace cannot instrument translated processes";
    @NotNull
    public static final String IO_READ_TAG = "IO Read";
    @NotNull
    public static final String IO_WRITE_TAG = "IO Write";
    @NotNull
    public static final String CPU_TAG = "CPU Samples";
    @NotNull
    public static final String AGGREGATED_DATA_TAG = "<aggregated-data-tag>";
    @NotNull
    public static final String IO_READ_DATA_START_MSG = "<aggregated-data-tag>IO Read</data-start>";
    @NotNull
    public static final String IO_WRITE_DATA_START_MSG = "<aggregated-data-tag>IO Write</data-start>";
    @NotNull
    public static final String CPU_DATA_START_MSG = "<aggregated-data-tag>CPU Samples</data-start>";
    @NotNull
    public static final String AGGREGATED_DATA_STOP_MSG = "<aggregated-data-tag></data-end>";
    private static final int USTACK_DEPTH = 500;
    @NotNull
    private static final String READ_PROBE = "syscall::read*:return/pid == $target && (int)arg1 != -1/{@read_bytes[tid, ustack(500)] = sum(arg1);}";
    @NotNull
    private static final String WRITE_PROBE = "syscall::write*:return/pid == $target && (int)arg1 != -1/{@write_bytes[tid, ustack(500)] = sum(arg1);}";
    @NotNull
    private static final File defaultDTracePath = new File("/usr/sbin/dtrace");
    @NotNull
    private static final Lazy defaultDTraceSettings$delegate = LazyKt.lazy(DTraceScriptKt::defaultDTraceSettings_delegate$lambda$0);

    private static final String cpuProbe(int frequency) {
        if (!(frequency > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return " profile-" + frequency + "/pid == $target/{@stacks[tid, ustack(500)] = count();}";
    }

    private static final String cpuAndIOProfilerScriptWithMarkers(int frequency) {
        return "BEGIN{printf(\"DTrace attached\");}\nsyscall::read*:return/pid == $target && (int)arg1 != -1/{@read_bytes[tid, ustack(500)] = sum(arg1);}\nsyscall::write*:return/pid == $target && (int)arg1 != -1/{@write_bytes[tid, ustack(500)] = sum(arg1);}\n" + DTraceScriptKt.cpuProbe(frequency) + "\nEND{printf(\"DTrace stopped\\n\");\nprintf(\"<aggregated-data-tag>IO Read</data-start>\\n\"); printa(@read_bytes); printf(\"<aggregated-data-tag></data-end>\\n\");\nprintf(\"<aggregated-data-tag>IO Write</data-start>\\n\"); printa(@write_bytes); printf(\"<aggregated-data-tag></data-end>\\n\");\nprintf(\"<aggregated-data-tag>CPU Samples</data-start>\\n\"); printa(@stacks); printf(\"<aggregated-data-tag></data-end>\\n\");}";
    }

    private static final String cpuProfilerScriptWithMarkers(int frequency) {
        return "BEGIN{printf(\"DTrace attached\");}\n" + DTraceScriptKt.cpuProbe(frequency) + "\nEND{printf(\"DTrace stopped\\n\");\nprintf(\"<aggregated-data-tag>CPU Samples</data-start>\\n\"); printa(@stacks); printf(\"<aggregated-data-tag></data-end>\\n\");}";
    }

    private static final String tryToFindDTrace() {
        if (defaultDTracePath.exists() && defaultDTracePath.canExecute()) {
            String string = defaultDTracePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }
        File file = PathEnvironmentVariableUtil.findInPath((String)"dtrace");
        String string = file != null ? file.getPath() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final SimpleProfilerSettingsState getDefaultDTraceSettings() {
        Lazy lazy = defaultDTraceSettings$delegate;
        return (SimpleProfilerSettingsState)((Object)lazy.getValue());
    }

    @NotNull
    public static final DTraceScript cpuProfilerScript(@NotNull SimpleProfilerSettingsState $this$cpuProfilerScript) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$cpuProfilerScript), (String)"<this>");
        String string = $this$cpuProfilerScript.getExecutablePath();
        Intrinsics.checkNotNull((Object)string);
        return new DTraceScript(string, $this$cpuProfilerScript.getDefaultCmdArgs(), DTraceScriptKt.cpuProfilerScriptWithMarkers($this$cpuProfilerScript.getSamplingFrequency()));
    }

    @NotNull
    public static final SudoProcessHandler startDTraceProcessNew(int pid, @NotNull DTraceScript dTraceScript, @NotNull Function0<String> sudoPasswordSupplier, @NotNull Function0<Unit> onWrongSudoPassword, @NotNull Function1<? super Integer, Unit> onCantSendSudoSignal) {
        Intrinsics.checkNotNullParameter((Object)dTraceScript, (String)"dTraceScript");
        Intrinsics.checkNotNullParameter(sudoPasswordSupplier, (String)"sudoPasswordSupplier");
        Intrinsics.checkNotNullParameter(onWrongSudoPassword, (String)"onWrongSudoPassword");
        Intrinsics.checkNotNullParameter(onCantSendSudoSignal, (String)"onCantSendSudoSignal");
        return new SudoProcessHandler(dTraceScript.generateFullCmd(pid), sudoPasswordSupplier, onWrongSudoPassword, onCantSendSudoSignal);
    }

    public static /* synthetic */ SudoProcessHandler startDTraceProcessNew$default(int n, DTraceScript dTraceScript, Function0 function0, Function0 function02, Function1 function1, int n2, Object object) {
        if ((n2 & 8) != 0) {
            function02 = DTraceScriptKt::startDTraceProcessNew$lambda$0;
        }
        if ((n2 & 0x10) != 0) {
            function1 = DTraceScriptKt::startDTraceProcessNew$lambda$1;
        }
        return DTraceScriptKt.startDTraceProcessNew(n, dTraceScript, (Function0<String>)function0, (Function0<Unit>)function02, (Function1<? super Integer, Unit>)function1);
    }

    private static final SimpleProfilerSettingsState defaultDTraceSettings_delegate$lambda$0() {
        SimpleProfilerSettingsState simpleProfilerSettingsState;
        SimpleProfilerSettingsState $this$defaultDTraceSettings_delegate_u24lambda_u240_u240 = simpleProfilerSettingsState = new SimpleProfilerSettingsState();
        boolean bl = false;
        $this$defaultDTraceSettings_delegate_u24lambda_u240_u240.setExecutablePath(DTraceScriptKt.tryToFindDTrace());
        $this$defaultDTraceSettings_delegate_u24lambda_u240_u240.setSamplingFrequency(997);
        Object[] objectArray = new String[]{"-q"};
        $this$defaultDTraceSettings_delegate_u24lambda_u240_u240.setDefaultCmdArgs(CollectionsKt.mutableListOf((Object[])objectArray));
        return simpleProfilerSettingsState;
    }

    private static final Unit startDTraceProcessNew$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit startDTraceProcessNew$lambda$1(int it) {
        return Unit.INSTANCE;
    }
}

