/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.model;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.BaseRichCallTreeModel;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.InnerMapStructures;
import com.intellij.profiler.model.RichCallTreeModelKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\u000e\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0005\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/model/RichCallTreeModelImpl;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/model/BaseRichCallTreeModel;", "callTree", "Lcom/intellij/profiler/model/CallTreeNode;", "<init>", "(Lcom/intellij/profiler/model/CallTreeNode;)V", "getCallTree", "()Lcom/intellij/profiler/model/CallTreeNode;", "innerMapStructures", "Lcom/intellij/profiler/model/InnerMapStructures;", "getInnerMapStructures", "()Lcom/intellij/profiler/model/InnerMapStructures;", "getCallNodes", "", "call", "(Lcom/intellij/profiler/api/BaseCallStackElement;)Ljava/util/List;", "baseNode", "node", "intellij.profiler.common"})
final class RichCallTreeModelImpl<Call extends BaseCallStackElement>
extends BaseRichCallTreeModel<Call> {
    @NotNull
    private final CallTreeNode<Call> callTree;
    @NotNull
    private final InnerMapStructures<Call> innerMapStructures;

    public RichCallTreeModelImpl(@NotNull CallTreeNode<? extends Call> callTree) {
        Intrinsics.checkNotNullParameter(callTree, (String)"callTree");
        this.callTree = callTree;
        this.innerMapStructures = RichCallTreeModelKt.access$buildInnerMapStructures(this.getCallTree());
    }

    @Override
    @NotNull
    public CallTreeNode<Call> getCallTree() {
        return this.callTree;
    }

    @Override
    @NotNull
    protected InnerMapStructures<Call> getInnerMapStructures() {
        return this.innerMapStructures;
    }

    @Override
    @Nullable
    protected List<CallTreeNode<Call>> getCallNodes(@NotNull Call call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        return this.getInnerMapStructures().getHorizontalMap().get(call);
    }

    @Override
    @NotNull
    protected CallTreeNode<Call> baseNode(@NotNull CallTreeNode<? extends Call> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return node;
    }
}

