/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cron;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayGroup;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.cron.CronBundle;
import com.intellij.cron.CronExpressionProvider;
import com.intellij.cron.CronInlayProvider;
import com.intellij.cron.CronInlayProviderKt;
import com.intellij.cron.CronProviderSettings;
import com.intellij.cron.CronUtilsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0014\u0010\u001e\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/cron/CronInlayProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "createSettings", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "", "getName", "()Ljava/lang/String;", "group", "Lcom/intellij/codeInsight/hints/InlayGroup;", "getGroup", "()Lcom/intellij/codeInsight/hints/InlayGroup;", "previewText", "getPreviewText", "description", "getDescription", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "CronInlayHintsCollector", "intellij.cron"})
public final class CronInlayProvider
implements InlayHintsProvider<NoSettings>,
DumbAware {
    @NotNull
    private final SettingsKey<NoSettings> key = CronInlayProviderKt.access$getINLAY_HINT_KEY$p();
    @NotNull
    private final String name = CronBundle.INSTANCE.message("inlay.cron.provider.name", new Object[0]);
    @NotNull
    private final InlayGroup group = InlayGroup.OTHER_GROUP;
    @Nullable
    private final String previewText;
    @NotNull
    private final String description = CronBundle.INSTANCE.message("cron.inlay.hints.provider.description", new Object[0]);

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (DumbService.Companion.isDumb(project2) || project2.isDefault()) {
            return null;
        }
        return (InlayHintsCollector)new CronInlayHintsCollector(editor);
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public InlayGroup getGroup() {
        return this.group;
    }

    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){

            public JComponent createComponent(ChangeListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                return (JComponent)BuilderKt.panel(createConfigurable.1::createComponent$lambda$0);
            }

            private static final Unit createComponent$lambda$0(Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                return Unit.INSTANCE;
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/cron/CronInlayProvider$CronInlayHintsCollector;", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/cron/CronInlayProvider;Lcom/intellij/openapi/editor/Editor;)V", "scaleAwarePresentationFactory", "Lcom/intellij/codeInsight/hints/presentation/ScaleAwarePresentationFactory;", "collect", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "buildPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "cronExplanation", "", "intellij.cron"})
    private final class CronInlayHintsCollector
    extends FactoryInlayHintsCollector {
        @NotNull
        private final ScaleAwarePresentationFactory scaleAwarePresentationFactory;

        public CronInlayHintsCollector(Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(editor);
            this.scaleAwarePresentationFactory = new ScaleAwarePresentationFactory(editor, this.getFactory());
        }

        public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            CronExpressionProvider cronExpressionProvider = CronUtilsKt.getCronExpressionProvider(element);
            if (cronExpressionProvider == null) {
                return true;
            }
            CronExpressionProvider cronExpressionProvider2 = cronExpressionProvider;
            CronProviderSettings cronProviderPresentation = cronExpressionProvider2.getSettings();
            if (cronProviderPresentation.isInlayEnabled()) {
                String string = CronUtilsKt.getCronExplanation(element);
                if (string == null) {
                    return true;
                }
                String cronExplanation = string;
                sink.addInlineElement(element.getTextRange().getEndOffset(), false, this.buildPresentation(cronExplanation), true);
                return true;
            }
            return true;
        }

        private final InlayPresentation buildPresentation(String cronExplanation) {
            ScaleAwarePresentationFactory $this$buildPresentation_u24lambda_u240 = this.scaleAwarePresentationFactory;
            boolean bl = false;
            return ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)$this$buildPresentation_u24lambda_u240, (InlayPresentation)$this$buildPresentation_u24lambda_u240.smallText(cronExplanation), (int)1, (int)0, (int)5, (int)0, (int)20, null);
        }
    }
}

