/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.TreeContentProvider;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.FeedbackTreeLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class TreeEditableArea
implements EditableArea,
FeedbackTreeLayer,
TreeSelectionListener {
    private final EventListenerList myListenerList = new EventListenerList();
    private final ComponentTree myTree;
    private final StructureTreeModel<TreeContentProvider> myTreeModel;
    private final DesignerActionPanel myActionPanel;
    private boolean myCanvasSelection;

    public TreeEditableArea(ComponentTree tree, StructureTreeModel<TreeContentProvider> model, DesignerActionPanel actionPanel) {
        this.myTree = tree;
        this.myTreeModel = model;
        this.myActionPanel = actionPanel;
        this.hookSelection();
    }

    private void hookSelection() {
        this.myTree.getSelectionModel().addTreeSelectionListener(this);
    }

    public void unhookSelection() {
        this.myTree.getSelectionModel().removeTreeSelectionListener(this);
    }

    @Override
    public void addSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.add(ComponentSelectionListener.class, listener);
    }

    @Override
    public void removeSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.remove(ComponentSelectionListener.class, listener);
    }

    private void fireSelectionChanged() {
        for (ComponentSelectionListener listener : (ComponentSelectionListener[])this.myListenerList.getListeners(ComponentSelectionListener.class)) {
            listener.selectionChanged(this);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.fireSelectionChanged();
        }
    }

    @Override
    @NotNull
    public List<RadComponent> getSelection() {
        return new ArrayList<RadComponent>(this.getRawSelection());
    }

    @Override
    public boolean isSelected(@NotNull RadComponent component) {
        if (component == null) {
            TreeEditableArea.$$$reportNull$$$0(0);
        }
        return this.getRawSelection().contains((Object)component);
    }

    @Override
    public void select(@NotNull RadComponent component) {
        if (component == null) {
            TreeEditableArea.$$$reportNull$$$0(1);
        }
        this.setRawSelection((Object)component);
    }

    @Override
    public void deselect(@NotNull RadComponent component) {
        if (component == null) {
            TreeEditableArea.$$$reportNull$$$0(2);
        }
        ArrayList<RadComponent> selection = new ArrayList<RadComponent>(this.getRawSelection());
        selection.remove((Object)component);
        this.setRawSelection(selection);
    }

    @Override
    public void appendSelection(@NotNull RadComponent component) {
        if (component == null) {
            TreeEditableArea.$$$reportNull$$$0(3);
        }
        List<RadComponent> selection = this.getRawSelection();
        this.setRawSelection(ContainerUtil.append(selection, (Object[])new RadComponent[]{component}));
    }

    @Override
    public void setSelection(@NotNull List<RadComponent> components) {
        if (components == null) {
            TreeEditableArea.$$$reportNull$$$0(4);
        }
        this.setRawSelection(components);
    }

    @Override
    public void deselect(@NotNull Collection<RadComponent> components) {
        if (components == null) {
            TreeEditableArea.$$$reportNull$$$0(5);
        }
        ArrayList<RadComponent> selection = new ArrayList<RadComponent>(this.getRawSelection());
        selection.removeAll(components);
        this.setRawSelection(selection);
    }

    @Override
    public void deselectAll() {
        this.setRawSelection(null);
    }

    @Override
    public void scrollToSelection() {
    }

    private @Unmodifiable List<RadComponent> getRawSelection() {
        return TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this.myTree), RadComponent.class);
    }

    private void setRawSelection(@Nullable Object value) {
        Runnable finish = () -> {
            this.hookSelection();
            this.fireSelectionChanged();
        };
        this.unhookSelection();
        this.myTreeModel.invalidateAsync().thenRun(() -> {
            if (value == null) {
                this.myTree.clearSelection();
                finish.run();
            } else if (value instanceof RadComponent) {
                this.myTreeModel.select(value, (JTree)((Object)this.myTree), path -> finish.run());
            } else {
                ArrayList<TreePath> selection = new ArrayList<TreePath>();
                for (Object element : (Collection)value) {
                    RadComponent component;
                    TreePath path2;
                    if (!(element instanceof RadComponent) || (path2 = this.getPath(component = (RadComponent)((Object)((Object)element)))) == null) continue;
                    selection.add(path2);
                }
                if (selection.isEmpty()) {
                    this.myTree.clearSelection();
                } else {
                    TreeUtil.selectPaths((JTree)((Object)this.myTree), selection);
                }
                finish.run();
            }
        });
    }

    public boolean isCanvasSelection() {
        return this.myCanvasSelection;
    }

    public void setCanvasSelection(boolean canvasSelection) {
        this.myCanvasSelection = canvasSelection;
    }

    @Override
    public void setCursor(@Nullable Cursor cursor) {
        this.myTree.setCursor(cursor);
    }

    @Override
    public void setDescription(@Nullable String text) {
    }

    @Override
    @NotNull
    public JComponent getNativeComponent() {
        ComponentTree componentTree = this.myTree;
        if (componentTree == null) {
            TreeEditableArea.$$$reportNull$$$0(6);
        }
        return componentTree;
    }

    @Override
    public RadComponent findTarget(int x, int y, @Nullable ComponentTargetFilter filter) {
        TreePath path = this.myTree.getPathForLocation(x, y);
        if (path != null) {
            RadComponent component;
            if (filter != null) {
                for (component = this.myTree.extractComponent(path.getLastPathComponent()); !(component == null || filter.preFilter(component) && filter.resultFilter(component)); component = component.getParent()) {
                }
            }
            return component;
        }
        return null;
    }

    @Override
    public InputTool findTargetTool(int x, int y) {
        return null;
    }

    @Override
    public void showSelection(boolean value) {
    }

    @Override
    public ComponentDecorator getRootSelectionDecorator() {
        return null;
    }

    @Override
    public EditOperation processRootOperation(OperationContext context) {
        return null;
    }

    @Override
    public FeedbackLayer getFeedbackLayer() {
        return null;
    }

    @Override
    public RadComponent getRootComponent() {
        return null;
    }

    @Override
    public boolean isTree() {
        return true;
    }

    @Override
    public FeedbackTreeLayer getFeedbackTreeLayer() {
        return this;
    }

    @Override
    public ActionGroup getPopupActions() {
        return this.myActionPanel.getPopupActions(this);
    }

    @Override
    public String getPopupPlace() {
        return "GuiDesigner.ComponentTreePopup";
    }

    private TreePath getPath(@NotNull RadComponent component) {
        TreeNode treeNode;
        if (component == null) {
            TreeEditableArea.$$$reportNull$$$0(7);
        }
        if ((treeNode = this.myTreeModel.getRoot()) instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeNode;
            DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)((Object)component));
            return node == null ? null : new TreePath(node.getPath());
        }
        return null;
    }

    @Override
    public void mark(RadComponent component, int feedback) {
        if (component != null) {
            TreePath path = this.getPath(component);
            if (feedback == 2) {
                this.myTree.scrollPathToVisible(path);
                if (!this.myTree.isExpanded(path)) {
                    this.myTreeModel.expand((Object)component, (JTree)((Object)this.myTree), p -> {});
                }
            } else {
                this.myTree.scrollRowToVisible(this.myTree.getRowForPath(path) + (feedback == 0 ? -1 : 1));
            }
        }
        this.myTree.mark(component, feedback);
    }

    @Override
    public void unmark() {
        this.myTree.mark(null, -1);
    }

    @Override
    public boolean isBeforeLocation(@NotNull RadComponent component, int x, int y) {
        Rectangle bounds;
        if (component == null) {
            TreeEditableArea.$$$reportNull$$$0(8);
        }
        return (bounds = this.myTree.getPathBounds(this.getPath(component))) != null && y - bounds.y < this.myTree.getEdgeSize();
    }

    @Override
    public boolean isAfterLocation(@NotNull RadComponent component, int x, int y) {
        Rectangle bounds;
        if (component == null) {
            TreeEditableArea.$$$reportNull$$$0(9);
        }
        return (bounds = this.myTree.getPathBounds(this.getPath(component))) != null && bounds.getMaxY() - (double)y < (double)this.myTree.getEdgeSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/componentTree/TreeEditableArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/componentTree/TreeEditableArea";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deselect";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendSelection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBeforeLocation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAfterLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

