/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UVariableKt;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInspection/ObsoleteApiUsageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "shouldInspect", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "ObsoleteApiUsageProcessor", "intellij.jvm.analysis.impl"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nObsoleteApiUsageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObsoleteApiUsageInspection.kt\ncom/intellij/codeInspection/ObsoleteApiUsageInspection\n+ 2 ObsoleteApiUsageInspection.kt\ncom/intellij/codeInspection/ObsoleteApiUsageInspectionKt\n*L\n1#1,89:1\n28#2:90\n*S KotlinDebug\n*F\n+ 1 ObsoleteApiUsageInspection.kt\ncom/intellij/codeInspection/ObsoleteApiUsageInspection\n*L\n34#1:90\n*E\n"})
public final class ObsoleteApiUsageInspection
extends LocalInspectionTool {
    private final boolean shouldInspect(PsiFile file) {
        boolean $i$f$getOBSOLETE_ANNOTATION_NAME = false;
        return JavaPsiFacade.getInstance((Project)file.getProject()).findClass(ApiStatus.Obsolete.class.getCanonicalName(), file.getResolveScope()) != null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (!this.shouldInspect(psiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return ApiUsageUastVisitor.Companion.createPsiElementVisitor((ApiUsageProcessor)new ObsoleteApiUsageProcessor(holder));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J,\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInspection/ObsoleteApiUsageInspection$ObsoleteApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "processReference", "", "sourceNode", "Lorg/jetbrains/uast/UElement;", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "qualifier", "Lorg/jetbrains/uast/UExpression;", "processConstructorInvocation", "instantiatedClass", "Lcom/intellij/psi/PsiClass;", "constructor", "Lcom/intellij/psi/PsiMethod;", "subclassDeclaration", "Lorg/jetbrains/uast/UClass;", "processMethodOverriding", "method", "Lorg/jetbrains/uast/UMethod;", "overriddenMethod", "checkObsoleteApiUsage", "arePsiElementsFromTheSameFile", "", "one", "Lcom/intellij/psi/PsiElement;", "two", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nObsoleteApiUsageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObsoleteApiUsageInspection.kt\ncom/intellij/codeInspection/ObsoleteApiUsageInspection$ObsoleteApiUsageProcessor\n+ 2 ObsoleteApiUsageInspection.kt\ncom/intellij/codeInspection/ObsoleteApiUsageInspectionKt\n*L\n1#1,89:1\n28#2:90\n*S KotlinDebug\n*F\n+ 1 ObsoleteApiUsageInspection.kt\ncom/intellij/codeInspection/ObsoleteApiUsageInspection$ObsoleteApiUsageProcessor\n*L\n63#1:90\n*E\n"})
    private static final class ObsoleteApiUsageProcessor
    implements ApiUsageProcessor {
        @NotNull
        private final ProblemsHolder problemsHolder;

        public ObsoleteApiUsageProcessor(@NotNull ProblemsHolder problemsHolder) {
            Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
            this.problemsHolder = problemsHolder;
        }

        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.checkObsoleteApiUsage(target, sourceNode);
        }

        public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
            Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkNotNullParameter((Object)instantiatedClass, (String)"instantiatedClass");
            if (constructor != null) {
                this.checkObsoleteApiUsage((PsiModifierListOwner)constructor, sourceNode);
            }
        }

        public void processMethodOverriding(@NotNull UMethod method, @NotNull PsiMethod overriddenMethod) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)overriddenMethod, (String)"overriddenMethod");
            this.checkObsoleteApiUsage((PsiModifierListOwner)overriddenMethod, (UElement)method);
        }

        private final void checkObsoleteApiUsage(PsiModifierListOwner target, UElement sourceNode) {
            UDeclaration declaration = (UDeclaration)UastContextKt.toUElement((PsiElement)((PsiElement)target), UDeclaration.class);
            if (declaration != null && !this.arePsiElementsFromTheSameFile(sourceNode.getSourcePsi(), (PsiElement)target)) {
                if (!(declaration instanceof UClass || declaration instanceof UMethod || declaration instanceof UField)) {
                    return;
                }
                UAnnotated uAnnotated = (UAnnotated)declaration;
                boolean $i$f$getOBSOLETE_ANNOTATION_NAME = false;
                String string = ApiStatus.Obsolete.class.getCanonicalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-OBSOLETE_ANNOTATION_NAME>(...)");
                if (UVariableKt.findSourceAnnotation((UAnnotated)uAnnotated, (String)string) != null) {
                    UDeclaration uDeclaration = sourceNode instanceof UDeclaration ? (UDeclaration)sourceNode : null;
                    PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)(uDeclaration != null ? uDeclaration.getUastAnchor() : null));
                    if (psiElement == null && (psiElement = sourceNode.getSourcePsi()) == null) {
                        return;
                    }
                    PsiElement elementToHighlight = psiElement;
                    if (elementToHighlight instanceof PsiMethodReferenceExpression && target instanceof PsiClass) {
                        return;
                    }
                    if (elementToHighlight instanceof PsiReference) {
                        this.problemsHolder.registerProblem((PsiReference)elementToHighlight, JvmAnalysisBundle.message("jvm.inspections.usages.of.obsolete.api.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    } else {
                        this.problemsHolder.registerProblem(elementToHighlight, JvmAnalysisBundle.message("jvm.inspections.usages.of.obsolete.api.description", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        }

        private final boolean arePsiElementsFromTheSameFile(PsiElement one, PsiElement two) {
            PsiElement psiElement;
            PsiElement psiElement2 = one;
            return Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getContainingFile()) != null ? psiElement2.getVirtualFile() : null), (psiElement = two) != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null);
        }
    }
}

