/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.logging;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.logging.LoggingStringTemplateAsArgumentInspectionKt;
import com.intellij.codeInspection.logging.LoggingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;
import org.jetbrains.uast.generate.UastElementFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInspection/logging/ConvertToPlaceHolderQuickfix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "indexStringExpression", "", "<init>", "(I)V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "createMethodContext", "Lcom/intellij/codeInspection/logging/ConvertToPlaceHolderQuickfix$MethodContext;", "uCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "flatPatterns", "", "Lorg/jetbrains/uast/UExpression;", "polyadicExpression", "Lorg/jetbrains/uast/UPolyadicExpression;", "MethodContext", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nLoggingStringTemplateAsArgumentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingStringTemplateAsArgumentInspection.kt\ncom/intellij/codeInspection/logging/ConvertToPlaceHolderQuickfix\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n212#2:290\n271#3,6:291\n278#3:298\n13#4:297\n1391#5:299\n1480#5,5:300\n*S KotlinDebug\n*F\n+ 1 LoggingStringTemplateAsArgumentInspection.kt\ncom/intellij/codeInspection/logging/ConvertToPlaceHolderQuickfix\n*L\n196#1:290\n213#1:291,6\n213#1:298\n213#1:297\n275#1:299\n275#1:300,5\n*E\n"})
final class ConvertToPlaceHolderQuickfix
implements LocalQuickFix {
    private final int indexStringExpression;

    public ConvertToPlaceHolderQuickfix(int indexStringExpression) {
        this.indexStringExpression = indexStringExpression;
    }

    @NotNull
    public String getFamilyName() {
        String string = JvmAnalysisBundle.message("jvm.inspection.logging.string.template.as.argument.quickfix.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        void $this$replace$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement $this$getUastParentOfType_u24default$iv = descriptor.getPsiElement();
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UCallExpression uCallExpression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
        if (uCallExpression == null) {
            return;
        }
        UCallExpression uCallExpression2 = uCallExpression;
        MethodContext methodContext = this.createMethodContext(uCallExpression2);
        List<UExpression> parametersBeforeString = methodContext.component1();
        List<UExpression> parametersAfterString = methodContext.component2();
        StringBuilder textPattern = methodContext.component3();
        UastElementFactory uastElementFactory = UastCodeGenerationPluginKt.getUastElementFactory((UElement)((UElement)uCallExpression2), (Project)project);
        if (uastElementFactory == null) {
            return;
        }
        UastElementFactory elementFactory = uastElementFactory;
        String string = textPattern.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        UExpression uExpression = elementFactory.createStringLiteralExpression(string, uCallExpression2.getSourcePsi());
        if (uExpression == null) {
            return;
        }
        UExpression newText = uExpression;
        List $this$applyFix_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        $this$applyFix_u24lambda_u240.addAll((Collection)parametersBeforeString);
        $this$applyFix_u24lambda_u240.add(newText);
        $this$applyFix_u24lambda_u240.addAll((Collection)parametersAfterString);
        List newParameters = list;
        String string2 = uCallExpression2.getMethodName();
        if (string2 == null) {
            return;
        }
        String methodName = string2;
        UCallExpression uCallExpression3 = elementFactory.createCallExpression(uCallExpression2.getReceiver(), methodName, newParameters, uCallExpression2.getReturnType(), uCallExpression2.getKind(), uCallExpression2.getSourcePsi());
        if (uCallExpression3 == null) {
            return;
        }
        UCallExpression newCall = uCallExpression3;
        UExpression oldCall = UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)uCallExpression2));
        UElement uElement = (UElement)oldCall;
        UElement newElement$iv = (UElement)newCall;
        boolean $i$f$replace = false;
        if (!Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
            UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
            UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin = uastCodeGenerationPlugin != null ? uastCodeGenerationPlugin.replace((UElement)$this$replace$iv, newElement$iv, UCallExpression.class) : null;
            boolean bl2 = false;
            if (it$iv == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
            }
        }
    }

    private final MethodContext createMethodContext(UCallExpression uCallExpression) {
        List parametersBeforeString = new ArrayList();
        List parametersAfterString = new ArrayList();
        List valueArguments = uCallExpression.getValueArguments();
        if (this.indexStringExpression == 1) {
            parametersBeforeString.add(valueArguments.get(0));
        }
        UExpression argument = (UExpression)valueArguments.get(this.indexStringExpression);
        StringBuilder textPattern = new StringBuilder();
        int indexOuterPlaceholder = this.indexStringExpression + 1;
        if (argument instanceof UPolyadicExpression) {
            List<UExpression> operands = this.flatPatterns((UPolyadicExpression)argument);
            LoggingUtil.Companion.LoggerType loggerType = LoggingUtil.Companion.getLoggerType$intellij_jvm_analysis_impl(uCallExpression);
            for (UExpression operand : operands) {
                Comparable<Boolean> comparable;
                if (operand instanceof ULiteralExpression && ((ULiteralExpression)operand).isString()) {
                    int nextIndex;
                    String text = String.valueOf(((ULiteralExpression)operand).getValue());
                    int countPlaceHolders = LoggingUtil.Companion.countPlaceHolders$intellij_jvm_analysis_impl(text, loggerType);
                    for (int index = 0; index < countPlaceHolders && (nextIndex = indexOuterPlaceholder + index) < valueArguments.size(); ++index) {
                        parametersAfterString.add(valueArguments.get(nextIndex));
                    }
                    indexOuterPlaceholder += countPlaceHolders;
                    comparable = textPattern.append(text);
                    continue;
                }
                if (StringsKt.endsWith$default((CharSequence)textPattern, (CharSequence)"\\", (boolean)false, (int)2, null) && (loggerType == LoggingUtil.Companion.LoggerType.SLF4J_LOGGER_TYPE || loggerType == LoggingUtil.Companion.LoggerType.SLF4J_BUILDER_TYPE)) {
                    textPattern.append("\\");
                }
                textPattern.append("{}");
                comparable = parametersAfterString.add(operand);
            }
        } else {
            textPattern.append("{}");
            parametersAfterString.add(argument);
        }
        if (indexOuterPlaceholder < valueArguments.size()) {
            int n = valueArguments.size();
            for (int index = indexOuterPlaceholder; index < n; ++index) {
                parametersAfterString.add(valueArguments.get(index));
            }
        }
        return new MethodContext(parametersBeforeString, parametersAfterString, textPattern);
    }

    /*
     * WARNING - void declaration
     */
    private final List<UExpression> flatPatterns(UPolyadicExpression polyadicExpression) {
        void $this$flatMapTo$iv$iv;
        if (LoggingStringTemplateAsArgumentInspectionKt.access$isPattern((UExpression)polyadicExpression)) {
            return polyadicExpression.getOperands();
        }
        Iterable $this$flatMap$iv = polyadicExpression.getOperands();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            UExpression operand = (UExpression)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = operand instanceof UPolyadicExpression ? this.flatPatterns((UPolyadicExpression)operand) : CollectionsKt.listOf((Object)operand);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List result = (List)destination$iv$iv;
        return result;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\r\u0010\u0012\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/codeInspection/logging/ConvertToPlaceHolderQuickfix$MethodContext;", "", "parametersBeforeString", "", "Lorg/jetbrains/uast/UExpression;", "parametersAfterString", "textPattern", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/lang/StringBuilder;)V", "getParametersBeforeString", "()Ljava/util/List;", "getParametersAfterString", "getTextPattern", "()Ljava/lang/StringBuilder;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.jvm.analysis.impl"})
    public static final class MethodContext {
        @NotNull
        private final List<UExpression> parametersBeforeString;
        @NotNull
        private final List<UExpression> parametersAfterString;
        @NotNull
        private final StringBuilder textPattern;

        public MethodContext(@NotNull List<UExpression> parametersBeforeString, @NotNull List<UExpression> parametersAfterString, @NotNull StringBuilder textPattern) {
            Intrinsics.checkNotNullParameter(parametersBeforeString, (String)"parametersBeforeString");
            Intrinsics.checkNotNullParameter(parametersAfterString, (String)"parametersAfterString");
            Intrinsics.checkNotNullParameter((Object)textPattern, (String)"textPattern");
            this.parametersBeforeString = parametersBeforeString;
            this.parametersAfterString = parametersAfterString;
            this.textPattern = textPattern;
        }

        @NotNull
        public final List<UExpression> getParametersBeforeString() {
            return this.parametersBeforeString;
        }

        @NotNull
        public final List<UExpression> getParametersAfterString() {
            return this.parametersAfterString;
        }

        @NotNull
        public final StringBuilder getTextPattern() {
            return this.textPattern;
        }

        @NotNull
        public final List<UExpression> component1() {
            return this.parametersBeforeString;
        }

        @NotNull
        public final List<UExpression> component2() {
            return this.parametersAfterString;
        }

        @NotNull
        public final StringBuilder component3() {
            return this.textPattern;
        }

        @NotNull
        public final MethodContext copy(@NotNull List<UExpression> parametersBeforeString, @NotNull List<UExpression> parametersAfterString, @NotNull StringBuilder textPattern) {
            Intrinsics.checkNotNullParameter(parametersBeforeString, (String)"parametersBeforeString");
            Intrinsics.checkNotNullParameter(parametersAfterString, (String)"parametersAfterString");
            Intrinsics.checkNotNullParameter((Object)textPattern, (String)"textPattern");
            return new MethodContext(parametersBeforeString, parametersAfterString, textPattern);
        }

        public static /* synthetic */ MethodContext copy$default(MethodContext methodContext, List list, List list2, StringBuilder stringBuilder, int n, Object object) {
            if ((n & 1) != 0) {
                list = methodContext.parametersBeforeString;
            }
            if ((n & 2) != 0) {
                list2 = methodContext.parametersAfterString;
            }
            if ((n & 4) != 0) {
                stringBuilder = methodContext.textPattern;
            }
            return methodContext.copy(list, list2, stringBuilder);
        }

        @NotNull
        public String toString() {
            return "MethodContext(parametersBeforeString=" + this.parametersBeforeString + ", parametersAfterString=" + this.parametersAfterString + ", textPattern=" + this.textPattern + ")";
        }

        public int hashCode() {
            int result = ((Object)this.parametersBeforeString).hashCode();
            result = result * 31 + ((Object)this.parametersAfterString).hashCode();
            result = result * 31 + this.textPattern.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodContext)) {
                return false;
            }
            MethodContext methodContext = (MethodContext)other;
            if (!Intrinsics.areEqual(this.parametersBeforeString, methodContext.parametersBeforeString)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.parametersAfterString, methodContext.parametersAfterString)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.textPattern, (Object)methodContext.textPattern);
        }
    }
}

