/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AbstractConstructorClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.AbstractFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokAddNullAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import de.plushnikov.intellij.plugin.util.PsiTypeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WithByFieldProcessor
extends AbstractFieldProcessor {
    @NonNls
    public static final String WITH_BY_METHOD_PARAMETER_NAME = "transformer";
    private static final String NAME_JUF_FUNCTION = "java.util.function.Function";
    private static final String NAME_JUF_OP = "java.util.function.UnaryOperator";
    private static final String NAME_JUF_DOUBLEOP = "java.util.function.DoubleUnaryOperator";
    private static final String NAME_JUF_INTOP = "java.util.function.IntUnaryOperator";
    private static final String NAME_JUF_LONGOP = "java.util.function.LongUnaryOperator";

    public WithByFieldProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.WithBy");
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField) {
        if (psiClass == null) {
            WithByFieldProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            WithByFieldProcessor.$$$reportNull$$$0(1);
        }
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(2);
        }
        AccessorsInfo accessorsInfo = WithByFieldProcessor.buildAccessorsInfo(psiField);
        return Collections.singletonList(LombokUtils.getWithByName((PsiVariable)psiField, accessorsInfo));
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            WithByFieldProcessor.$$$reportNull$$$0(3);
        }
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            WithByFieldProcessor.$$$reportNull$$$0(5);
        }
        this.validateOnXAnnotations(psiAnnotation, psiField, builder, "onParam");
        PsiClass containingClass = psiField.getContainingClass();
        boolean valid = null != containingClass;
        valid &= WithByFieldProcessor.validateVisibility(psiAnnotation);
        AccessorsInfo accessorsInfo = WithByFieldProcessor.buildAccessorsInfo(psiField);
        String withByMethodName = LombokUtils.getWithByName((PsiVariable)psiField, accessorsInfo);
        valid &= WithByFieldProcessor.validMethodName(withByMethodName, builder);
        valid &= WithByFieldProcessor.validName(psiField, withByMethodName, builder);
        valid &= WithByFieldProcessor.validNonStatic(psiField, withByMethodName, builder);
        if (valid &= WithByFieldProcessor.validNonFinalInitialized(psiField, withByMethodName, builder)) {
            Collection<PsiMethod> existingMethods = WithByFieldProcessor.filterToleratedElements(PsiClassUtil.collectClassMethodsIntern(containingClass));
            valid = WithByFieldProcessor.validIsWithByUnique(psiField, accessorsInfo, existingMethods, builder);
        }
        return valid;
    }

    private static boolean validateVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String methodVisibility;
        if (psiAnnotation == null) {
            WithByFieldProcessor.$$$reportNull$$$0(6);
        }
        return null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
    }

    private static boolean validMethodName(@Nullable String withByMethodName, @NotNull ProblemSink builder) {
        if (builder == null) {
            WithByFieldProcessor.$$$reportNull$$$0(7);
        }
        if (Strings.isEmpty((String)withByMethodName)) {
            builder.addWarningMessage("inspection.message.withby.not.generating.filed.name.not.fit", withByMethodName);
            return false;
        }
        return true;
    }

    private static boolean validName(@NotNull PsiField psiField, @NotNull String withByMethodName, @NotNull ProblemSink builder) {
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(8);
        }
        if (withByMethodName == null) {
            WithByFieldProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            WithByFieldProcessor.$$$reportNull$$$0(10);
        }
        if (psiField.getName().startsWith("$")) {
            builder.addWarningMessage("inspection.message.withby.not.generating.field.name.reserved", withByMethodName);
            return false;
        }
        return true;
    }

    private static boolean validNonStatic(@NotNull PsiField psiField, @NotNull String withByMethodName, @NotNull ProblemSink builder) {
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(11);
        }
        if (withByMethodName == null) {
            WithByFieldProcessor.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            WithByFieldProcessor.$$$reportNull$$$0(13);
        }
        if (psiField.hasModifierProperty("static")) {
            builder.addWarningMessage("inspection.message.withby.not.generating.field.static", withByMethodName).withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "static", false, false));
            return false;
        }
        return true;
    }

    private static boolean validNonFinalInitialized(@NotNull PsiField psiField, @NotNull String withByMethodName, @NotNull ProblemSink builder) {
        PsiClass psiClass;
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(14);
        }
        if (withByMethodName == null) {
            WithByFieldProcessor.$$$reportNull$$$0(15);
        }
        if (builder == null) {
            WithByFieldProcessor.$$$reportNull$$$0(16);
        }
        if (null != (psiClass = psiField.getContainingClass()) && psiField.hasModifierProperty("final") && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Value") && psiField.hasInitializer() && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, "lombok.Builder.Default")) {
            builder.addWarningMessage("inspection.message.withby.not.generating.field.final.initialized", withByMethodName).withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "final", false, false));
            return false;
        }
        return true;
    }

    private static boolean validIsWithByUnique(@NotNull PsiField psiField, @NotNull AccessorsInfo accessorsInfo, @NotNull Collection<PsiMethod> existingMethods, @NotNull ProblemSink builder) {
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(17);
        }
        if (accessorsInfo == null) {
            WithByFieldProcessor.$$$reportNull$$$0(18);
        }
        if (existingMethods == null) {
            WithByFieldProcessor.$$$reportNull$$$0(19);
        }
        if (builder == null) {
            WithByFieldProcessor.$$$reportNull$$$0(20);
        }
        List<String> possibleMethodNames = LombokUtils.toAllWithByNames(accessorsInfo, psiField.getName(), PsiTypes.booleanType().equals((Object)psiField.getType()));
        for (String withByName : possibleMethodNames) {
            if (!PsiMethodUtil.hasSimilarMethod(existingMethods, withByName, 1)) continue;
            builder.addWarningMessage("inspection.message.withby.not.generating.method.already.exists", withByName);
            return false;
        }
        return true;
    }

    private static AccessorsInfo buildAccessorsInfo(@NotNull PsiField psiField) {
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(21);
        }
        return AccessorsInfo.buildFor(psiField).withFluent(false);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        AccessorsInfo accessorsInfo;
        PsiMethod method;
        String methodModifier;
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(22);
        }
        if (psiAnnotation == null) {
            WithByFieldProcessor.$$$reportNull$$$0(23);
        }
        if (target == null) {
            WithByFieldProcessor.$$$reportNull$$$0(24);
        }
        if ((methodModifier = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null && (method = this.createWithByMethod(psiField, methodModifier, accessorsInfo = WithByFieldProcessor.buildAccessorsInfo(psiField), nameHint)) != null) {
            target.add((PsiElement)method);
        }
    }

    @Nullable
    public PsiMethod createWithByMethod(@NotNull PsiField psiField, @NotNull String methodModifier, @NotNull AccessorsInfo accessorsInfo, @Nullable String nameHint) {
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(25);
        }
        if (methodModifier == null) {
            WithByFieldProcessor.$$$reportNull$$$0(26);
        }
        if (accessorsInfo == null) {
            WithByFieldProcessor.$$$reportNull$$$0(27);
        }
        LombokLightMethodBuilder methodBuilder = null;
        PsiClass psiFieldContainingClass = psiField.getContainingClass();
        if (psiFieldContainingClass != null) {
            String withByName = LombokUtils.getWithByName((PsiVariable)psiField, accessorsInfo);
            if (nameHint != null && !nameHint.equals(withByName)) {
                return null;
            }
            PsiClassType returnType = PsiClassUtil.getTypeWithGenerics(psiFieldContainingClass);
            methodBuilder = new LombokLightMethodBuilder(psiField.getManager(), withByName).withMethodReturnType((PsiType)returnType).withContainingClass(psiFieldContainingClass).withNavigationElement((PsiElement)psiField).withModifier(methodModifier).withPureContract().withWriteAccess();
            if (accessorsInfo.isMakeFinal()) {
                methodBuilder.withModifier("final");
            }
            PsiAnnotation withByAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.experimental.WithBy");
            LombokCopyableAnnotations.copyOnXAnnotations(withByAnnotation, (PsiModifierList)methodBuilder.getModifierList(), "onMethod");
            WithByParts withByParts = WithByParts.create((PsiVariable)psiField);
            PsiType withByMethodParameterType = null != withByParts.parameterizer ? PsiTypeUtil.createCollectionType(psiField.getManager(), withByParts.functionalInterfaceName, withByParts.parameterizer.toArray(PsiType.EMPTY_ARRAY)) : PsiTypeUtil.createCollectionType(psiField.getManager(), withByParts.functionalInterfaceName, new PsiType[0]);
            LombokLightParameter methodParameter = new LombokLightParameter(WITH_BY_METHOD_PARAMETER_NAME, withByMethodParameterType, (PsiElement)methodBuilder);
            methodParameter.setModifiers("final");
            methodBuilder.withParameter(methodParameter);
            LombokLightModifierList methodParameterModifierList = methodParameter.getModifierList();
            LombokCopyableAnnotations.copyCopyableAnnotations(psiField, methodParameterModifierList, LombokCopyableAnnotations.BASE_COPYABLE);
            String paramString = WithByFieldProcessor.getConstructorCall(psiField, psiFieldContainingClass, withByParts);
            String blockText = String.format("return new %s(%s);", returnType.getCanonicalText(), paramString);
            methodBuilder.withBodyText(blockText);
            LombokAddNullAnnotations.createRelevantNonNullAnnotation(psiFieldContainingClass, methodBuilder);
        }
        return methodBuilder;
    }

    private static String getConstructorCall(@NotNull PsiField psiElement, @NotNull PsiClass psiClass, @NotNull WithByParts withByParts) {
        if (psiElement == null) {
            WithByFieldProcessor.$$$reportNull$$$0(28);
        }
        if (psiClass == null) {
            WithByFieldProcessor.$$$reportNull$$$0(29);
        }
        if (withByParts == null) {
            WithByFieldProcessor.$$$reportNull$$$0(30);
        }
        StringBuilder paramString = new StringBuilder();
        Collection<PsiField> requiredFields = AbstractConstructorClassProcessor.getRequiredFields(psiClass);
        for (PsiField psiField : requiredFields) {
            String classFieldName = psiField.getName();
            if (psiField.equals((Object)psiElement)) {
                if (Strings.isNotEmpty((String)withByParts.requiredCast())) {
                    paramString.append('(').append(withByParts.requiredCast()).append(')');
                }
                paramString.append(WITH_BY_METHOD_PARAMETER_NAME).append('.').append(withByParts.applyMethodName());
                paramString.append('(').append("this.").append(classFieldName).append(')');
            } else {
                paramString.append("this.").append(classFieldName);
            }
            paramString.append(',');
        }
        if (paramString.length() > 1) {
            paramString.deleteCharAt(paramString.length() - 1);
        }
        return paramString.toString();
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            WithByFieldProcessor.$$$reportNull$$$0(31);
        }
        if (psiAnnotation == null) {
            WithByFieldProcessor.$$$reportNull$$$0(32);
        }
        return LombokPsiElementUsage.READ_WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withByMethodName";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorsInfo";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingMethods";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withByParts";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/WithByFieldProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "validateVisibility";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "validMethodName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "validName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "validNonStatic";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "validNonFinalInitialized";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "validIsWithByUnique";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAccessorsInfo";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "createWithByMethod";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "getConstructorCall";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFieldUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record WithByParts(String applyMethodName, Collection<PsiType> parameterizer, String functionalInterfaceName, String requiredCast) {
        public static WithByParts create(@NotNull PsiVariable psiVariable) {
            if (psiVariable == null) {
                WithByParts.$$$reportNull$$$0(0);
            }
            PsiType psiFieldType = psiVariable.getType();
            String functionalInterfaceName = null;
            String requiredCast = null;
            List<Object> parameterizer = Collections.emptyList();
            boolean superExtendsStyle = true;
            String applyMethodName = "apply";
            if (psiFieldType instanceof PsiPrimitiveType) {
                if (PsiTypes.charType().equals((Object)psiFieldType)) {
                    requiredCast = "char";
                    functionalInterfaceName = WithByFieldProcessor.NAME_JUF_INTOP;
                } else if (PsiTypes.shortType().equals((Object)psiFieldType)) {
                    requiredCast = "short";
                    functionalInterfaceName = WithByFieldProcessor.NAME_JUF_INTOP;
                } else if (PsiTypes.byteType().equals((Object)psiFieldType)) {
                    requiredCast = "byte";
                    functionalInterfaceName = WithByFieldProcessor.NAME_JUF_INTOP;
                } else if (PsiTypes.intType().equals((Object)psiFieldType)) {
                    functionalInterfaceName = WithByFieldProcessor.NAME_JUF_INTOP;
                } else if (PsiTypes.longType().equals((Object)psiFieldType)) {
                    functionalInterfaceName = WithByFieldProcessor.NAME_JUF_LONGOP;
                } else if (PsiTypes.floatType().equals((Object)psiFieldType)) {
                    functionalInterfaceName = WithByFieldProcessor.NAME_JUF_DOUBLEOP;
                    requiredCast = "float";
                } else if (PsiTypes.doubleType().equals((Object)psiFieldType)) {
                    functionalInterfaceName = WithByFieldProcessor.NAME_JUF_DOUBLEOP;
                } else if (PsiTypes.booleanType().equals((Object)psiFieldType)) {
                    functionalInterfaceName = WithByFieldProcessor.NAME_JUF_OP;
                    Project project = psiVariable.getProject();
                    parameterizer = Collections.singletonList(PsiType.getTypeByName((String)"java.lang.Boolean", (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
                    superExtendsStyle = false;
                }
            }
            if (functionalInterfaceName == null) {
                functionalInterfaceName = WithByFieldProcessor.NAME_JUF_FUNCTION;
                parameterizer = Collections.singletonList(psiFieldType);
            }
            if (WithByFieldProcessor.NAME_JUF_INTOP.equals(functionalInterfaceName)) {
                applyMethodName = "applyAsInt";
            }
            if (WithByFieldProcessor.NAME_JUF_LONGOP.equals(functionalInterfaceName)) {
                applyMethodName = "applyAsLong";
            }
            if (WithByFieldProcessor.NAME_JUF_DOUBLEOP.equals(functionalInterfaceName)) {
                applyMethodName = "applyAsDouble";
            }
            if (!parameterizer.isEmpty() && superExtendsStyle) {
                PsiType psiType = (PsiType)parameterizer.get(0);
                PsiWildcardType parameterizer1 = PsiWildcardType.createSuper((PsiManager)psiVariable.getManager(), (PsiType)psiType);
                PsiWildcardType parameterizer2 = PsiWildcardType.createExtends((PsiManager)psiVariable.getManager(), (PsiType)psiType);
                parameterizer = Arrays.asList(parameterizer1, parameterizer2);
            }
            return new WithByParts(applyMethodName, parameterizer, functionalInterfaceName, requiredCast);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "de/plushnikov/intellij/plugin/processor/field/WithByFieldProcessor$WithByParts", "create"));
        }
    }
}

