/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.db;

import com.intellij.clouds.kubernetes.db.KubernetesDBPortForwardingConfig;
import com.intellij.clouds.kubernetes.db.KubernetesProviderForDB;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.view.execution.KubernetesPortForwardingService;
import com.intellij.kubernetes.view.execution.PortForwardingProcess;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesProviderForDB;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "startPortForwardingOrGetExistingProcess", "Lcom/intellij/kubernetes/view/execution/PortForwardingProcess;", "config", "Lcom/intellij/clouds/kubernetes/db/KubernetesDBPortForwardingConfig;", "stopProcess", "", "getKubernetesApiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "Companion", "intellij.clouds.kubernetes.db"})
public final class KubernetesProviderForDB {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;

    public KubernetesProviderForDB(@NotNull Project project, @NotNull CoroutineScope coroutineScope2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope2, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope2;
        SimpleMessageBusConnection mbConnection = this.project.getMessageBus().connect(this.coroutineScope);
        Topic topic = JdbcDriverManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        mbConnection.subscribe(topic, (Object)new JdbcDriverManager.Listener(){

            public void onTerminated(LocalDataSource dataSource, ConsoleRunConfiguration configuration) {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                KubernetesDBPortForwardingConfig config = KubernetesDBPortForwardingConfig.Companion.loadConfig(dataSource);
                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, config, null){
                    int label;
                    final /* synthetic */ KubernetesProviderForDB this$0;
                    final /* synthetic */ KubernetesDBPortForwardingConfig $config;
                    {
                        this.this$0 = $receiver;
                        this.$config = $config;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = CoroutinesKt.readAction(() -> onTerminated.1.invokeSuspend$lambda$0(this.this$0, this.$config), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(KubernetesProviderForDB this$0, KubernetesDBPortForwardingConfig $config) {
                        KubernetesProviderForDB.access$stopProcess(this$0, $config);
                        return Unit.INSTANCE;
                    }
                }), (int)3, null);
            }
        });
    }

    @RequiresWriteLock
    @NotNull
    public final PortForwardingProcess startPortForwardingOrGetExistingProcess(@NotNull KubernetesDBPortForwardingConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        KubernetesApiModelInterface apiModel = this.getKubernetesApiModel(config);
        return KubernetesPortForwardingService.Companion.getInstance().getOrCreatePortForwarding(apiModel, config.asPortForwarding(), true);
    }

    private final void stopProcess(KubernetesDBPortForwardingConfig config) {
        PortForwardingProcess portForwardingProcess = KubernetesPortForwardingService.Companion.getInstance().getPortForwardingProcess(this.getKubernetesApiModel(config), config.asPortForwarding());
        if (portForwardingProcess != null) {
            portForwardingProcess.stop();
        }
    }

    private final KubernetesApiModelInterface getKubernetesApiModel(KubernetesDBPortForwardingConfig config) {
        Context context = config.findMatchingContext(this.project);
        if (context == null) {
            throw new IllegalStateException("Can't find context: " + config.getContextName());
        }
        Context context2 = context;
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesApiProvider.Companion.getInstance(this.project).findModel(context2);
        if (kubernetesApiModelInterface == null) {
            throw new IllegalStateException("Can't find apiModel: " + config.getContextName());
        }
        KubernetesApiModelInterface apiModel = kubernetesApiModelInterface;
        return apiModel;
    }

    public static final /* synthetic */ void access$stopProcess(KubernetesProviderForDB $this, KubernetesDBPortForwardingConfig config) {
        $this.stopProcess(config);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesProviderForDB$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/clouds/kubernetes/db/KubernetesProviderForDB;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes.db"})
    @SourceDebugExtension(value={"SMAP\nKubernetesProviderForDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesProviderForDB.kt\ncom/intellij/clouds/kubernetes/db/KubernetesProviderForDB$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,74:1\n30#2,2:75\n*S KotlinDebug\n*F\n+ 1 KubernetesProviderForDB.kt\ncom/intellij/clouds/kubernetes/db/KubernetesProviderForDB$Companion\n*L\n25#1:75,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KubernetesProviderForDB getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KubernetesProviderForDB> serviceClass$iv = KubernetesProviderForDB.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesProviderForDB)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

