/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsStatisticsCollectorKt;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsUtilValidator;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u000e\u0010\u0015\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001c\u0010\u0019\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001a\u001a\u00020\u0010H\u0007J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointsUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "WITHIN_SESSION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "TYPE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getTYPE_FIELD", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "BREAKPOINT_ADDED", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "BREAKPOINT_VERIFIED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "reportNewBreakpoint", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "type", "Lcom/intellij/xdebugger/breakpoints/XBreakpointType;", "withinSession", "", "reportBreakpointVerified", "time", "getGroup", "intellij.platform.debugger.impl"})
public final class BreakpointsUsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final BreakpointsUsageCollector INSTANCE = new BreakpointsUsageCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("debugger.breakpoints.usage", 4, null, 4, null);
    @NotNull
    private static final BooleanEventField WITHIN_SESSION_FIELD = EventFields.Boolean((String)"within_session");
    @NotNull
    private static final StringEventField TYPE_FIELD = EventFields.StringValidatedByCustomRule((String)"type", BreakpointsUtilValidator.class);
    @NotNull
    private static final VarargEventId BREAKPOINT_ADDED;
    @NotNull
    private static final EventId1<Long> BREAKPOINT_VERIFIED;

    private BreakpointsUsageCollector() {
    }

    @NotNull
    public final StringEventField getTYPE_FIELD() {
        return TYPE_FIELD;
    }

    @JvmStatic
    public static final void reportNewBreakpoint(@NotNull XBreakpoint<?> breakpoint2, @NotNull XBreakpointType<?, ?> type, boolean withinSession) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (breakpoint2 instanceof XBreakpointBase) {
            List data = new ArrayList();
            data.addAll((Collection)BreakpointsStatisticsCollectorKt.getType(type));
            data.add(WITHIN_SESSION_FIELD.with((Object)withinSession));
            BREAKPOINT_ADDED.log(((XBreakpointBase)breakpoint2).getProject(), data);
        }
    }

    @JvmStatic
    public static final void reportBreakpointVerified(@NotNull XBreakpoint<?> breakpoint2, long time) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        if (breakpoint2 instanceof XBreakpointBase) {
            BREAKPOINT_VERIFIED.log(((XBreakpointBase)breakpoint2).getProject(), (Object)time);
        }
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        EventField[] eventFieldArray = new EventField[3];
        eventFieldArray[0] = WITHIN_SESSION_FIELD;
        eventFieldArray[1] = EventFields.PluginInfo;
        eventFieldArray[2] = TYPE_FIELD;
        BREAKPOINT_ADDED = GROUP.registerVarargEvent("breakpoint.added", eventFieldArray);
        BREAKPOINT_VERIFIED = GROUP.registerEvent("breakpoint.verified", (EventField)EventFields.Long$default((String)"time", null, (int)2, null));
    }
}

