/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XDebuggerBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class BreakpointEditor {
    private JPanel myMainPanel;
    private JButton myDoneButton;
    private JPanel myPropertiesPlaceholder;
    private ActionLink myShowMoreOptionsLink;
    private Delegate myDelegate;

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        AnAction action = ActionManager.getInstance().getAction("ViewBreakpoints");
        String shortcutText = action != null ? KeymapUtil.getFirstKeyboardShortcutText((AnAction)action) : null;
        Object text = XDebuggerBundle.message((String)"xbreakpoints.popup.more.label", (Object[])new Object[0]);
        if (shortcutText != null) {
            text = (String)text + " (" + shortcutText + ")";
        }
        this.myShowMoreOptionsLink = new ActionLink((String)text, e -> {
            if (this.myDelegate != null) {
                this.myDelegate.more();
            }
        });
    }

    public void setShowMoreOptionsLink(boolean b) {
        this.myShowMoreOptionsLink.setVisible(b);
    }

    public BreakpointEditor() {
        this.$$$setupUI$$$();
        this.myDoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointEditor.this.done();
            }
        });
        DumbAwareAction doneAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                JComboBox comboBox;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.update(e);
                Project project = 2.getEventProject((AnActionEvent)e);
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                boolean disabled = project != null && (LookupManager.getInstance((Project)project).getActiveLookup() != null || editor != null && TemplateManager.getInstance((Project)project).getActiveTemplate(editor) != null);
                Component owner = IdeFocusManager.findInstance().getFocusOwner();
                if (owner != null && (comboBox = (JComboBox)ComponentUtil.getParentOfType(JComboBox.class, (Component)owner)) != null && comboBox.isPopupVisible()) {
                    disabled = true;
                }
                e.getPresentation().setEnabled(!disabled && (editor == null || StringUtil.isEmpty((String)editor.getSelectionModel().getSelectedText())));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(2);
                }
                BreakpointEditor.this.done();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xdebugger/impl/ui/BreakpointEditor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xdebugger/impl/ui/BreakpointEditor$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        doneAction.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.ESCAPE, CommonShortcuts.ENTER, CommonShortcuts.getCtrlEnter()}), (JComponent)this.myMainPanel);
        this.myMainPanel.setFocusCycleRoot(true);
        this.myMainPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    private void done() {
        if (this.myDelegate != null) {
            this.myDelegate.done();
        }
    }

    public void setPropertiesPanel(JComponent p) {
        this.myPropertiesPlaceholder.removeAll();
        this.myPropertiesPlaceholder.add((Component)p, "Center");
    }

    public void setDelegate(Delegate d) {
        this.myDelegate = d;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.myPropertiesPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myDoneButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", BreakpointEditor.class).getString("done.action.text"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ActionLink actionLink = this.myShowMoreOptionsLink;
        jPanel3.add((Component)actionLink, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Delegate {
        public void done();

        public void more();
    }
}

