/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.attach.dialog;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachHostProvider;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachDialogHostType;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachToProcessDialog;
import com.intellij.xdebugger.impl.util.DisposableUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/AttachToProcessDialogFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "currentDialog", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/AttachToProcessDialog;", "showDialog", "", "attachDebuggerProviders", "", "Lcom/intellij/xdebugger/attach/XAttachDebuggerProvider;", "attachHosts", "Lcom/intellij/xdebugger/attach/XAttachHostProvider;", "Lcom/intellij/xdebugger/attach/XAttachHost;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getOpenDialog", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAttachToProcessDialogFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachToProcessDialogFactory.kt\ncom/intellij/xdebugger/impl/ui/attach/dialog/AttachToProcessDialogFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class AttachToProcessDialogFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private AttachToProcessDialog currentDialog;
    @NotNull
    private static final DataKey<AttachDialogHostType> DEFAULT_VIEW_HOST_TYPE = DataKey.Companion.create("ATTACH_DIALOG_VIEW_HOST_TYPE");

    public AttachToProcessDialogFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void showDialog(@NotNull List<? extends XAttachDebuggerProvider> attachDebuggerProviders, @NotNull List<? extends XAttachHostProvider<XAttachHost>> attachHosts, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter(attachDebuggerProviders, (String)"attachDebuggerProviders");
        Intrinsics.checkNotNullParameter(attachHosts, (String)"attachHosts");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ThreadingAssertions.assertEventDispatchThread();
        AttachDialogHostType defaultViewHostType = AttachToProcessDialogFactory.Companion.getDefaultViewHostType(context);
        AttachToProcessDialog currentDialogInstance = this.getOpenDialog();
        if (currentDialogInstance != null) {
            currentDialogInstance.setAttachView(defaultViewHostType);
            return;
        }
        AttachToProcessDialog dialog2 = new AttachToProcessDialog(this.project, attachDebuggerProviders, attachHosts, context, defaultViewHostType, null);
        Disposable disposable = dialog2.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        DisposableUtilKt.onTermination(disposable, (Function0<Unit>)((Function0)() -> AttachToProcessDialogFactory.showDialog$lambda$0(this, dialog2)));
        this.currentDialog = dialog2;
        dialog2.show();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final AttachToProcessDialog getOpenDialog() {
        AttachToProcessDialog attachToProcessDialog;
        AttachToProcessDialog attachToProcessDialog2 = this.currentDialog;
        if (attachToProcessDialog2 == null) return null;
        AttachToProcessDialog it = attachToProcessDialog = attachToProcessDialog2;
        boolean bl = false;
        if (!it.isShowing()) return null;
        Disposable disposable = it.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        if (!DisposableUtilKt.isAlive(disposable)) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        AttachToProcessDialog attachToProcessDialog3 = attachToProcessDialog;
        return attachToProcessDialog3;
    }

    private static final void showDialog$lambda$0$0(AttachToProcessDialogFactory this$0, AttachToProcessDialog $dialog) {
        if (Intrinsics.areEqual((Object)((Object)this$0.currentDialog), (Object)((Object)$dialog))) {
            this$0.currentDialog = null;
        }
    }

    private static final Unit showDialog$lambda$0(AttachToProcessDialogFactory this$0, AttachToProcessDialog $dialog) {
        UIUtil.invokeLaterIfNeeded(() -> AttachToProcessDialogFactory.showDialog$lambda$0$0(this$0, $dialog));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/AttachToProcessDialogFactory$Companion;", "", "<init>", "()V", "DEFAULT_VIEW_HOST_TYPE", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/AttachDialogHostType;", "getDEFAULT_VIEW_HOST_TYPE$annotations", "getDEFAULT_VIEW_HOST_TYPE", "()Lcom/intellij/openapi/actionSystem/DataKey;", "getDefaultViewHostType", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<AttachDialogHostType> getDEFAULT_VIEW_HOST_TYPE() {
            return DEFAULT_VIEW_HOST_TYPE;
        }

        public static /* synthetic */ void getDEFAULT_VIEW_HOST_TYPE$annotations() {
        }

        private final AttachDialogHostType getDefaultViewHostType(DataContext dataContext) {
            AttachDialogHostType attachDialogHostType = (AttachDialogHostType)dataContext.getData(this.getDEFAULT_VIEW_HOST_TYPE());
            if (attachDialogHostType == null) {
                attachDialogHostType = AttachDialogHostType.LOCAL.INSTANCE;
            }
            return attachDialogHostType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

