/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LemmaRepetitionRule
extends Rule
implements DocumentRule {
    static final NodePattern auxiliaries = NodePattern.or(NodePattern.N.withHeadRelation("punct|case|mark|cc|compound:prt|det|aux.*|cop|flat"), NodePattern.N.pos("PRP.*|CD|W.*"), NodePattern.N.lemma("be|have|not|this|that|as|sic"), NodePattern.N.form("going|\\."), NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE));

    LemmaRepetitionRule() {
        super("Style.LEMMA_REPETITION", "A word repeated too often", "Check for words repeated again and again, where using synonyms or rephrasing might make reading more entertaining.", null, new Example("I said yes. He said no. Then I <b>said</b> maybe.", new String[0]));
    }

    @Override
    public boolean isEnabledByDefault(RuleClient client) {
        return false;
    }

    @Override
    public MatchingResult checkDocument(List<DocumentSentence.Analyzed> sentences) {
        List<List<DocumentSentence.Analyzed>> fragments = DocumentSentence.fragments(sentences);
        return MatchingResult.concat((Iterable<MatchingResult>)StreamEx.of(fragments).map(f -> this.matchFragment(((StreamEx)StreamEx.of((Collection)f).filter(s -> s.language == Language.ENGLISH)).map(s -> s.tree).nonNull().toList())));
    }

    @Override
    @NotNull
    public MatchingResult match(Tree tree) {
        return MatchingResult.EMPTY;
    }

    private MatchingResult matchFragment(List<Tree> sentences) {
        ArrayList<NodeRuleMatch> matches = new ArrayList<NodeRuleMatch>();
        List tokens = ((StreamEx)StreamEx.of(sentences).flatCollection(Tree::nodes).filter(n -> !auxiliaries.matches((Node)n))).toList();
        HashMap<String, TreeSet<Integer>> lemma2Indices = new HashMap<String, TreeSet<Integer>>();
        Tree lastReportedTree = null;
        for (int i = 0; i < tokens.size(); ++i) {
            Node token = (Node)tokens.get(i);
            if (CommonPatterns.capitalized.matches(token)) continue;
            List<String> lemmas = LemmaRepetitionRule.lemmas(token);
            for (String lemma : lemmas) {
                TreeSet indices = lemma2Indices.computeIfAbsent(lemma, __ -> new TreeSet());
                if (!indices.isEmpty() && ((Node)tokens.get((Integer)indices.last())).tree() == token.tree()) continue;
                indices.add(i);
            }
            String lemma = LemmaRepetitionRule.findRepeatedLemma(lemma2Indices, i, lemmas);
            if (lemma == null) continue;
            if (lastReportedTree != token.tree()) {
                lastReportedTree = token.tree();
                NodeMatch match = NodeMatch.EMPTY.withAnchor(token).withMessage("The word '" + lemma + "' is repeated too often. Consider rephrasing the text.").withActions(ActionSuggestion.REPHRASE);
                matches.add(new NodeRuleMatch((Rule)this, match));
            }
            lemma2Indices.remove(lemma);
        }
        return MatchingResult.from(matches);
    }

    @Nullable
    private static String findRepeatedLemma(Map<String, TreeSet<Integer>> lemma2Indices, int index, List<String> lemmas) {
        return StreamEx.of(lemmas).findFirst(lemma -> {
            TreeSet indices = (TreeSet)lemma2Indices.get(lemma);
            if (indices.size() >= 3) {
                Iterator iterator = indices.descendingIterator();
                iterator.next();
                iterator.next();
                int third = (Integer)iterator.next();
                return index - third < 20;
            }
            return false;
        }).orElse(null);
    }

    private static List<String> lemmas(Node token) {
        if (token.hasForm("people")) {
            return List.of("people");
        }
        return token.lemmaReadings();
    }
}

