/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointProperties;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointType;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0013\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u0013\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ \u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u001e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u001a\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\tj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/javascript/debugger/ChromeExceptionBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/javascript/debugger/breakpoints/JavaScriptExceptionBreakpointProperties;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "activeBreakpoints", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "value", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "exceptionCatchMode", "setExceptionCatchMode", "(Lorg/jetbrains/debugger/ExceptionCatchMode;)V", "registerBreakpoint", "", "breakpoint", "unregisterBreakpoint", "temporary", "", "updateExceptionBreakpointsForAllVms", "mode", "findBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getResult", "exceptionName", "", "isSuitable", "findActiveBreakpoint", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nChromeExceptionBreakpointHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeExceptionBreakpointHandler.kt\ncom/intellij/javascript/debugger/ChromeExceptionBreakpointHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1915#2,2:156\n*S KotlinDebug\n*F\n+ 1 ChromeExceptionBreakpointHandler.kt\ncom/intellij/javascript/debugger/ChromeExceptionBreakpointHandler\n*L\n74#1:156,2\n*E\n"})
public final class ChromeExceptionBreakpointHandler
extends XBreakpointHandler<XBreakpoint<JavaScriptExceptionBreakpointProperties>> {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> activeBreakpoints;
    @NotNull
    private volatile ExceptionCatchMode exceptionCatchMode;

    public ChromeExceptionBreakpointHandler(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        super(JavaScriptExceptionBreakpointType.class);
        this.debugProcess = debugProcess;
        this.activeBreakpoints = new HashSet();
        this.exceptionCatchMode = ExceptionCatchMode.NONE;
        this.debugProcess.getConnection().addDebugListener(new DebugEventListener(){

            public void childVmAdded(Vm childVm) {
                Intrinsics.checkNotNullParameter((Object)childVm, (String)"childVm");
                Promise promise = childVm.setBreakOnException(exceptionCatchMode);
                XDebugSession xDebugSession = debugProcess.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
                Object[] objectArray = new Object[]{childVm.getPresentableName()};
                promise.onError((Consumer)new RejectErrorReporter(xDebugSession, JSDebuggerBundle.message("chrome.breakpoint.error.cannot.set.exception.catch.mode", objectArray)));
            }
        });
    }

    private final void setExceptionCatchMode(ExceptionCatchMode value) {
        this.exceptionCatchMode = value;
        this.updateExceptionBreakpointsForAllVms(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBreakpoint(@NotNull XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint) {
        ExceptionCatchMode exceptionCatchMode;
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> hashSet = this.activeBreakpoints;
        synchronized (hashSet) {
            boolean bl = false;
            this.activeBreakpoints.add(breakpoint);
            exceptionCatchMode = ((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getUncaughtOnly() ? ExceptionCatchMode.UNCAUGHT : ExceptionCatchMode.ALL;
        }
        ExceptionCatchMode newMode = exceptionCatchMode;
        if (newMode == this.exceptionCatchMode || this.exceptionCatchMode == ExceptionCatchMode.ALL) {
            return;
        }
        this.setExceptionCatchMode(newMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBreakpoint(@NotNull XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint, boolean temporary) {
        ExceptionCatchMode exceptionCatchMode;
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> hashSet = this.activeBreakpoints;
        synchronized (hashSet) {
            boolean bl = false;
            ExceptionCatchMode newMode = null;
            this.activeBreakpoints.remove(breakpoint);
            if (this.activeBreakpoints.isEmpty()) {
                newMode = ExceptionCatchMode.NONE;
            } else {
                newMode = ExceptionCatchMode.UNCAUGHT;
                Iterator<XBreakpoint<JavaScriptExceptionBreakpointProperties>> iterator = this.activeBreakpoints.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<XBreakpoint<JavaScriptExceptionBreakpointProperties>> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    XBreakpoint<JavaScriptExceptionBreakpointProperties> activeBreakpoint;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                    if (((JavaScriptExceptionBreakpointProperties)activeBreakpoint.getProperties()).getUncaughtOnly()) continue;
                    newMode = ExceptionCatchMode.ALL;
                    break;
                }
            }
            exceptionCatchMode = newMode;
        }
        ExceptionCatchMode newMode = exceptionCatchMode;
        if (newMode != this.exceptionCatchMode) {
            this.setExceptionCatchMode(newMode);
        }
    }

    private final void updateExceptionBreakpointsForAllVms(ExceptionCatchMode mode) {
        Iterable $this$forEach$iv = this.debugProcess.getCollectVMs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vm it = (Vm)element$iv;
            boolean bl = false;
            Promise promise = it.setBreakOnException(mode);
            XDebugSession xDebugSession = this.debugProcess.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
            Object[] objectArray = new Object[]{it.getPresentableName()};
            promise.onError((Consumer)new RejectErrorReporter(xDebugSession, JSDebuggerBundle.message("chrome.breakpoint.error.cannot.set.exception.catch.mode", objectArray)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<XBreakpoint<?>> findBreakpoint(@Nullable ExceptionData exceptionData) {
        if (exceptionData == null) {
            return Promises.rejectedPromise((String)"Internal error");
        }
        Value exceptionValue = exceptionData.getExceptionValue();
        if (!(exceptionValue instanceof ObjectValue)) {
            return Promises.resolvedPromise(this.getResult(exceptionData, null));
        }
        ObjectValue object = (ObjectValue)exceptionValue;
        String className = object.getClassName();
        if (className != null) {
            HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> hashSet = this.activeBreakpoints;
            synchronized (hashSet) {
                boolean bl = false;
                Iterator<XBreakpoint<JavaScriptExceptionBreakpointProperties>> iterator = this.activeBreakpoints.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<XBreakpoint<JavaScriptExceptionBreakpointProperties>> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                    if (!Intrinsics.areEqual((Object)className, (Object)((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName()) || !this.isSuitable(exceptionData, breakpoint)) continue;
                    Promise promise = Promises.resolvedPromise(breakpoint);
                    return promise;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        Promise promise = object.getProperties().then(arg_0 -> ChromeExceptionBreakpointHandler.findBreakpoint$lambda$2(arg_0 -> ChromeExceptionBreakpointHandler.findBreakpoint$lambda$1(this, exceptionData, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final XBreakpoint<?> getResult(ExceptionData exceptionData, String exceptionName) {
        XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint = this.findActiveBreakpoint(exceptionName);
        return breakpoint != null && this.isSuitable(exceptionData, breakpoint) ? breakpoint : null;
    }

    private final boolean isSuitable(ExceptionData exceptionData, XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint) {
        return !((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getUncaughtOnly() || exceptionData.isUncaught() != ThreeState.NO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final XBreakpoint<JavaScriptExceptionBreakpointProperties> findActiveBreakpoint(String exceptionName) {
        HashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> hashSet = this.activeBreakpoints;
        synchronized (hashSet) {
            XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint;
            boolean bl = false;
            XBreakpoint<JavaScriptExceptionBreakpointProperties> defaultBreakpoint = null;
            Iterator<XBreakpoint<JavaScriptExceptionBreakpointProperties>> iterator = this.activeBreakpoints.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<XBreakpoint<JavaScriptExceptionBreakpointProperties>> iterator2 = iterator;
            while (true) {
                if (!iterator2.hasNext()) {
                    return defaultBreakpoint;
                }
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                String name = ((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName();
                if (name == null) {
                    defaultBreakpoint = breakpoint;
                    if (exceptionName != null) continue;
                    return defaultBreakpoint;
                }
                if (Intrinsics.areEqual((Object)name, (Object)exceptionName)) break;
            }
            return breakpoint;
        }
    }

    private static final XBreakpoint findBreakpoint$lambda$1(ChromeExceptionBreakpointHandler this$0, ExceptionData $exceptionData, List it) {
        Value value;
        Variable variable;
        Variable name = null;
        Variable type = null;
        for (Variable variable2 : it) {
            if (Intrinsics.areEqual((Object)"name", (Object)variable2.getName())) {
                name = variable2;
            } else if (Intrinsics.areEqual((Object)"type", (Object)variable2.getName())) {
                type = variable2;
            }
            if (name == null) continue;
        }
        if ((variable = name) == null) {
            variable = type;
        }
        Variable nameProperty = variable;
        String exceptionName = null;
        if (nameProperty != null && (value = nameProperty.getValue()) != null) {
            exceptionName = value.getValueString();
        }
        return this$0.getResult($exceptionData, exceptionName);
    }

    private static final XBreakpoint findBreakpoint$lambda$2(Function1 $tmp0, Object p0) {
        return (XBreakpoint)$tmp0.invoke(p0);
    }
}

