/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.console.ConsoleHtmlPanel;
import com.intellij.javascript.debugger.console.jcef.JCEFConsoleHtmlPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefApp;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanelProvider;", "", "<init>", "()V", "Companion", "intellij.javascript.debugger.backend"})
public final class ConsoleHtmlPanelProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanelProvider$Companion;", "", "<init>", "()V", "webConsoleAvailable", "", "getWebConsoleAvailable", "()Z", "createHtmlPanel", "Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;", "project", "Lcom/intellij/openapi/project/Project;", "isJcefAvailable", "intellij.javascript.debugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getWebConsoleAvailable() {
            return Registry.Companion.is("js.debugger.webconsole") && this.isJcefAvailable();
        }

        @Nullable
        public final ConsoleHtmlPanel createHtmlPanel(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean useWebConsoleSetting = Registry.Companion.is("js.debugger.webconsole");
            if (useWebConsoleSetting && !this.isJcefAvailable()) {
                NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("JavaScript Debugger Console");
                String string = JSDebuggerBundle.message("js.console.jcef.check.notification", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Notification notification = notificationGroup.createNotification(string, NotificationType.WARNING);
                notification.notify(project);
            }
            return this.getWebConsoleAvailable() ? (ConsoleHtmlPanel)new JCEFConsoleHtmlPanel() : null;
        }

        private final boolean isJcefAvailable() {
            return JBCefApp.isSupported();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

