/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.completion.ml.VcsFeatureProviderKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J,\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/ml/VcsFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "<init>", "()V", "getName", "", "calculateFeatures", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "intellij.completionMlRanking"})
public final class VcsFeatureProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "vcs";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Map features;
        block4: {
            PsiElement psi;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
            Integer changesCount = (Integer)contextFeatures.getUserData(VcsFeatureProviderKt.getChangesCountKey());
            if (changesCount == null || changesCount > 1000) {
                return MapsKt.emptyMap();
            }
            features = new LinkedHashMap();
            Project project = location.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PsiElement psiElement = psi = element.getPsiElement();
            Object psiFile = psiElement != null ? psiElement.getContainingFile() : null;
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null || (psiFile2 = psiFile2.getViewProvider()) == null || (psiFile2 = psiFile2.getVirtualFile()) == null) break block4;
            PsiFile file = psiFile2;
            boolean bl = false;
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            Change change = changeListManager2.getChange((VirtualFile)file);
            if (change != null) {
                Change change2 = change;
                boolean bl2 = false;
                Map map = features;
                String string = "file_state";
                Change.Type type = change2.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
                MLFeatureValue mLFeatureValue = MLFeatureValue.Companion.categorical((Enum)type);
                map.put(string, mLFeatureValue);
                if (change2.getType() == Change.Type.MODIFICATION && psi instanceof PsiNameIdentifierOwner) {
                    LineStatusTrackerI lineStatusTracker;
                    Document document = PsiDocumentManager.getInstance((Project)project2).getCachedDocument(psiFile);
                    TextRange range = ((PsiNameIdentifierOwner)psi).getTextRange();
                    if (document != null && range != null && range.getEndOffset() <= document.getTextLength() && (lineStatusTracker = (LineStatusTrackerI)LineStatusTrackerManager.Companion.getInstance(project2).getLineStatusTracker(document)) != null && lineStatusTracker.isValid() && lineStatusTracker.isRangeModified(document.getLineNumber(range.getStartOffset()), document.getLineNumber(range.getEndOffset()))) {
                        features.put("declaration_is_changed", MLFeatureValue.Companion.binary(true));
                    }
                }
            }
        }
        return features;
    }
}

