/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.tracker;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.personalization.UserFactorDescriptions;
import com.intellij.completion.ml.personalization.UserFactorStorage;
import com.intellij.completion.ml.personalization.impl.CompletionFinishTypeUpdater;
import com.intellij.completion.ml.personalization.impl.ItemPositionUpdater;
import com.intellij.completion.ml.personalization.impl.MnemonicsUsageUpdater;
import com.intellij.completion.ml.personalization.impl.PrefixLengthUpdater;
import com.intellij.completion.ml.personalization.impl.PrefixMatchingTypeUpdater;
import com.intellij.completion.ml.personalization.impl.TemplatesUsageUpdater;
import com.intellij.completion.ml.storage.MutableElementStorage;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.completion.ml.templates.LiveTemplateUsageTracker;
import com.intellij.completion.ml.tracker.LookupFinishListener;
import com.intellij.completion.ml.util.LookupElementExtensionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.textMatching.PrefixMatchingType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/tracker/LookupCompletedTracker;", "Lcom/intellij/completion/ml/tracker/LookupFinishListener;", "<init>", "()V", "cancelled", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "canceledExplicitly", "", "typedSelect", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "explicitSelect", "intellij.completionMlRanking"})
public final class LookupCompletedTracker
extends LookupFinishListener {
    @Override
    public void cancelled(@NotNull LookupImpl lookup, boolean canceledExplicitly) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        UserFactorStorage.Companion.applyOnBoth(project, UserFactorDescriptions.INSTANCE.getCOMPLETION_FINISH_TYPE(), LookupCompletedTracker::cancelled$lambda$0);
    }

    @Override
    public void typedSelect(@NotNull LookupImpl lookup, @NotNull LookupElement element) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        UserFactorStorage.Companion.applyOnBoth(project, UserFactorDescriptions.INSTANCE.getCOMPLETION_FINISH_TYPE(), LookupCompletedTracker::typedSelect$lambda$0);
    }

    @Override
    public void explicitSelect(@NotNull LookupImpl lookup, @NotNull LookupElement element) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        UserFactorStorage.Companion.applyOnBoth(project, UserFactorDescriptions.INSTANCE.getCOMPLETION_FINISH_TYPE(), LookupCompletedTracker::explicitSelect$lambda$0);
        int prefixLength = lookup.getPrefixLength(element);
        Project project2 = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        UserFactorStorage.Companion.applyOnBoth(project2, UserFactorDescriptions.INSTANCE.getPREFIX_LENGTH_ON_COMPLETION(), arg_0 -> LookupCompletedTracker.explicitSelect$lambda$1(prefixLength, arg_0));
        int itemPosition = lookup.getSelectedIndex();
        if (itemPosition != -1) {
            Project project3 = lookup.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            UserFactorStorage.Companion.applyOnBoth(project3, UserFactorDescriptions.INSTANCE.getSELECTED_ITEM_POSITION(), arg_0 -> LookupCompletedTracker.explicitSelect$lambda$2(itemPosition, arg_0));
        }
        String string = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        String string2 = lookup.itemPattern(element);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"itemPattern(...)");
        boolean itemStartsWithPrefix = StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
        boolean isTemplate = LookupElementExtensionsKt.isLiveTemplate(element);
        Project project4 = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        UserFactorStorage.Companion.applyOnBoth(project4, UserFactorDescriptions.INSTANCE.getTEMPLATES_USAGE(), arg_0 -> LookupCompletedTracker.explicitSelect$lambda$3(itemStartsWithPrefix, isTemplate, arg_0));
        if (isTemplate) {
            LiveTemplateUsageTracker liveTemplateUsageTracker = LiveTemplateUsageTracker.Companion.getInstance();
            String string3 = element.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLookupString(...)");
            liveTemplateUsageTracker.incUseCount(string3);
        }
        if (prefixLength > 1) {
            PrefixMatchingType type;
            Project project5 = lookup.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
            UserFactorStorage.Companion.applyOnBoth(project5, UserFactorDescriptions.INSTANCE.getMNEMONICS_USAGE(), arg_0 -> LookupCompletedTracker.explicitSelect$lambda$4(itemStartsWithPrefix, arg_0));
            MutableLookupStorage mutableLookupStorage = MutableLookupStorage.Companion.get(lookup);
            MutableElementStorage storage = mutableLookupStorage != null ? mutableLookupStorage.getItemStorage(LookupElementExtensionsKt.idString(element)) : null;
            Object object = storage;
            Object var9_8 = object != null && (object = ((MutableElementStorage)object).getLastUsedFactors()) != null ? object.get("prefix_matching_type") : null;
            PrefixMatchingType prefixMatchingType = type = var9_8 instanceof PrefixMatchingType ? (PrefixMatchingType)var9_8 : null;
            if (type != null) {
                Project project6 = lookup.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
                UserFactorStorage.Companion.applyOnBoth(project6, UserFactorDescriptions.INSTANCE.getPREFIX_MATCHING_TYPE(), arg_0 -> LookupCompletedTracker.explicitSelect$lambda$5(type, arg_0));
            }
        }
    }

    private static final Unit cancelled$lambda$0(CompletionFinishTypeUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        updater.fireLookupCancelled();
        return Unit.INSTANCE;
    }

    private static final Unit typedSelect$lambda$0(CompletionFinishTypeUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        updater.fireTypedSelectPerformed();
        return Unit.INSTANCE;
    }

    private static final Unit explicitSelect$lambda$0(CompletionFinishTypeUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        updater.fireExplicitCompletionPerformed();
        return Unit.INSTANCE;
    }

    private static final Unit explicitSelect$lambda$1(int $prefixLength, PrefixLengthUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        updater.fireCompletionPerformed($prefixLength);
        return Unit.INSTANCE;
    }

    private static final Unit explicitSelect$lambda$2(int $itemPosition, ItemPositionUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        updater.fireCompletionPerformed($itemPosition);
        return Unit.INSTANCE;
    }

    private static final Unit explicitSelect$lambda$3(boolean $itemStartsWithPrefix, boolean $isTemplate, TemplatesUsageUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        updater.fireCompletionFinished($itemStartsWithPrefix, $isTemplate);
        return Unit.INSTANCE;
    }

    private static final Unit explicitSelect$lambda$4(boolean $itemStartsWithPrefix, MnemonicsUsageUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        updater.fireCompletionFinished(!$itemStartsWithPrefix);
        return Unit.INSTANCE;
    }

    private static final Unit explicitSelect$lambda$5(PrefixMatchingType $type, PrefixMatchingTypeUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        updater.fireCompletionPerformed($type);
        return Unit.INSTANCE;
    }
}

