/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J'\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction;", "insertAfter", "", "<init>", "(Z)V", "performAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "columnIndex", "", "findColumnIndex", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Document;I)Ljava/lang/Integer;", "update", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;Ljava/lang/Integer;)V", "InsertBefore", "InsertAfter", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nInsertTableColumnAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertTableColumnAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,41:1\n7#2,6:42\n*S KotlinDebug\n*F\n+ 1 InsertTableColumnAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction\n*L\n18#1:42,6\n*E\n"})
public abstract class InsertTableColumnAction
extends ColumnBasedTableAction {
    private final boolean insertAfter;

    public InsertTableColumnAction(boolean insertAfter) {
        this.insertAfter = insertAfter;
    }

    public /* synthetic */ InsertTableColumnAction(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Override
    protected void performAction(@NotNull Editor editor2, @NotNull MarkdownTable table, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        ActionsKt.runWriteAction(() -> InsertTableColumnAction.performAction$lambda$0(table, editor2, columnIndex, this));
    }

    @Override
    @Nullable
    protected Integer findColumnIndex(@NotNull PsiFile file, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Integer cellIndex = TableUtils.findCellIndex(file, offset);
        if (cellIndex != null) {
            return cellIndex;
        }
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.findSeparatorRow(file, offset);
        return markdownTableSeparatorRow != null ? markdownTableSeparatorRow.getColumnIndexFromOffset(offset) : null;
    }

    @Override
    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTable table, @Nullable Integer columnIndex) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event, table, columnIndex);
        MarkdownTable markdownTable = table;
        event.getPresentation().setEnabledAndVisible(markdownTable != null ? TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTable) : false);
    }

    private static final Unit performAction$lambda$0(MarkdownTable $table, Editor $editor, int $columnIndex, InsertTableColumnAction this$0) {
        Project project$iv = $table.getProject();
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable($table, $editor, $columnIndex, this$0){
            final /* synthetic */ MarkdownTable $table$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ int $columnIndex$inlined;
            final /* synthetic */ InsertTableColumnAction this$0;
            {
                this.$table$inlined = markdownTable;
                this.$editor$inlined = editor2;
                this.$columnIndex$inlined = n;
                this.this$0 = insertTableColumnAction;
            }

            public final void run() {
                boolean bl = false;
                Document document = this.$editor$inlined.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                TableModificationUtils.insertColumn$default(TableModificationUtils.INSTANCE, this.$table$inlined, document, this.$columnIndex$inlined, InsertTableColumnAction.access$getInsertAfter$p(this.this$0), null, 0, 24, null);
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    public InsertTableColumnAction() {
        this(false, 1, null);
    }

    public static final /* synthetic */ boolean access$getInsertAfter$p(InsertTableColumnAction $this) {
        return $this.insertAfter;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction$InsertAfter;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction;", "<init>", "()V", "intellij.markdown"})
    public static final class InsertAfter
    extends InsertTableColumnAction {
        public InsertAfter() {
            super(true);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction$InsertBefore;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction;", "<init>", "()V", "intellij.markdown"})
    public static final class InsertBefore
    extends InsertTableColumnAction {
        public InsertBefore() {
            super(false);
        }
    }
}

