/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.settings.MarkdownSettingsConfigurable;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/AdjustFontSizeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "HintComponent", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nAdjustFontSizeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdjustFontSizeAction.kt\norg/intellij/plugins/markdown/ui/actions/AdjustFontSizeAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class AdjustFontSizeAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownPreviewFileEditor editor2 = MarkdownActionUtil.findMarkdownPreviewEditor(event);
        if (editor2 == null) {
            boolean $i$a$-checkNotNull-AdjustFontSizeAction$actionPerformed$22 = false;
            String $i$a$-checkNotNull-AdjustFontSizeAction$actionPerformed$22 = "Preview editor should be obtainable from the action event";
            throw new IllegalStateException($i$a$-checkNotNull-AdjustFontSizeAction$actionPerformed$22.toString());
        }
        WeakReference<MarkdownHtmlPanel> weakReference = editor2.getUserData(MarkdownPreviewFileEditor.Companion.getPREVIEW_BROWSER());
        if (weakReference == null || (weakReference = (MarkdownHtmlPanel)weakReference.get()) == null) {
            return;
        }
        WeakReference<MarkdownHtmlPanel> preview = weakReference;
        if (!(preview instanceof MarkdownJCEFHtmlPanel)) {
            return;
        }
        HintComponent hintComponent = new HintComponent((MarkdownJCEFHtmlPanel)((Object)preview));
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)hintComponent, (JComponent)hintComponent).setRequestFocus(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup2 = jBPopup;
        RelativePoint point = (RelativePoint)event.getDataContext().getData(MarkdownPreviewFileEditor.Companion.getPREVIEW_POPUP_POINT$intellij_markdown());
        if (point != null) {
            popup2.show(point);
        } else {
            popup2.showInFocusCenter();
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownPreviewFileEditor editor2 = MarkdownActionUtil.findMarkdownPreviewEditor(event);
        event.getPresentation().setEnabledAndVisible(editor2 != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\n\u001a\u00020\u000b*\u00020\u0003H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/AdjustFontSizeAction$HintComponent;", "Ljavax/swing/JPanel;", "preview", "Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;", "<init>", "(Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;)V", "previewSettings", "Lorg/intellij/plugins/markdown/settings/MarkdownPreviewSettings;", "getPreviewSettings", "()Lorg/intellij/plugins/markdown/settings/MarkdownPreviewSettings;", "getCurrentFontSize", "", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nAdjustFontSizeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdjustFontSizeAction.kt\norg/intellij/plugins/markdown/ui/actions/AdjustFontSizeAction$HintComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,98:1\n1#2:99\n42#3,3:100\n*S KotlinDebug\n*F\n+ 1 AdjustFontSizeAction.kt\norg/intellij/plugins/markdown/ui/actions/AdjustFontSizeAction$HintComponent\n*L\n45#1:100,3\n*E\n"})
    private static final class HintComponent
    extends JPanel {
        /*
         * WARNING - void declaration
         */
        public HintComponent(@NotNull MarkdownJCEFHtmlPanel preview) {
            void $this$_init__u24lambda_u245;
            Object $this$_init__u24lambda_u244;
            Object $this$_init__u24lambda_u243;
            Object object;
            Intrinsics.checkNotNullParameter((Object)preview, (String)"preview");
            super(new FlowLayout(0, 10, 5));
            JBLabel jBLabel = new JBLabel(String.valueOf(((MarkdownPreviewSettings.State)this.getPreviewSettings().getState()).getFontSize()), 0);
            Object $this$_init__u24lambda_u240 = jBLabel;
            boolean bl = false;
            $this$_init__u24lambda_u240.setPreferredSize((Dimension)JBUI.size((int)22, (int)22));
            JBLabel fontSizeLabel = jBLabel;
            Object $this$_init__u24lambda_u241 = $this$_init__u24lambda_u240 = new JButton(AllIcons.General.Remove);
            boolean bl2 = false;
            ((JComponent)$this$_init__u24lambda_u241).setBorder(BorderFactory.createEmptyBorder());
            ((AbstractButton)$this$_init__u24lambda_u241).setContentAreaFilled(false);
            ((JComponent)$this$_init__u24lambda_u241).setPreferredSize((Dimension)JBUI.size((int)22, (int)22));
            Icon icon = AllIcons.General.Remove;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Remove");
            ((AbstractButton)$this$_init__u24lambda_u241).setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
            ((AbstractButton)$this$_init__u24lambda_u241).setEnabled(((MarkdownPreviewSettings.State)this.getPreviewSettings().getState()).getFontSize() != ((Number)CollectionsKt.first(MarkdownSettingsConfigurable.Companion.getFontSizeOptions())).intValue());
            Object decreaseButton = $this$_init__u24lambda_u240;
            Object $this$_init__u24lambda_u242 = object = new JButton(AllIcons.General.Add);
            boolean bl3 = false;
            ((JComponent)$this$_init__u24lambda_u242).setBorder(BorderFactory.createEmptyBorder());
            ((AbstractButton)$this$_init__u24lambda_u242).setContentAreaFilled(false);
            ((JComponent)$this$_init__u24lambda_u242).setPreferredSize((Dimension)JBUI.size((int)22, (int)22));
            Icon icon2 = AllIcons.General.Add;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Add");
            ((AbstractButton)$this$_init__u24lambda_u242).setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon2));
            ((AbstractButton)$this$_init__u24lambda_u242).setEnabled(((MarkdownPreviewSettings.State)this.getPreviewSettings().getState()).getFontSize() != ((Number)CollectionsKt.last(MarkdownSettingsConfigurable.Companion.getFontSizeOptions())).intValue());
            JButton increaseButton = object;
            this.add((Component)new JBLabel(MarkdownBundle.message("action.Markdown.Preview.FontSize.label.text", new Object[0])));
            $this$_init__u24lambda_u242 = object = decreaseButton;
            HintComponent hintComponent = this;
            boolean bl4 = false;
            ((AbstractButton)$this$_init__u24lambda_u243).addActionListener(arg_0 -> HintComponent.lambda$3$0(this, preview, fontSizeLabel, (JButton)decreaseButton, increaseButton, arg_0));
            hintComponent.add((Component)object);
            $this$_init__u24lambda_u243 = object = fontSizeLabel;
            hintComponent = this;
            boolean bl5 = false;
            $this$_init__u24lambda_u244.setText(String.valueOf(this.getCurrentFontSize(preview)));
            hintComponent.add((Component)object);
            $this$_init__u24lambda_u244 = object = increaseButton;
            hintComponent = this;
            boolean bl6 = false;
            $this$_init__u24lambda_u245.addActionListener(arg_0 -> HintComponent.lambda$5$0(this, preview, fontSizeLabel, (JButton)decreaseButton, increaseButton, arg_0));
            hintComponent.add((Component)object);
        }

        private final MarkdownPreviewSettings getPreviewSettings() {
            boolean $i$f$service = false;
            Class<MarkdownPreviewSettings> serviceClass$iv = MarkdownPreviewSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MarkdownPreviewSettings)((Object)object);
        }

        private final int getCurrentFontSize(MarkdownJCEFHtmlPanel $this$getCurrentFontSize) {
            Integer n = $this$getCurrentFontSize.getTemporaryFontSize();
            return n != null ? n.intValue() : ((MarkdownPreviewSettings.State)this.getPreviewSettings().getState()).getFontSize();
        }

        private static final Integer lambda$3$0$0(int it) {
            Integer n;
            block1: {
                List<Integer> list2 = MarkdownSettingsConfigurable.Companion.getFontSizeOptions();
                ListIterator<Integer> listIterator = list2.listIterator(list2.size());
                while (listIterator.hasPrevious()) {
                    Integer n2 = listIterator.previous();
                    int step = ((Number)n2).intValue();
                    boolean bl = false;
                    if (!(step < it)) continue;
                    n = n2;
                    break block1;
                }
                n = null;
            }
            return n;
        }

        private static final void lambda$3$0(HintComponent this$0, MarkdownJCEFHtmlPanel $preview, JBLabel $fontSizeLabel, JButton $decreaseButton, JButton $increaseButton, ActionEvent it) {
            HintComponent._init_$updateFontSize(this$0, $preview, $fontSizeLabel, $decreaseButton, $increaseButton, (Function1<? super Integer, Integer>)((Function1)HintComponent::lambda$3$0$0));
        }

        private static final Integer lambda$5$0$0(int it) {
            Object v0;
            block1: {
                Iterable iterable = MarkdownSettingsConfigurable.Companion.getFontSizeOptions();
                for (Object t : iterable) {
                    int step = ((Number)t).intValue();
                    boolean bl = false;
                    if (!(step > it)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private static final void lambda$5$0(HintComponent this$0, MarkdownJCEFHtmlPanel $preview, JBLabel $fontSizeLabel, JButton $decreaseButton, JButton $increaseButton, ActionEvent it) {
            HintComponent._init_$updateFontSize(this$0, $preview, $fontSizeLabel, $decreaseButton, $increaseButton, (Function1<? super Integer, Integer>)((Function1)HintComponent::lambda$5$0$0));
        }

        private static final void _init_$updateFontSize(HintComponent this$0, MarkdownJCEFHtmlPanel $preview, JBLabel fontSizeLabel, JButton decreaseButton, JButton increaseButton, Function1<? super Integer, Integer> transform) {
            int currentSize = this$0.getCurrentFontSize($preview);
            Integer n = (Integer)transform.invoke((Object)currentSize);
            int newSize = n != null ? n : currentSize;
            ((MarkdownPreviewSettings.State)this$0.getPreviewSettings().getState()).setFontSize(newSize);
            MarkdownJCEFHtmlPanel.changeFontSize$intellij_markdown$default($preview, newSize, false, 2, null);
            fontSizeLabel.setText(String.valueOf(newSize));
            decreaseButton.setEnabled(newSize != ((Number)CollectionsKt.first(MarkdownSettingsConfigurable.Companion.getFontSizeOptions())).intValue());
            increaseButton.setEnabled(newSize != ((Number)CollectionsKt.last(MarkdownSettingsConfigurable.Companion.getFontSizeOptions())).intValue());
        }
    }
}

