/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseAlterGenerator;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterCheck;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.Flags;
import com.intellij.database.dialects.mssql.generator.MsEnableDisableGenerator;
import com.intellij.database.dialects.mssql.generator.MsScriptGeneratorHelperKt;
import com.intellij.database.dialects.mssql.model.MsCheck;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.script.generator.ScriptingCapabilities;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u001e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0010H\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/mssql/generator/producers/MsAlterCheck;", "Lcom/intellij/database/dialects/base/generator/producers/AlterCheck;", "Lcom/intellij/database/dialects/mssql/model/MsCheck;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/model/ElementAlteration;)V", "hasRename", "", "produceRename", "", "produceAlterComment", "produceFlag", "id", "Lcom/intellij/database/model/meta/BasicMetaId;", "produced", "", "register", "Lcom/intellij/database/dialects/base/generator/Operation;", "generator", "Lcom/intellij/database/dialects/base/generator/BaseAlterGenerator;", "root", "canAlter", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "prop", "notCausesRecreate", "it", "intellij.database.dialects.mssql"})
public class MsAlterCheck
extends AlterCheck<MsCheck> {
    public MsAlterCheck(@NotNull ScriptingContext context, @NotNull ElementAlteration<? extends MsCheck> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        super(context, elements);
    }

    protected boolean hasRename() {
        return true;
    }

    public void produceRename() {
        MsScriptGeneratorHelperKt.spRename((AlterProducerBase)this, "OBJECT");
    }

    public void produceAlterComment() {
        MsScriptGeneratorHelperKt.msAlterComment((AlterProducerBase)this);
    }

    public void produceFlag(@NotNull BasicMetaId id, @NotNull Set<BasicMetaId> produced) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        if (!Intrinsics.areEqual((Object)id, (Object)MsCheck.DISABLED)) {
            super.produceFlag(id, produced);
        }
    }

    @Nullable
    public Operation register(@NotNull BaseAlterGenerator generator, @NotNull Operation root) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Operation operation = super.register(generator, root);
        Flags flags = this.getFlags();
        BasicMetaPropertyId basicMetaPropertyId = MsCheck.DISABLED;
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId, (String)"DISABLED");
        if (flags.get((BasicMetaId)basicMetaPropertyId)) {
            new MsEnableDisableGenerator(this.getContext()).makeEnableDisableOperation(this.getTo(), root);
        }
        return operation;
    }

    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canAlter(@NotNull BasicMetaId prop) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        return Intrinsics.areEqual((Object)prop, (Object)MsCheck.DISABLED) ? AbstractScriptGeneratorKt.getSUPPORTED() : super.canAlter(prop);
    }

    protected boolean notCausesRecreate(@NotNull BasicMetaId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)MsCheck.DISABLED) ? true : super.notCausesRecreate(it);
    }
}

