/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.toml.TomlBundle;
import org.toml.TomlIcons;
import org.toml.lang.TomlLanguage;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/toml/lang/psi/TomlFileType;", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "Lcom/intellij/openapi/fileTypes/ex/FileTypeIdentifiableByVirtualFile;", "<init>", "()V", "getName", "", "getDescription", "getDefaultExtension", "getIcon", "Ljavax/swing/Icon;", "getCharset", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "isAvailableForOverride", "", "isMyFileType", "intellij.toml.core"})
public final class TomlFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    @NotNull
    public static final TomlFileType INSTANCE = new TomlFileType();

    private TomlFileType() {
        super((Language)TomlLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return "TOML";
    }

    @NotNull
    public String getDescription() {
        return TomlBundle.INSTANCE.message("filetype.toml.description", new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return "toml";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TomlIcons.TomlFile;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TomlFile");
        return icon;
    }

    @NotNull
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return "UTF-8";
    }

    public boolean isAvailableForOverride() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMyFileType(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!StringUtil.equal((CharSequence)file.getNameSequence(), (CharSequence)"config", (boolean)true)) return false;
        VirtualFile virtualFile = file.getParent();
        if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getName() : null), (Object)".cargo")) return false;
        return true;
    }
}

