/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProcessor;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class MergeWindow {
    private static final Logger LOG = Logger.getInstance(MergeWindow.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffDialogHints myHints;
    private MergeRequestProcessor myProcessor;
    private WindowWrapper myWrapper;

    public MergeWindow(@Nullable Project project, @NotNull DiffDialogHints hints) {
        if (hints == null) {
            MergeWindow.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myHints = hints;
    }

    protected void init() {
        if (this.myWrapper != null) {
            return;
        }
        this.myProcessor = this.createProcessor();
        String dialogGroupKey = (String)this.myProcessor.getContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY);
        if (dialogGroupKey == null) {
            dialogGroupKey = "MergeDialog";
        }
        this.myWrapper = new WindowWrapperBuilder(DiffUtil.getWindowMode(this.myHints), (JComponent)new MyPanel(this.myProcessor.getComponent())).setProject(this.myProject).setParent(this.myHints.getParent()).setDimensionServiceKey(dialogGroupKey).setInitialSize(JBUI.DialogSizes.extraLarge()).setMaximizable(true).setPreferredFocusedComponent(() -> this.myProcessor.getPreferredFocusedComponent()).setOnShowCallback(() -> WriteIntentReadAction.run(() -> this.initProcessor(this.myProcessor))).setOnCloseHandler(() -> this.myProcessor.checkCloseAction()).build();
        this.myWrapper.setImages((List)DiffUtil.DIFF_FRAME_ICONS.getValue());
        Disposer.register((Disposable)this.myWrapper, (Disposable)this.myProcessor);
        Consumer wrapperHandler = this.myHints.getWindowConsumer();
        if (wrapperHandler != null) {
            wrapperHandler.consume((Object)this.myWrapper);
        }
    }

    public void show() {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("Merge dialog should not be shown under a write action, as it will disable any background activity.");
        }
        this.init();
        this.myWrapper.show();
    }

    @NotNull
    private MergeRequestProcessor createProcessor() {
        return new MergeRequestProcessor(this.myProject){

            @Override
            public void closeDialog() {
                MergeWindow.this.myWrapper.close();
            }

            @Override
            protected void setWindowTitle(@NlsContexts.DialogTitle @NotNull String title) {
                if (title == null) {
                    1.$$$reportNull$$$0(0);
                }
                MergeWindow.this.myWrapper.setTitle(title);
            }

            @Override
            @Nullable
            protected JRootPane getRootPane() {
                RootPaneContainer container = (RootPaneContainer)ObjectUtils.tryCast((Object)MergeWindow.this.myWrapper.getWindow(), RootPaneContainer.class);
                return container != null ? container.getRootPane() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/merge/MergeWindow$1", "setWindowTitle"));
            }
        };
    }

    protected abstract void initProcessor(@NotNull MergeRequestProcessor var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/merge/MergeWindow", "<init>"));
    }

    private static class MyPanel
    extends JPanel {
        MyPanel(@NotNull JComponent content) {
            if (content == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.add((Component)content, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffWindowSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/merge/MergeWindow$MyPanel", "<init>"));
        }
    }

    public static class ForProducer
    extends MergeWindow {
        @NotNull
        private final MergeRequestProducer myMergeRequestProducer;

        public ForProducer(@Nullable Project project, @NotNull MergeRequestProducer mergeRequestProducer, @NotNull DiffDialogHints hints) {
            if (mergeRequestProducer == null) {
                ForProducer.$$$reportNull$$$0(0);
            }
            if (hints == null) {
                ForProducer.$$$reportNull$$$0(1);
            }
            super(project, hints);
            this.myMergeRequestProducer = mergeRequestProducer;
        }

        @Override
        protected void initProcessor(@NotNull MergeRequestProcessor processor) {
            if (processor == null) {
                ForProducer.$$$reportNull$$$0(2);
            }
            processor.init(this.myMergeRequestProducer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergeRequestProducer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hints";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeWindow$ForProducer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initProcessor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ForRequest
    extends MergeWindow {
        @NotNull
        private final MergeRequest myMergeRequest;

        public ForRequest(@Nullable Project project, @NotNull MergeRequest mergeRequest, @NotNull DiffDialogHints hints) {
            if (mergeRequest == null) {
                ForRequest.$$$reportNull$$$0(0);
            }
            if (hints == null) {
                ForRequest.$$$reportNull$$$0(1);
            }
            super(project, hints);
            this.myMergeRequest = mergeRequest;
        }

        @Override
        protected void initProcessor(@NotNull MergeRequestProcessor processor) {
            if (processor == null) {
                ForRequest.$$$reportNull$$$0(2);
            }
            processor.init(this.myMergeRequest);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergeRequest";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hints";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeWindow$ForRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initProcessor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

