/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.combined;

import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffRegistry;", "", "<init>", "()V", "COMBINED_DIFF_SETTING_ID", "", "isEnabled", "", "setCombinedDiffEnabled", "", "enabled", "getPreloadedBlocksCount", "", "getMaxBlockCountInMemory", "getFilesLimit", "addStateListener", "onEnabledChange", "Ljava/lang/Runnable;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.diff.impl"})
@ApiStatus.Experimental
public final class CombinedDiffRegistry {
    @NotNull
    public static final CombinedDiffRegistry INSTANCE = new CombinedDiffRegistry();
    @NotNull
    public static final String COMBINED_DIFF_SETTING_ID = "enable.combined.diff";

    private CombinedDiffRegistry() {
    }

    public final boolean isEnabled() {
        return AdvancedSettings.Companion.getBoolean(COMBINED_DIFF_SETTING_ID) && !AppMode.isRemoteDevHost();
    }

    public final void setCombinedDiffEnabled(boolean enabled) {
        AdvancedSettings.Companion.setBoolean(COMBINED_DIFF_SETTING_ID, enabled);
    }

    public final int getPreloadedBlocksCount() {
        return Registry.Companion.intValue("combined.diff.visible.viewport.delta", 3, 1, 100);
    }

    public final int getMaxBlockCountInMemory() {
        return Registry.Companion.intValue("combined.diff.loaded.content.limit");
    }

    public final int getFilesLimit() {
        return Registry.Companion.intValue("combined.diff.files.limit");
    }

    public final void addStateListener(@NotNull Runnable onEnabledChange, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)onEnabledChange, (String)"onEnabledChange");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(onEnabledChange){
            final /* synthetic */ Runnable $onEnabledChange;
            {
                this.$onEnabledChange = $onEnabledChange;
            }

            public void advancedSettingChanged(String id, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id, (Object)"enable.combined.diff")) {
                    this.$onEnabledChange.run();
                }
            }
        });
    }
}

