/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.awt.Graphics;
import java.awt.Point;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DiffEmptyHighlighterRenderer
implements CustomHighlighterRenderer {
    @NotNull
    private final TextDiffType myDiffType;

    public DiffEmptyHighlighterRenderer(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            DiffEmptyHighlighterRenderer.$$$reportNull$$$0(0);
        }
        this.myDiffType = diffType;
    }

    public void paint(@NotNull Editor editor, final @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        if (editor == null) {
            DiffEmptyHighlighterRenderer.$$$reportNull$$$0(1);
        }
        if (highlighter == null) {
            DiffEmptyHighlighterRenderer.$$$reportNull$$$0(2);
        }
        if (g == null) {
            DiffEmptyHighlighterRenderer.$$$reportNull$$$0(3);
        }
        if (DiffUtil.isUserDataFlagSet(DiffDrawUtil.EDITOR_WITH_HIGH_PRIORITY_RENDERER, new UserDataHolder[]{editor})) {
            MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
            CommonProcessors.FindProcessor<RangeHighlighterEx> processor = new CommonProcessors.FindProcessor<RangeHighlighterEx>(this){

                protected boolean accept(RangeHighlighterEx ex) {
                    return ex.getLayer() > highlighter.getLayer() && ex.getCustomRenderer() instanceof DiffDrawUtil.DiffLayeredRendererMarker;
                }
            };
            markupModel.processRangeHighlightersOverlappingWith(highlighter.getStartOffset(), highlighter.getEndOffset(), (Processor)processor);
            if (processor.isFound()) {
                return;
            }
        }
        g.setColor(this.myDiffType.getColor(editor));
        Point point = editor.logicalPositionToXY(editor.offsetToLogicalPosition(highlighter.getStartOffset()));
        g.fillRect(point.x - JBUIScale.scale((int)1), point.y, JBUIScale.scale((int)2), editor.getLineHeight());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/util/DiffEmptyHighlighterRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

