/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.FragmentedEditorHighlighter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusMarkerPopupPanel
extends JPanel {
    private static final JBColor TOOLBAR_BACKGROUND_COLOR = JBColor.namedColor((String)"VersionControl.MarkerPopup.Toolbar.background", (Color)UIUtil.getPanelBackground());
    @Nullable
    private final JComponent myEditorComponent;
    @NotNull
    private final Editor myEditor;

    private LineStatusMarkerPopupPanel(final @NotNull Editor editor, @NotNull ActionToolbar toolbar, @Nullable JComponent editorComponent, @Nullable JComponent additionalInfo) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(0);
        }
        if (toolbar == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.setOpaque(false);
        this.myEditor = editor;
        this.myEditorComponent = editorComponent;
        boolean isEditorVisible = this.myEditorComponent != null;
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder((Border)JBUI.Borders.empty((int)3, (int)0));
        toolbarComponent.setBackground((Color)TOOLBAR_BACKGROUND_COLOR);
        BorderLayoutPanel toolbarPanel = JBUI.Panels.simplePanel().addToLeft((Component)JBUI.Panels.simplePanel().addToTop((Component)toolbarComponent));
        Border outsideToolbarBorder = JBUI.Borders.customLine((Color)LineStatusMarkerPopupPanel.getBorderColor(), (int)1, (int)1, (int)(isEditorVisible ? 0 : 1), (int)1);
        JBInsets insets = JBUI.insets((String)"VersionControl.MarkerPopup.borderInsets", (JBInsets)(ExperimentalUI.isNewUI() ? JBUI.insets((int)3, (int)8, (int)3, (int)10) : JBInsets.create((int)1, (int)5)));
        Border insideToolbarBorder = JBUI.Borders.empty((Insets)insets);
        toolbarPanel.setBorder((Border)BorderFactory.createCompoundBorder(outsideToolbarBorder, insideToolbarBorder));
        toolbarPanel.setBackground((Color)TOOLBAR_BACKGROUND_COLOR);
        if (additionalInfo != null) {
            toolbarPanel.addToRight((Component)additionalInfo);
        }
        JPanel emptyPanel = new JPanel();
        emptyPanel.setOpaque(false);
        emptyPanel.setPreferredSize(new Dimension());
        BorderLayoutPanel topPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel().andTransparent()).addToLeft((Component)toolbarPanel).addToCenter((Component)emptyPanel);
        this.add((Component)topPanel, "North");
        if (this.myEditorComponent != null) {
            this.add((Component)this.myEditorComponent, "Center");
        }
        MouseAdapter listener = new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                LineStatusMarkerPopupPanel.transferEvent(e, editor);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                LineStatusMarkerPopupPanel.transferEvent(e, editor);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LineStatusMarkerPopupPanel.transferEvent(e, editor);
            }
        };
        emptyPanel.addMouseListener(listener);
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(2);
        }
        return editor;
    }

    private static void transferEvent(MouseEvent e, Editor editor) {
        editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
    }

    int getEditorTextOffset() {
        return LineStatusMarkerPopupPanel.createEditorFragmentBorder().getBorderInsets((Component)this.myEditorComponent).left;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension windowSize;
        if (this.myEditorComponent == null) {
            return super.getPreferredSize();
        }
        Window window = UIUtil.getWindow((Component)this.myEditor.getComponent());
        if (window != null) {
            windowSize = window.getSize();
        } else {
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Component)this.myEditor.getComponent());
            windowSize = new Dimension(screenRectangle.width, screenRectangle.height);
        }
        int gap = JBUI.scale((int)10);
        Rectangle maxSize = new Rectangle(windowSize.width - gap, windowSize.height - gap);
        Dimension size = super.getPreferredSize();
        if (size.width > maxSize.width) {
            size.width = maxSize.width;
            size.height += JBUI.scale((int)20);
        }
        Rectangle panelRect = new Rectangle(new Point(0, 0), size);
        Rectangle rectangle = SwingUtilities.convertRectangle(this, panelRect, window);
        if (rectangle.y + size.height > maxSize.height && maxSize.height - rectangle.y > 0) {
            size.height = maxSize.height - rectangle.y;
        }
        return size;
    }

    @NotNull
    public static EditorTextField createTextField(@NotNull Editor editor, @NotNull String content) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(3);
        }
        if (content == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(4);
        }
        EditorTextField field = new EditorTextField(content);
        field.setBorder(null);
        field.setOneLineMode(false);
        field.ensureWillComputePreferredSize();
        field.setFontInheritedFromLAF(false);
        field.addSettingsProvider(uEditor -> {
            uEditor.setVerticalScrollbarVisible(true);
            uEditor.setHorizontalScrollbarVisible(true);
            uEditor.getSettings().setUseSoftWraps(false);
            uEditor.setRendererMode(true);
            uEditor.setBorder(null);
            uEditor.setColorsScheme(editor.getColorsScheme());
            uEditor.setBackgroundColor(LineStatusMarkerPopupPanel.getEditorBackgroundColor(editor));
            uEditor.getSettings().setCaretRowShown(false);
            uEditor.getSettings().setTabSize(editor.getSettings().getTabSize(editor.getProject()));
            uEditor.getSettings().setUseTabCharacter(editor.getSettings().isUseTabCharacter(editor.getProject()));
        });
        EditorTextField editorTextField = field;
        if (editorTextField == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(5);
        }
        return editorTextField;
    }

    @NotNull
    public static JComponent createEditorComponent(@NotNull Editor editor, @NotNull JComponent popupEditor) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(6);
        }
        if (popupEditor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(7);
        }
        BorderLayoutPanel editorComponent = JBUI.Panels.simplePanel((Component)popupEditor);
        editorComponent.setBorder(LineStatusMarkerPopupPanel.createEditorFragmentBorder());
        editorComponent.setBackground(LineStatusMarkerPopupPanel.getEditorBackgroundColor(editor));
        BorderLayoutPanel borderLayoutPanel = editorComponent;
        if (borderLayoutPanel == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(8);
        }
        return borderLayoutPanel;
    }

    @NotNull
    private static Border createEditorFragmentBorder() {
        Border outsideEditorBorder = JBUI.Borders.customLine((Color)LineStatusMarkerPopupPanel.getBorderColor(), (int)1);
        Border insideEditorBorder = JBUI.Borders.empty((int)2);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outsideEditorBorder, insideEditorBorder);
        if (compoundBorder == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(9);
        }
        return compoundBorder;
    }

    public static Color getEditorBackgroundColor(@NotNull Editor editor) {
        Color color;
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(10);
        }
        return (color = editor.getColorsScheme().getColor(EditorColors.CHANGED_LINES_POPUP)) != null ? color : EditorFragmentComponent.getBackgroundColor((Editor)editor);
    }

    @NotNull
    public static Color getBorderColor() {
        JBColor jBColor = JBColor.namedColor((String)"VersionControl.MarkerPopup.borderColor", (Color)new JBColor((Color)Gray._206, (Color)Gray._75));
        if (jBColor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(11);
        }
        return jBColor;
    }

    @NotNull
    public static ActionToolbar buildToolbar(@NotNull Editor editor, @NotNull List<? extends AnAction> actions, @NotNull Disposable parentDisposable) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(12);
        }
        if (actions == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(14);
        }
        JComponent editorComponent = editor.getComponent();
        for (AnAction anAction : actions) {
            DiffUtil.registerAction(anAction, editorComponent);
        }
        Disposer.register((Disposable)parentDisposable, () -> ActionUtil.getActions((JComponent)editorComponent).removeAll(actions));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(actions), true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(15);
        }
        return actionToolbar;
    }

    public static void installBaseEditorSyntaxHighlighters(@Nullable Project project, @NotNull EditorTextField textField, @NotNull Document vcsDocument, TextRange vcsTextRange, @Nullable FileType fileType) {
        if (textField == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(16);
        }
        if (vcsDocument == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(17);
        }
        FileType type = fileType != null ? fileType : PlainTextFileType.INSTANCE;
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, type);
        highlighter.setText(vcsDocument.getImmutableCharSequence());
        FragmentedEditorHighlighter fragmentedHighlighter = new FragmentedEditorHighlighter(highlighter, vcsTextRange);
        textField.addSettingsProvider(uEditor -> uEditor.setHighlighter((EditorHighlighter)fragmentedHighlighter));
    }

    public static void installPopupEditorWordHighlighters(@NotNull EditorTextField textField, @Nullable List<? extends DiffFragment> wordDiff) {
        if (textField == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(18);
        }
        if (wordDiff == null) {
            return;
        }
        textField.addSettingsProvider(uEditor -> LineStatusMarkerPopupPanel.installEditorDiffHighlighters((Editor)uEditor, wordDiff));
    }

    @NotNull
    public static List<RangeHighlighter> installEditorDiffHighlighters(@NotNull Editor editor, @Nullable List<? extends DiffFragment> wordDiff) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(19);
        }
        if (wordDiff == null) {
            List<RangeHighlighter> list = Collections.emptyList();
            if (list == null) {
                LineStatusMarkerPopupPanel.$$$reportNull$$$0(20);
            }
            return list;
        }
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        for (DiffFragment diffFragment : wordDiff) {
            int vcsStart = diffFragment.getStartOffset1();
            int vcsEnd = diffFragment.getEndOffset1();
            TextDiffType type = DiffUtil.getDiffType(diffFragment);
            highlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, vcsStart, vcsEnd, type));
        }
        ArrayList<RangeHighlighter> arrayList = highlighters;
        if (arrayList == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    public static void installMasterEditorWordHighlighters(@NotNull Editor editor, int startLine, int endLine, @NotNull List<? extends DiffFragment> wordDiff, @NotNull Disposable parentDisposable) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(22);
        }
        if (wordDiff == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(23);
        }
        if (parentDisposable == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(24);
        }
        TextRange currentTextRange = DiffUtil.getLinesRange(editor.getDocument(), startLine, endLine);
        DiffDrawUtil.setupLayeredRendering(editor, startLine, endLine, 1, parentDisposable);
        int currentStartOffset = currentTextRange.getStartOffset();
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>(new DiffDrawUtil.LineHighlighterBuilder(editor, startLine, endLine, TextDiffType.MODIFIED).withLayerPriority(1).withIgnored(true).withHideStripeMarkers(true).withHideGutterMarkers(true).done());
        for (DiffFragment diffFragment : wordDiff) {
            int currentStart = currentStartOffset + diffFragment.getStartOffset2();
            int currentEnd = currentStartOffset + diffFragment.getEndOffset2();
            TextDiffType type = DiffUtil.getDiffType(diffFragment);
            highlighters.addAll(new DiffDrawUtil.InlineHighlighterBuilder(editor, currentStart, currentEnd, type).withLayerPriority(1).done());
        }
        Disposer.register((Disposable)parentDisposable, () -> highlighters.forEach(RangeMarker::dispose));
    }

    @NotNull
    public static LineStatusMarkerPopupPanel create(@NotNull Editor editor, @NotNull ActionToolbar toolbar, @Nullable JComponent editorComponent, @Nullable JComponent additionalInfo) {
        if (editor == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(25);
        }
        if (toolbar == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(26);
        }
        LineStatusMarkerPopupPanel panel = new LineStatusMarkerPopupPanel(editor, toolbar, editorComponent, additionalInfo);
        toolbar.setTargetComponent((JComponent)panel);
        LineStatusMarkerPopupPanel lineStatusMarkerPopupPanel = panel;
        if (lineStatusMarkerPopupPanel == null) {
            LineStatusMarkerPopupPanel.$$$reportNull$$$0(27);
        }
        return lineStatusMarkerPopupPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 9, 11, 15, 20, 21, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 20: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupEditor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDocument";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wordDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorFragmentBorder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderColor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildToolbar";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "installEditorDiffHighlighters";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 20: 
            case 21: 
            case 27: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTextField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEditorBackgroundColor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildToolbar";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "installBaseEditorSyntaxHighlighters";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "installPopupEditorWordHighlighters";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "installEditorDiffHighlighters";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "installMasterEditorWordHighlighters";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 9, 11, 15, 20, 21, 27 -> new IllegalStateException(string);
        };
    }
}

