/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.typescript.BasicTypeScriptElementTypes;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0014J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u001e\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0007H\u0014J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0014J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0014J\b\u0010(\u001a\u00020\u0011H\u0016J\u0012\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010\tH\u0014R\u0011\u0010\u0015\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001d\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010&\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001f\u00a8\u0006+"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptExpressionParser;", "Lcom/intellij/lang/ecmascript6/parsing/ES6ExpressionParser;", "Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptParser;", "parser", "<init>", "(Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptParser;)V", "parseUnaryExpression", "", "getBinaryExpressionElementType", "Lcom/intellij/psi/tree/IElementType;", "signType", "parseBinaryRightHandSide", "Lcom/intellij/lang/javascript/parsing/ExpressionParser$BinaryParsingState;", "type", "parseTypeInRHS", "parseUnaryExpressionInner", "advanceConstTypeInCast", "", "checkCanBeArrowForJSX", "additionalLookaheadSteps", "", "isRegularTypeScript", "()Z", "parsePrimaryExpression", "parseDialectSpecificMemberExpressionPart", "markerRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/lang/PsiBuilder$Marker;", "isInExtendsOrImplementsList", "newExpressionElementType", "getNewExpressionElementType", "()Lcom/intellij/psi/tree/IElementType;", "getCurrentBinarySignPriority", "allowIn", "advance", "isFunctionPropertyStart", "builder", "Lcom/intellij/lang/PsiBuilder;", "functionPropertyElementType", "getFunctionPropertyElementType", "parseTypeInEmbeddedTypeContext", "isParenAfterReferenceSeparator", "tokenType", "intellij.javascript.parser"})
public class TypeScriptExpressionParser
extends ES6ExpressionParser<TypeScriptParser> {
    public TypeScriptExpressionParser(@NotNull TypeScriptParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super((JavaScriptParser)parser);
    }

    @Override
    protected boolean parseUnaryExpression() {
        return this.parseUnaryExpressionInner();
    }

    @Override
    @NotNull
    protected IElementType getBinaryExpressionElementType(@Nullable IElementType signType) {
        if (signType == JSTokenTypes.AS_KEYWORD) {
            return JSElementTypes.TYPE_AS_EXPRESSION;
        }
        if (signType == JSTokenTypes.SATISFIES_KEYWORD) {
            return JSElementTypes.TYPE_SATISFIES_EXPRESSION;
        }
        return super.getBinaryExpressionElementType(signType);
    }

    @Override
    @NotNull
    protected ExpressionParser.BinaryParsingState parseBinaryRightHandSide(@Nullable IElementType type) {
        if (type == JSTokenTypes.AS_KEYWORD) {
            if (this.builder.getTokenType() == JSTokenTypes.CONST_KEYWORD) {
                this.advanceConstTypeInCast();
                return ExpressionParser.BinaryParsingState.STOP;
            }
            return this.parseTypeInRHS();
        }
        if (type == JSTokenTypes.SATISFIES_KEYWORD) {
            return this.parseTypeInRHS();
        }
        return super.parseBinaryRightHandSide(type);
    }

    private final ExpressionParser.BinaryParsingState parseTypeInRHS() {
        return ((TypeScriptPsiTypeParser)((TypeScriptParser)this.parser).getTypeParser()).parseType() ? ExpressionParser.BinaryParsingState.STOP : ExpressionParser.BinaryParsingState.FAIL_AND_STOP;
    }

    private final boolean parseUnaryExpressionInner() {
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            boolean canBeArrow = this.checkCanBeArrowForJSX(0);
            if (canBeArrow && ((TypeScriptParser)this.parser).getFunctionParser().parseArrowFunction()) {
                return true;
            }
            if (this.isRegularTypeScript()) {
                PsiBuilder.Marker marker = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                PsiBuilder.Marker expr = marker;
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.CONST_KEYWORD) {
                    this.advanceConstTypeInCast();
                } else {
                    ((TypeScriptPsiTypeParser)((TypeScriptParser)this.parser).getTypeParser()).parseType();
                }
                if (this.builder.getTokenType() != JSTokenTypes.GT) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.gt", new Object[0]));
                } else {
                    this.builder.advanceLexer();
                }
                if (!this.parseUnaryExpression()) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
                expr.done(JSElementTypes.TYPE_ASSERTION);
                return true;
            }
        } else if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD) {
            boolean canBeArrow = true;
            if (!this.isRegularTypeScript()) {
                canBeArrow = this.checkCanBeArrowForJSX(1);
            }
            if (canBeArrow && ((TypeScriptParser)this.parser).getFunctionParser().parseArrowFunction()) {
                return true;
            }
        }
        return super.parseUnaryExpression();
    }

    private final void advanceConstTypeInCast() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        this.builder.advanceLexer();
        mark.done(BasicTypeScriptElementTypes.CONST_TYPE);
    }

    private final boolean checkCanBeArrowForJSX(int additionalLookaheadSteps) {
        boolean canBeArrow = true;
        if (!this.isRegularTypeScript() && this.isIdentifierToken(this.builder.lookAhead(additionalLookaheadSteps + 1))) {
            IElementType head2 = this.builder.lookAhead(additionalLookaheadSteps + 2);
            if (head2 == JSTokenTypes.EXTENDS_KEYWORD) {
                IElementType head3 = this.builder.lookAhead(additionalLookaheadSteps + 3);
                if (head3 == JSTokenTypes.EQ || head3 == JSTokenTypes.GT) {
                    canBeArrow = false;
                }
            } else if (head2 != JSTokenTypes.COMMA && head2 != JSTokenTypes.EQ) {
                canBeArrow = false;
            }
        }
        return canBeArrow;
    }

    public final boolean isRegularTypeScript() {
        return !((TypeScriptParser)this.parser).getDialect().hasFeature(JSLanguageFeature.E4X);
    }

    @Override
    public boolean parsePrimaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            this.parseParenthesizedExpression();
            if (this.builder.getTokenType() == JSTokenTypes.LT) {
                ((TypeScriptPsiTypeParser)((TypeScriptParser)this.parser).getTypeParser()).tryParseTypeArgumentList(true, false, true);
            }
            return true;
        }
        return super.parsePrimaryExpression();
    }

    @Override
    protected boolean parseDialectSpecificMemberExpressionPart(@NotNull Ref<PsiBuilder.Marker> markerRef, boolean isInExtendsOrImplementsList) {
        Intrinsics.checkNotNullParameter(markerRef, (String)"markerRef");
        PsiBuilder.Marker marker = (PsiBuilder.Marker)markerRef.get();
        if (((TypeScriptPsiTypeParser)((TypeScriptParser)this.parser).getTypeParser()).parseOptionalTypeArgumentListInExpression()) {
            if (!isInExtendsOrImplementsList && this.builder.getTokenType() != JSTokenTypes.LPAR && this.builder.getTokenType() != JSTokenTypes.BACKQUOTE) {
                marker.done(JSElementTypes.EXPRESSION_WITH_TYPE_ARGUMENTS);
                markerRef.set((Object)marker.precede());
            }
            return true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.EXCL && !JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder)) {
            this.builder.advanceLexer();
            marker.done(JSElementTypes.NOT_NULL_EXPRESSION);
            markerRef.set((Object)marker.precede());
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected IElementType getNewExpressionElementType() {
        return JSElementTypes.TYPESCRIPT_NEW_EXPRESSION;
    }

    @Override
    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.AS_KEYWORD || tokenType == JSTokenTypes.SATISFIES_KEYWORD) {
            if (JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder)) {
                return -1;
            }
            if (advance) {
                this.builder.advanceLexer();
            }
            return 6;
        }
        int x = ES6ExpressionParser.Companion.collapseGtAndGetPriority(advance, this.builder);
        if (x > 0) {
            return x;
        }
        return super.getCurrentBinarySignPriority(allowIn, advance);
    }

    @Override
    protected boolean isFunctionPropertyStart(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return JSKeywordSets.PROPERTY_NAMES.contains(builder.getTokenType()) && builder.lookAhead(1) == JSTokenTypes.LT || super.isFunctionPropertyStart(builder);
    }

    @Override
    @NotNull
    protected IElementType getFunctionPropertyElementType() {
        return JSElementTypes.TYPESCRIPT_FUNCTION_PROPERTY;
    }

    @Override
    public void parseTypeInEmbeddedTypeContext() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker root = marker;
        ((TypeScriptPsiTypeParser)((TypeScriptParser)this.parser).getTypeParser()).parseTypeInGenericArgument();
        while (!this.builder.eof()) {
            this.builder.advanceLexer();
        }
        root.done(JSElementTypes.EMBEDDED_EXPRESSION);
    }

    @Override
    protected boolean isParenAfterReferenceSeparator(@Nullable IElementType tokenType) {
        if (super.isParenAfterReferenceSeparator(tokenType)) {
            return true;
        }
        if (tokenType == JSTokenTypes.LT) {
            return ((TypeScriptPsiTypeParser)((TypeScriptParser)this.parser).getTypeParser()).tryParseTypeArgumentList(true, false, true) && this.builder.getTokenType() == JSTokenTypes.LPAR;
        }
        return false;
    }
}

