/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.types.JSElementWithSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

final class JSClassHierarchyVisitor {
    public static final int DEFAULT_DEPTH_LIMIT = 30;
    @NotNull
    private final JSClassUtils.JSClassHierarchyProcessor myProcessor;
    @NotNull
    private final Condition<? super JSClass> myClassToVisitAcceptor;
    @NotNull
    private final Set<JSClass> myVisited;
    private final Set<JSClass> myVisitedStatic;
    private final int myDepthLimit;
    private final boolean myIncludeInterfaces;

    JSClassHierarchyVisitor(boolean includeInterfaces, @NotNull JSClassUtils.JSClassHierarchyProcessor processor, @NotNull Condition<? super JSClass> classToVisitAcceptor, int depthLimit) {
        if (processor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(0);
        }
        if (classToVisitAcceptor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(1);
        }
        this.myVisited = new HashSet<JSClass>();
        this.myVisitedStatic = new HashSet<JSClass>();
        this.myIncludeInterfaces = includeInterfaces;
        this.myProcessor = processor;
        this.myClassToVisitAcceptor = classToVisitAcceptor;
        this.myDepthLimit = depthLimit;
    }

    boolean visit(@NotNull JSClass clazz, @NotNull JSTypeSubstitutor typeSubstitutor) {
        if (clazz == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(2);
        }
        if (typeSubstitutor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(3);
        }
        return this.visit(clazz, typeSubstitutor, false, false, 0);
    }

    private boolean visit(@NotNull JSClass clazz, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements, boolean staticContext, int depth) {
        JSReferenceList implementsList;
        Object[] extendsListResolvedExpressions;
        if (clazz == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(4);
        }
        if (typeSubstitutor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(5);
        }
        ProgressManager.checkCanceled();
        if (!staticContext && !this.myVisited.add(clazz) || staticContext && !this.myVisitedStatic.add(clazz)) {
            return true;
        }
        if (!this.myProcessor.process(clazz, typeSubstitutor, fromImplements, staticContext, depth)) {
            return false;
        }
        if (depth == this.myDepthLimit) {
            return true;
        }
        if (clazz instanceof TypeScriptEnum) {
            return this.processEnumSuperClassesInHierarchy((TypeScriptEnum)clazz, typeSubstitutor, fromImplements, staticContext, depth);
        }
        JSReferenceList extendsList = clazz.getExtendsList();
        Set interfacesExtendedViaVariables = Collections.emptySet();
        if (extendsList != null && !this.processRefs(typeSubstitutor, staticContext, depth, interfacesExtendedViaVariables = (Set)((StreamEx)StreamEx.of((Object[])(extendsListResolvedExpressions = extendsList.getMembers())).flatMap(p -> p.getClasses().stream()).filter(p -> p.isInterface())).collect(Collectors.toSet()), (JSReferenceListMember[])extendsListResolvedExpressions, fromImplements)) {
            return false;
        }
        JSReferenceList jSReferenceList = implementsList = this.myIncludeInterfaces ? clazz.getImplementsList() : null;
        return implementsList == null || this.processRefs(typeSubstitutor, staticContext, depth, interfacesExtendedViaVariables, implementsList.getMembers(), true);
    }

    private boolean processRefs(@NotNull JSTypeSubstitutor typeSubstitutor, boolean staticContext, int depth, @NotNull Set<JSClass> interfacesExtendedViaVariables, JSReferenceListMember @NotNull [] resolvedExpressions, boolean currentFromImplements) {
        if (typeSubstitutor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(6);
        }
        if (interfacesExtendedViaVariables == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(7);
        }
        if (resolvedExpressions == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(8);
        }
        for (JSReferenceListMember expression : resolvedExpressions) {
            if (this.visitSuperReference(typeSubstitutor, staticContext, depth, interfacesExtendedViaVariables, expression, currentFromImplements)) continue;
            return false;
        }
        return true;
    }

    private boolean visitSuperReference(@NotNull JSTypeSubstitutor typeSubstitutor, boolean staticContext, int depth, @NotNull Set<JSClass> interfacesExtendedViaVariables, @NotNull JSReferenceListMember superReference, boolean currentFromImplements) {
        if (typeSubstitutor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(9);
        }
        if (interfacesExtendedViaVariables == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(10);
        }
        if (superReference == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(11);
        }
        for (JSElementWithSubstitutor<JSClass> superClassWithSubstitutor : superReference.getClassesWithSubstitutors()) {
            ProgressManager.checkCanceled();
            boolean newStaticContext = superClassWithSubstitutor.isStaticContext() || staticContext;
            JSTypeSubstitutor combinedSubstitutor = JSClassUtils.combineSuperClassSubstitutor(typeSubstitutor, superClassWithSubstitutor.myTypeSubstitutor);
            for (JSClass aliasResolve : this.getClassesToProcess((JSClass)superClassWithSubstitutor.myElement)) {
                if (!this.myClassToVisitAcceptor.value((Object)aliasResolve) || this.processSuperClass(depth, interfacesExtendedViaVariables, currentFromImplements, newStaticContext, combinedSubstitutor, aliasResolve)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private List<JSClass> getClassesToProcess(@NotNull JSClass superClass) {
        if (superClass == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(12);
        }
        if (this.myIncludeInterfaces && superClass instanceof TypeScriptTypeAlias) {
            SmartList classesToProcess = new SmartList();
            TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)superClass, (Collection<JSClass>)classesToProcess, null);
            SmartList smartList = classesToProcess;
            if (smartList == null) {
                JSClassHierarchyVisitor.$$$reportNull$$$0(13);
            }
            return smartList;
        }
        List<JSClass> list = Collections.singletonList(superClass);
        if (list == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(14);
        }
        return list;
    }

    private boolean processSuperClass(int depth, @NotNull Set<JSClass> interfacesExtendedViaVariables, boolean currentFromImplements, boolean newStaticContext, JSTypeSubstitutor combinedSubstitutor, JSClass aliasResolve) {
        if (interfacesExtendedViaVariables == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(15);
        }
        return !JSClassHierarchyVisitor.canInclude(this.myIncludeInterfaces, aliasResolve, interfacesExtendedViaVariables) || this.visit(aliasResolve, combinedSubstitutor, currentFromImplements, newStaticContext, depth + 1);
    }

    private static boolean canInclude(boolean includeInterfaces, @NotNull JSClass superClass, @NotNull Set<JSClass> interfacesExtendedViaVariables) {
        if (superClass == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(16);
        }
        if (interfacesExtendedViaVariables == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(17);
        }
        if ("Object".equals(superClass.getName())) {
            return false;
        }
        if (includeInterfaces) {
            return true;
        }
        boolean isInterfaceLike = superClass instanceof TypeScriptInterface || superClass instanceof TypeScriptTypeAlias;
        return !isInterfaceLike || interfacesExtendedViaVariables.contains(superClass);
    }

    private boolean processEnumSuperClassesInHierarchy(@NotNull TypeScriptEnum clazz, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements, boolean staticContext, int depth) {
        if (clazz == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(18);
        }
        if (typeSubstitutor == null) {
            JSClassHierarchyVisitor.$$$reportNull$$$0(19);
        }
        for (JSClass aClass : clazz.getSupers()) {
            if (!this.myClassToVisitAcceptor.value((Object)aClass) || this.processSuperClass(depth, Collections.emptySet(), fromImplements, staticContext, typeSubstitutor, aClass)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToVisitAcceptor";
                break;
            }
            case 2: 
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfacesExtendedViaVariables";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedExpressions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superReference";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSClassHierarchyVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSClassHierarchyVisitor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesToProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processRefs";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperReference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClassesToProcess";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canInclude";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processEnumSuperClassesInHierarchy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14 -> new IllegalStateException(string);
        };
    }
}

