/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.javaee;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.task.BuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.util.Consumer;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.build.GradleBuildTasksProvider;
import org.jetbrains.plugins.gradle.javaee.GradleArtifactProperties;
import org.jetbrains.plugins.gradle.javaee.GradleArtifactPropertiesProvider;
import org.jetbrains.plugins.gradle.javaee.JavaeeProjectDataService;
import org.jetbrains.plugins.gradle.javaee.JeeArtifactBuildTasksProviderKt;
import org.jetbrains.plugins.gradle.service.task.PredefinedVersionSpecificInitScript;
import org.jetbrains.plugins.gradle.service.task.VersionSpecificInitScript;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J2\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/javaee/JeeArtifactBuildTasksProvider;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleBuildTasksProvider;", "<init>", "()V", "isApplicable", "", "buildTask", "Lcom/intellij/task/BuildTask;", "addBuildTasks", "", "buildTasksConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/externalSystem/model/execution/ExternalTaskPojo;", "initScriptConsumer", "Ljava/util/function/BiConsumer;", "", "Lorg/jetbrains/plugins/gradle/service/task/VersionSpecificInitScript;", "intellij.javaee.gradle"})
public final class JeeArtifactBuildTasksProvider
implements GradleBuildTasksProvider {
    public boolean isApplicable(@NotNull BuildTask buildTask) {
        Intrinsics.checkNotNullParameter((Object)buildTask, (String)"buildTask");
        ProjectModelBuildTask projectModelBuildTask = buildTask instanceof ProjectModelBuildTask ? (ProjectModelBuildTask)buildTask : null;
        if (projectModelBuildTask == null) {
            return false;
        }
        ProjectModelBuildTask artifactBuildTask = projectModelBuildTask;
        ProjectModelBuildableElement projectModelBuildableElement = artifactBuildTask.getBuildableElement();
        Artifact artifact = projectModelBuildableElement instanceof Artifact ? (Artifact)projectModelBuildableElement : null;
        if (artifact == null) {
            return false;
        }
        Artifact artifact2 = artifact;
        GradleArtifactPropertiesProvider gradleArtifactPropertiesProvider = GradleArtifactPropertiesProvider.getInstance();
        if (gradleArtifactPropertiesProvider == null) {
            return false;
        }
        GradleArtifactPropertiesProvider artifactPropertiesProvider = gradleArtifactPropertiesProvider;
        ArtifactProperties artifactProperties = artifact2.getProperties((ArtifactPropertiesProvider)artifactPropertiesProvider);
        if (artifactProperties == null || !(artifactProperties.getState() instanceof GradleArtifactProperties)) {
            return false;
        }
        Project project = (Project)ReadAction.compute(() -> JeeArtifactBuildTasksProvider.isApplicable$lambda$0(artifact2));
        if (project == null) {
            return false;
        }
        GradleArtifactProperties gradleArtifactProperties = (GradleArtifactProperties)((Object)artifactProperties.getState());
        Intrinsics.checkNotNull((Object)((Object)gradleArtifactProperties));
        String projectPath = gradleArtifactProperties.getExternalProjectPath();
        return StringUtil.isNotEmpty((String)projectPath) && GradleProjectSettings.isDelegatedBuildEnabled((Project)project, (String)projectPath);
    }

    public void addBuildTasks(@NotNull BuildTask buildTask, @NotNull Consumer<ExternalTaskPojo> buildTasksConsumer, @NotNull BiConsumer<String, VersionSpecificInitScript> initScriptConsumer) {
        Intrinsics.checkNotNullParameter((Object)buildTask, (String)"buildTask");
        Intrinsics.checkNotNullParameter(buildTasksConsumer, (String)"buildTasksConsumer");
        Intrinsics.checkNotNullParameter(initScriptConsumer, (String)"initScriptConsumer");
        ProjectModelBuildTask projectModelBuildTask = buildTask instanceof ProjectModelBuildTask ? (ProjectModelBuildTask)buildTask : null;
        if (projectModelBuildTask == null) {
            return;
        }
        ProjectModelBuildTask artifactBuildTask = projectModelBuildTask;
        ProjectModelBuildableElement projectModelBuildableElement = artifactBuildTask.getBuildableElement();
        Artifact artifact = projectModelBuildableElement instanceof Artifact ? (Artifact)projectModelBuildableElement : null;
        if (artifact == null) {
            return;
        }
        Artifact artifact2 = artifact;
        ArtifactProperties<GradleArtifactProperties> artifactProperties = JavaeeProjectDataService.getGradleArtifactProperties(artifact2);
        if (artifactProperties == null) {
            return;
        }
        ArtifactProperties<GradleArtifactProperties> artifactProperties2 = artifactProperties;
        GradleArtifactProperties gradleArtifactProperties = (GradleArtifactProperties)((Object)artifactProperties2.getState());
        if (gradleArtifactProperties == null) {
            return;
        }
        GradleArtifactProperties gradleArtifactProperties2 = gradleArtifactProperties;
        String projectPath = gradleArtifactProperties2.getExternalProjectPath();
        initScriptConsumer.accept(projectPath, (VersionSpecificInitScript)new PredefinedVersionSpecificInitScript("\ndef findNamed(Project p, String name) {\n  try {\n    return p.tasks.named(name)\n  } catch (UnknownTaskException ignore) {}\n  return null\n} \n      \nallprojects {\n  afterEvaluate { Project p ->\n    try {\n      def userDefinedExplodedTask = findNamed(p, \"war_exploded\")\n      if (!userDefinedExplodedTask) {\n        def warTask = p.tasks.named(\"war\")\n        if (warTask) {\n          def warTaskProvider = p.tasks.register(\"war_exploded\", Sync) {\n            def warTaskResolved = warTask.get()\n            if (warTaskResolved instanceof War) {\n               into \"${buildDir}/libs/exploded/${war.getArchiveFileName().get()}\"\n               with war\n            }\n          }\n          warTaskProvider.configure { t ->\n             t.setDependsOn(warTask.get().getDependsOn())\n          }\n        }\n      }\n    } catch(UnknownTaskException ignore) {}\n\n    try {\n      def userDefinedExplodedTask = findNamed(p, \"ear_exploded\")\n      if (!userDefinedExplodedTask) {\n        def earTask = p.tasks.named(\"ear\")\n        if (earTask) {\n          def earTaskProvider = p.tasks.register(\"ear_exploded\", Sync) {\n            def earTaskResolved = earTask.get()\n            if (earTaskResolved instanceof Ear) {          \n              into \"${buildDir}/libs/exploded/${ear.getArchiveFileName().get()}\"\n              with ear\n            }\n          }\n          earTaskProvider.configure { t ->\n             t.setDependsOn(earTask.get().getDependsOn())\n          }\n        }\n      }\n    } catch(UnknownTaskException ignore) {}\n  }\n}\n", null, JeeArtifactBuildTasksProvider::addBuildTasks$lambda$0, 2, null));
        initScriptConsumer.accept(projectPath, (VersionSpecificInitScript)new PredefinedVersionSpecificInitScript("\ndef findNamed(Project p, String name) {\n  try {\n    return p.tasks.getByName(name)\n  } catch (UnknownTaskException ignore) {}\n  return null\n} \n\nallprojects {  \n  afterEvaluate { Project p ->\n    try {\n      def userDefinedExplodedTask = findNamed(p, \"war_exploded\")\n      if (!userDefinedExplodedTask) {\n        def warTask = p.tasks.getByName(\"war\")\n        if (warTask != null && warTask instanceof War) {\n          def warExploded = p.tasks.create(\"war_exploded\", Sync) {\n            into \"${buildDir}/libs/exploded/${war.getArchiveName()}\"\n            with war\n          }\n          warExploded.setDependsOn(warTask.getDependsOn())\n        }\n      }\n    } catch(UnknownTaskException ignore) {}\n\n    try {\n      def userDefinedExplodedTask = findNamed(p, \"ear_exploded\")\n        if (!userDefinedExplodedTask) {\n        def earTask = p.tasks.getByName(\"ear\")\n        if (earTask != null && earTask instanceof Ear) {\n          def earExploded = p.tasks.create(\"ear_exploded\", Sync) {\n            into \"${buildDir}/libs/exploded/${ear.getArchiveName()}\"\n            with ear\n          }\n          earExploded.setDependsOn(earTask.getDependsOn())\n        }\n      }\n    } catch(UnknownTaskException ignore) {}\n  }\n}\n", null, JeeArtifactBuildTasksProvider::addBuildTasks$lambda$1, 2, null));
        if (!artifactBuildTask.isIncrementalBuild()) {
            String string = gradleArtifactProperties2.getCleanByTaskPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCleanByTaskPath(...)");
            JeeArtifactBuildTasksProvider.addBuildTasks$send(buildTasksConsumer, projectPath, string);
        }
        String string = gradleArtifactProperties2.getBuildByTaskPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBuildByTaskPath(...)");
        JeeArtifactBuildTasksProvider.addBuildTasks$send(buildTasksConsumer, projectPath, string);
    }

    private static final Project isApplicable$lambda$0(Artifact $artifact) {
        Object object;
        block1: {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Object object2 : (Object[])projectArray) {
                Project p = (Project)object2;
                boolean bl = false;
                Project project = p;
                Intrinsics.checkNotNull((Object)project);
                if (!Intrinsics.areEqual((Object)$artifact, (Object)ArtifactManager.getInstance((Project)project).findArtifact($artifact.getName()))) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (Project)object;
    }

    private static final boolean addBuildTasks$lambda$0(GradleVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.compareTo(JeeArtifactBuildTasksProviderKt.access$getGRADLE_V51$p()) >= 0;
    }

    private static final boolean addBuildTasks$lambda$1(GradleVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.compareTo(JeeArtifactBuildTasksProviderKt.access$getGRADLE_V51$p()) < 0;
    }

    private static final void addBuildTasks$send(Consumer<ExternalTaskPojo> $this$addBuildTasks_u24send, String projectPath, String name) {
        $this$addBuildTasks_u24send.consume((Object)new ExternalTaskPojo(name, projectPath, null));
    }
}

