/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe.analyzing;

import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00102\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u00020\rH\u0096\u0082\u0004J\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/charts/dataframe/analyzing/CsvOffsetParser;", "", "", "", "data", "offsetMap", "", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "offset", "offsetIterator", "hasNext", "", "next", "()[Ljava/lang/String;", "Companion", "intellij.charts"})
public final class CsvOffsetParser
implements Iterator<String[]>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String data;
    private int offset;
    @NotNull
    private final Iterator<Integer> offsetIterator;
    @NotNull
    private static final Key<List<Integer>> OFFSETS_MAP_SOURCE = new Key("OFFSETS_MAP_FROM_BINARY_SOURCE");

    public CsvOffsetParser(@NotNull String data, @NotNull List<Integer> offsetMap) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(offsetMap, (String)"offsetMap");
        this.data = data;
        this.offsetIterator = offsetMap.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.offset < this.data.length() - 1 && this.offsetIterator.hasNext();
    }

    @Override
    @NotNull
    public String[] next() {
        LinkedList<Integer> offsetQueue = new LinkedList<Integer>();
        while (this.offsetIterator.hasNext()) {
            int n = ((Number)this.offsetIterator.next()).intValue();
            offsetQueue.add(Math.abs(n));
            if (n >= 0) continue;
        }
        int i = 0;
        int n = 0;
        int n2 = offsetQueue.size();
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = "";
        }
        String[] strings = stringArray;
        StringBuilder curValue = new StringBuilder();
        while (!((Collection)offsetQueue).isEmpty()) {
            Integer n4 = (Integer)offsetQueue.remove();
            while (this.offset < n4) {
                int n5 = this.offset;
                this.offset = n5 + 1;
                curValue.append(this.data.charAt(n5));
            }
            int n6 = i++;
            String string = curValue.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            strings[n6] = string;
            StringsKt.clear((StringBuilder)curValue);
            int n7 = this.offset;
            this.offset = n7 + 1;
        }
        return strings;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/charts/dataframe/analyzing/CsvOffsetParser$Companion;", "", "<init>", "()V", "OFFSETS_MAP_SOURCE", "Lcom/intellij/openapi/util/Key;", "", "", "getOFFSETS_MAP_SOURCE", "()Lcom/intellij/openapi/util/Key;", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<List<Integer>> getOFFSETS_MAP_SOURCE() {
            return OFFSETS_MAP_SOURCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

