/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.util;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0003J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0003J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0003H\u0002R\"\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/util/ClosestPointChecker;", "", "x", "", "y", "(DD)V", "target", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "<set-?>", "coord", "getCoord", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "distance", "getDistance", "()D", "getTarget", "check", "", "objectRadius", "compare", "Lorg/jetbrains/letsPlot/commons/intern/util/ClosestPointChecker$COMPARISON_RESULT;", "newDistance", "compareObject", "setNewClosestCoord", "", "COMPARISON_RESULT", "commons"})
@SourceDebugExtension(value={"SMAP\nClosestPointChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosestPointChecker.kt\norg/jetbrains/letsPlot/commons/intern/util/ClosestPointChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class ClosestPointChecker {
    @NotNull
    private final DoubleVector target;
    private double distance;
    @Nullable
    private DoubleVector coord;

    public ClosestPointChecker(@NotNull DoubleVector target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
        this.distance = -1.0;
    }

    @NotNull
    public final DoubleVector getTarget() {
        return this.target;
    }

    public final double getDistance() {
        return this.distance;
    }

    @Nullable
    public final DoubleVector getCoord() {
        return this.coord;
    }

    public ClosestPointChecker(double x2, double y2) {
        this(new DoubleVector(x2, y2));
    }

    public final boolean check(@NotNull DoubleVector coord, double objectRadius) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        COMPARISON_RESULT cmpResult = this.compareObject(coord, objectRadius);
        return cmpResult == COMPARISON_RESULT.NEW_CLOSER || cmpResult == COMPARISON_RESULT.EQUAL;
    }

    public static /* synthetic */ boolean check$default(ClosestPointChecker closestPointChecker, DoubleVector doubleVector, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        return closestPointChecker.check(doubleVector, d);
    }

    @NotNull
    public final COMPARISON_RESULT compareObject(@NotNull DoubleVector coord, double objectRadius) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Double d = MathKt.distance(this.target, coord);
        double it = ((Number)d).doubleValue();
        boolean bl = false;
        Double d2 = it > objectRadius ? d : null;
        double newDistance = d2 != null ? d2 : 0.0;
        return this.compare(coord, newDistance);
    }

    public static /* synthetic */ COMPARISON_RESULT compareObject$default(ClosestPointChecker closestPointChecker, DoubleVector doubleVector, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        return closestPointChecker.compareObject(doubleVector, d);
    }

    private final COMPARISON_RESULT compare(DoubleVector coord, double newDistance) {
        if (this.distance < 0.0) {
            this.setNewClosestCoord(coord, newDistance);
            return COMPARISON_RESULT.NEW_CLOSER;
        }
        if (this.distance < newDistance) {
            return COMPARISON_RESULT.NEW_FARTHER;
        }
        if (this.distance == newDistance) {
            return COMPARISON_RESULT.EQUAL;
        }
        this.setNewClosestCoord(coord, newDistance);
        return COMPARISON_RESULT.NEW_CLOSER;
    }

    private final void setNewClosestCoord(DoubleVector coord, double distance) {
        this.distance = distance;
        this.coord = coord;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/util/ClosestPointChecker$COMPARISON_RESULT;", "", "(Ljava/lang/String;I)V", "NEW_CLOSER", "NEW_FARTHER", "EQUAL", "commons"})
    public static final class COMPARISON_RESULT
    extends Enum<COMPARISON_RESULT> {
        public static final /* enum */ COMPARISON_RESULT NEW_CLOSER = new COMPARISON_RESULT();
        public static final /* enum */ COMPARISON_RESULT NEW_FARTHER = new COMPARISON_RESULT();
        public static final /* enum */ COMPARISON_RESULT EQUAL = new COMPARISON_RESULT();
        private static final /* synthetic */ COMPARISON_RESULT[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static COMPARISON_RESULT[] values() {
            return (COMPARISON_RESULT[])$VALUES.clone();
        }

        public static COMPARISON_RESULT valueOf(String value) {
            return Enum.valueOf(COMPARISON_RESULT.class, value);
        }

        @NotNull
        public static EnumEntries<COMPARISON_RESULT> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cOMPARISON_RESULTArray = new COMPARISON_RESULT[]{COMPARISON_RESULT.NEW_CLOSER, COMPARISON_RESULT.NEW_FARTHER, COMPARISON_RESULT.EQUAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

