/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.nodes;

import java.awt.Color;
import java.awt.Paint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.paint.SimplePaintSVGPaint;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.AbstractSVGNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.Category;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.AttributeNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.util.ColorUtil;

@ElementCategories(value={Category.Gradient})
@PermittedContent(categories={Category.Animation, Category.Descriptive})
public final class SolidColor
extends AbstractSVGNode
implements SimplePaintSVGPaint {
    public static final String TAG = "solidcolor";
    private Color color;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    @NotNull
    public Paint paint() {
        return this.color;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        Color c = attributeNode.getColor("solid-color");
        float opacity = attributeNode.getPercentage("solid-opacity", (float)c.getAlpha() / 255.0f);
        this.color = ColorUtil.withAlpha(c, opacity);
    }
}

