/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.TimeoutCancellationException;
import org.ec4j.core.ResourceProperties;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigActionUtil;
import org.editorconfig.configmanagement.extended.EditorConfigCodeStyleSettingsModifierKt;
import org.editorconfig.configmanagement.extended.EditorConfigCodeStyleStatusBarUIContributor;
import org.editorconfig.plugincomponents.EditorConfigPropertiesService;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J7\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u000b\u0010\u0014\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u0006H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier;", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleSettingsModifier;", "<init>", "()V", "reportedErrorIds", "", "", "modifySettings", "", "settings", "Lcom/intellij/psi/codeStyle/modifier/TransientCodeStyleSettings;", "psiFile", "Lcom/intellij/psi/PsiFile;", "isAcceptable", "modifySettingsAndUiCustomization", "error", "", "project", "Lcom/intellij/openapi/project/Project;", "id", "message", "Lorg/jetbrains/annotations/Nls;", "fixAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "oneTime", "getStatusBarUiContributor", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleStatusBarUIContributor;", "transientSettings", "mayOverrideSettingsOf", "getName", "getDisablingFunction", "Ljava/util/function/Consumer;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "Handler", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigCodeStyleSettingsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigCodeStyleSettingsModifier.kt\norg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,353:1\n60#2,5:354\n60#2,5:359\n60#2,5:364\n*S KotlinDebug\n*F\n+ 1 EditorConfigCodeStyleSettingsModifier.kt\norg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier\n*L\n77#1:354,5\n86#1:359,5\n90#1:364,5\n*E\n"})
public final class EditorConfigCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    @NotNull
    private final Set<String> reportedErrorIds = new HashSet();

    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return false;
    }

    private final boolean isAcceptable(PsiFile psiFile) {
        return Utils.INSTANCE.isFullIntellijSettingsSupport() && psiFile.getVirtualFile() != null && (Handler.INSTANCE.isEnabledInTests$intellij_editorconfig_backend() || !ApplicationManager.getApplication().isUnitTestMode()) && !psiFile.getProject().isDisposed();
    }

    public boolean modifySettingsAndUiCustomization(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!this.isAcceptable(psiFile)) {
            return false;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Pair<ResourceProperties, List<VirtualFile>> pair = Utils.INSTANCE.processEditorConfig(project2, virtualFile);
        ResourceProperties properties = (ResourceProperties)pair.component1();
        List editorConfigs = (List)pair.component2();
        if (Utils.isEnabled((CodeStyleSettings)settings)) {
            try {
                if (editorConfigs.isEmpty()) {
                    Logger $this$debug_u24default$iv = EditorConfigCodeStyleSettingsModifierKt.access$getLOG();
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Project has no any `.editorconfig` for " + psiFile.getName(), t$iv);
                    }
                    return false;
                }
                settings.setModifier((CodeStyleSettingsModifier)this);
                settings.addDependency((ModificationTracker)EditorConfigPropertiesService.Companion.getInstance(project2));
                if (EditorConfigCodeStyleSettingsModifierKt.access$applyCodeStyleSettings(settings, properties, psiFile)) {
                    Logger $this$debug_u24default$iv = EditorConfigCodeStyleSettingsModifierKt.access$getLOG();
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Modified for " + psiFile.getName(), t$iv);
                    }
                    return true;
                }
                Logger $this$debug_u24default$iv = EditorConfigCodeStyleSettingsModifierKt.access$getLOG();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("No changes for " + psiFile.getName(), t$iv);
                }
                return false;
            }
            catch (TimeoutCancellationException e) {
                EditorConfigCodeStyleSettingsModifierKt.access$getLOG().warn((Throwable)e);
                if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    this.error(project2, "timeout", EditorConfigBundle.message((String)"error.timeout"), (AnAction)DumbAwareAction.create((String)EditorConfigBundle.message((String)"action.disable"), arg_0 -> EditorConfigCodeStyleSettingsModifier.modifySettingsAndUiCustomization$lambda$4(arg_0 -> EditorConfigCodeStyleSettingsModifier.modifySettingsAndUiCustomization$lambda$3(project2, arg_0), arg_0)), true);
                }
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                EditorConfigCodeStyleSettingsModifierKt.access$getLOG().error((Throwable)e);
            }
        }
        return false;
    }

    public final synchronized void error(@Nullable Project project, @NotNull String id, @NotNull String message, @Nullable AnAction fixAction, boolean oneTime) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (oneTime) {
            if (this.reportedErrorIds.contains(id)) {
                return;
            }
            this.reportedErrorIds.add(id);
        }
        Notification notification = new Notification("editorconfig", EditorConfigBundle.message((String)"editorconfig"), message, NotificationType.ERROR);
        if (fixAction != null) {
            String string = fixAction.getTemplateText();
            notification.addAction(new AnAction(fixAction, this, id, notification, string){
                final /* synthetic */ AnAction $fixAction;
                final /* synthetic */ EditorConfigCodeStyleSettingsModifier this$0;
                final /* synthetic */ String $id;
                final /* synthetic */ Notification $notification;
                {
                    this.$fixAction = $fixAction;
                    this.this$0 = $receiver;
                    this.$id = $id;
                    this.$notification = $notification;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$fixAction.actionPerformed(e);
                    EditorConfigCodeStyleSettingsModifier.access$getReportedErrorIds$p(this.this$0).remove(this.$id);
                    this.$notification.expire();
                }
            });
        }
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @NotNull
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        Intrinsics.checkNotNullParameter((Object)transientSettings, (String)"transientSettings");
        return new EditorConfigCodeStyleStatusBarUIContributor();
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Utils.isEnabled(CodeStyle.getSettings((Project)project)) && Utils.INSTANCE.editorConfigExists(project);
    }

    @NotNull
    public String getName() {
        return EditorConfigBundle.message((String)"editorconfig");
    }

    @NotNull
    public Consumer<CodeStyleSettings> getDisablingFunction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return EditorConfigCodeStyleSettingsModifier::getDisablingFunction$lambda$0;
    }

    private static final Unit modifySettingsAndUiCustomization$lambda$3(Project $project, AnActionEvent it) {
        EditorConfigActionUtil.setEditorConfigEnabled($project, false);
        return Unit.INSTANCE;
    }

    private static final void modifySettingsAndUiCustomization$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void getDisablingFunction$lambda$0(CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(EditorConfigSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        EditorConfigSettings editorConfigSettings = (EditorConfigSettings)customCodeStyleSettings;
        editorConfigSettings.ENABLED = false;
    }

    public static final /* synthetic */ Set access$getReportedErrorIds$p(EditorConfigCodeStyleSettingsModifier $this) {
        return $this.reportedErrorIds;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lorg/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$Handler;", "", "<init>", "()V", "isEnabledInTests", "", "isEnabledInTests$intellij_editorconfig_backend", "setEnabledInTests", "", "intellij.editorconfig.backend"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        public final boolean isEnabledInTests$intellij_editorconfig_backend() {
            return EditorConfigCodeStyleSettingsModifierKt.access$getOurEnabledInTestOnly$p();
        }

        @TestOnly
        public final void setEnabledInTests(boolean isEnabledInTests) {
            EditorConfigCodeStyleSettingsModifierKt.access$setOurEnabledInTestOnly$p(isEnabledInTests);
        }
    }
}

