/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.Utils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/editorconfig/plugincomponents/EditorConfigModificationListener;", "Lcom/intellij/openapi/vfs/impl/BulkVirtualFileListenerAdapter;", "<init>", "()V", "intellij.editorconfig.backend"})
public final class EditorConfigModificationListener
extends BulkVirtualFileListenerAdapter {
    public EditorConfigModificationListener() {
        super(new VirtualFileListener(){

            public void propertyChanged(VirtualFilePropertyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)"name", (Object)event.getPropertyName()) && (Utils.INSTANCE.isEditorConfigName((String)event.getNewValue()) || Utils.INSTANCE.isEditorConfigName((String)event.getOldValue()))) {
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                    this.fireEditorConfigChanged(virtualFile);
                }
            }

            public void fileCreated(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.notifyMaybeEditorConfigFileChange(event);
            }

            public void fileDeleted(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.notifyMaybeEditorConfigFileChange(event);
            }

            public void contentsChanged(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.notifyMaybeEditorConfigFileChange(event);
            }

            private final void notifyMaybeEditorConfigFileChange(VirtualFileEvent event) {
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                if (Utils.INSTANCE.isEditorConfigFile(virtualFile)) {
                    VirtualFile virtualFile2 = event.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                    this.fireEditorConfigChanged(virtualFile2);
                }
            }

            private final void fireEditorConfigChanged(VirtualFile ecFile) {
                if (ApplicationKt.getApplication().isUnitTestMode() && !Utils.isEnabledInTests()) {
                    return;
                }
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                for (Project project : projectArray) {
                    Intrinsics.checkNotNull((Object)project);
                    Project project2 = project;
                    if (!ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(ecFile) && EditorConfigRegistry.shouldStopAtProjectRoot()) continue;
                    Utils.INSTANCE.fireEditorConfigChanged(project2);
                }
            }
        });
    }
}

