/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.action.creation;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.action.creation.DTOModel;
import com.intellij.jpa.jpb.model.action.creation.DtoAttributeModel;
import com.intellij.jpa.jpb.model.action.creation.SubDtoType;
import com.intellij.jpa.jpb.model.backend.ed.EntityWriter;
import com.intellij.jpa.jpb.model.backend.events.ExceptionEvent;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.core.multilanguage.HLanguageService;
import com.intellij.jpa.jpb.model.core.util.DirectoryUtil;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.SourceLanguage;
import com.intellij.jpa.jpb.model.model.constraint.Constraint;
import com.intellij.jpa.jpb.model.util.HPsiUtil;
import com.intellij.jpa.jpb.model.util.JpaCommentUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ClassUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\u0017\u001a\u00020\u0013H&J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH&J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00152\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001aH&\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jpa/jpb/model/action/creation/DtoCreator;", "Lcom/intellij/jpa/jpb/model/core/multilanguage/HLanguageService;", "<init>", "()V", "create", "Lcom/intellij/psi/PsiClass;", "model", "Lcom/intellij/jpa/jpb/model/action/creation/DTOModel;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "createModelByAttribute", "modelAttr", "Lcom/intellij/jpa/jpb/model/action/creation/DtoAttributeModel;", "createExternalObjects", "", "dtoClass", "createNewDtoClass", "ownerDtoClass", "getTypeFqn", "", "getValidationAnnotationsText", "", "initDTOClass", "getTemplateName", "createInnerClass", "generateFields", "Lcom/intellij/psi/PsiElement;", "anchor", "Companion", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nDtoCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtoCreator.kt\ncom/intellij/jpa/jpb/model/action/creation/DtoCreator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,656:1\n13225#2,2:657\n*S KotlinDebug\n*F\n+ 1 DtoCreator.kt\ncom/intellij/jpa/jpb/model/action/creation/DtoCreator\n*L\n151#1:657,2\n*E\n"})
public abstract class DtoCreator
implements HLanguageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String IS_JSON_IGNORE_UNKNOWN_PROPERTIES = "DtoCreateDialog.IS_JSON_IGNORE_UNKNOWN_PROPERTIES";
    @NotNull
    public static final String USE_JAVA_RECORDS_INITIAL_PROP_KEY = "DtoCreateDialog.USE_JAVA_RECORDS_INITIAL_PROP_KEY";

    @Nullable
    public PsiClass create(@NotNull DTOModel model2, @NotNull PsiDirectory targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Project project = targetDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project2);
        Properties properties = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties props = properties;
        props.setProperty("NAME", model2.getClassName());
        props.setProperty("PACKAGE_NAME", model2.getPackageName());
        props.setProperty("CLASS_JAVA_DOC", JpaCommentUtils.INSTANCE.completeClassCommentText(project2, model2.getEntityFqn(), JpaPluginProjectConfig.Companion.getInstance((Project)project2).getState().dtoClassComment));
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(this.getTemplateName());
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)model2.getClassName(), (Properties)props, (PsiDirectory)targetDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement element = psiElement;
            PsiFile psiFile = element.getContainingFile();
            PsiClassOwner psiClassOwner = psiFile instanceof PsiClassOwner ? (PsiClassOwner)psiFile : null;
            if (psiClassOwner == null) {
                return null;
            }
            PsiClassOwner containingFile = psiClassOwner;
            PsiClass dtoClass = containingFile.getClasses()[0];
            Intrinsics.checkNotNull((Object)dtoClass);
            this.initDTOClass(dtoClass, model2);
            return dtoClass;
        }
        catch (Exception e) {
            new ExceptionEvent("Exception while trying to create spring projection: '" + model2.getClassName() + "'", e).post(project2);
            return null;
        }
    }

    @NotNull
    protected final DTOModel createModelByAttribute(@NotNull DTOModel model2, @NotNull DtoAttributeModel modelAttr) {
        DTOModel dTOModel;
        String string;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)modelAttr, (String)"modelAttr");
        String string2 = modelAttr.getDtoClassName();
        if (string2 == null) {
            throw new IllegalStateException("Sub DTO Class name is empty");
        }
        String newClassName = string2;
        if (modelAttr.getSubDtoType() == SubDtoType.NEW_NESTED_CLASS) {
            string = "";
        } else {
            String string3 = modelAttr.getDtoFqn();
            if (string3 == null) {
                throw new IllegalStateException("DTO FQN is null");
            }
            String dtoFqn = string3;
            string = ClassUtil.extractPackageName((String)dtoFqn);
        }
        String newPackageName = string;
        DTOModel $this$createModelByAttribute_u24lambda_u240 = dTOModel = new DTOModel();
        boolean bl = false;
        $this$createModelByAttribute_u24lambda_u240.setClassName(newClassName);
        Intrinsics.checkNotNull((Object)newPackageName);
        $this$createModelByAttribute_u24lambda_u240.setPackageName(newPackageName);
        $this$createModelByAttribute_u24lambda_u240.setEqualsHashCode(model2.isEqualsHashCode());
        $this$createModelByAttribute_u24lambda_u240.setToString(model2.isToString());
        $this$createModelByAttribute_u24lambda_u240.setAllArgsConstructor(model2.isAllArgsConstructor());
        $this$createModelByAttribute_u24lambda_u240.setMutable(model2.isMutable());
        $this$createModelByAttribute_u24lambda_u240.setEntityFqn(modelAttr.getEntityFqn());
        $this$createModelByAttribute_u24lambda_u240.setFluentSetters(model2.isFluentSetters());
        $this$createModelByAttribute_u24lambda_u240.getAttributes().clear();
        $this$createModelByAttribute_u24lambda_u240.getAttributes().addAll((Collection<DtoAttributeModel>)modelAttr.getAttributes());
        return dTOModel;
    }

    public final void createExternalObjects(@NotNull PsiClass dtoClass, @NotNull DTOModel model2) {
        Intrinsics.checkNotNullParameter((Object)dtoClass, (String)"dtoClass");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        for (DtoAttributeModel modelAttr : model2.getAttributes()) {
            SubDtoType subDtoType = modelAttr.getSubDtoType();
            if (subDtoType == SubDtoType.NEW_NESTED_CLASS) {
                this.createInnerClass(dtoClass, model2, modelAttr);
                continue;
            }
            if (subDtoType != SubDtoType.NEW_CLASS) continue;
            this.createNewDtoClass(dtoClass, model2, modelAttr);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void createNewDtoClass(@NotNull PsiClass ownerDtoClass, @NotNull DTOModel model2, @NotNull DtoAttributeModel modelAttr) {
        Intrinsics.checkNotNullParameter((Object)ownerDtoClass, (String)"ownerDtoClass");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)modelAttr, (String)"modelAttr");
        String dtoFqn = modelAttr.getDtoFqn();
        String packageName = ClassUtil.extractPackageName((String)dtoFqn);
        PsiDirectory psiDirectory = HPsiUtil.getSourceRoot((PsiElement)ownerDtoClass);
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory sourceRoot = psiDirectory;
        PsiDirectory psiDirectory2 = DirectoryUtil.findOrCreatePackageDirectory(sourceRoot, packageName);
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory2, (String)"findOrCreatePackageDirectory(...)");
        PsiDirectory foundDirectory = psiDirectory2;
        if (dtoFqn != null) {
            boolean bl;
            block4: {
                void $this$any$iv;
                String string = ClassUtil.extractClassName((String)dtoFqn);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractClassName(...)");
                String dtoClassName = string;
                String[] stringArray = SourceLanguage.allExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"allExtensions(...)");
                Object[] objectArray = stringArray;
                boolean $i$f$any = false;
                for (void element$iv : $this$any$iv) {
                    String ext = (String)element$iv;
                    boolean bl2 = false;
                    if (!(foundDirectory.findFile(dtoClassName + "." + ext) != null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        DTOModel newModel = this.createModelByAttribute(model2, modelAttr);
        this.create(newModel, foundDirectory);
    }

    @NotNull
    protected final String getTypeFqn(@NotNull PsiClass dtoClass, @NotNull DtoAttributeModel modelAttr) {
        Intrinsics.checkNotNullParameter((Object)dtoClass, (String)"dtoClass");
        Intrinsics.checkNotNullParameter((Object)modelAttr, (String)"modelAttr");
        Datatype attrType = modelAttr.getAttribute().getType();
        if (attrType instanceof Entity && modelAttr.getSubDtoType() != null && modelAttr.getSubDtoType() != SubDtoType.FLAT) {
            if ((modelAttr.getSubDtoType() == SubDtoType.EXIST_CLASS || modelAttr.getSubDtoType() == SubDtoType.NEW_CLASS) && modelAttr.getDtoFqn() != null) {
                String string = modelAttr.getDtoFqn();
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
            if (modelAttr.getSubDtoType() == SubDtoType.NEW_NESTED_CLASS) {
                String dtoClassFqn = dtoClass.getQualifiedName();
                String dtoClassPackageName = ClassUtil.extractPackageName((String)dtoClassFqn);
                if (dtoClassFqn != null) {
                    CharSequence charSequence = dtoClassPackageName;
                    return (String)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : dtoClassPackageName + ".") + ClassUtil.extractClassName((String)dtoClassFqn) + "." + modelAttr.getDtoNestedClassName();
                }
            }
        }
        String string = attrType.getFqn();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFqn(...)");
        return string;
    }

    @NotNull
    protected final List<String> getValidationAnnotationsText(@NotNull PsiClass dtoClass, @NotNull DtoAttributeModel modelAttr) {
        LinkedHashSet<Constraint> linkedHashSet;
        Intrinsics.checkNotNullParameter((Object)dtoClass, (String)"dtoClass");
        Intrinsics.checkNotNullParameter((Object)modelAttr, (String)"modelAttr");
        List<Constraint> constraints = modelAttr.getConstraints();
        EntityAttribute entityAttribute = modelAttr.getAttribute();
        EntityAttributeModel attributeModel = entityAttribute.getModel();
        LinkedHashSet<Constraint> it = linkedHashSet = attributeModel.getConstraints();
        boolean bl = false;
        it.clear();
        it.addAll((Collection<Constraint>)constraints);
        List<String> list = EntityWriter.getInstance((PsiElement)dtoClass).getValidationAnnotationsText(EntityPsi.getInstance(dtoClass), attributeModel);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValidationAnnotationsText(...)");
        return list;
    }

    public abstract void initDTOClass(@NotNull PsiClass var1, @NotNull DTOModel var2);

    @NotNull
    public abstract String getTemplateName();

    public abstract void createInnerClass(@NotNull PsiClass var1, @NotNull DTOModel var2, @NotNull DtoAttributeModel var3);

    @NotNull
    public abstract List<PsiElement> generateFields(@NotNull PsiClass var1, @NotNull DTOModel var2, @Nullable PsiElement var3);

    public static /* synthetic */ List generateFields$default(DtoCreator dtoCreator, PsiClass psiClass, DTOModel dTOModel, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateFields");
        }
        if ((n & 4) != 0) {
            psiElement = null;
        }
        return dtoCreator.generateFields(psiClass, dTOModel, psiElement);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/action/creation/DtoCreator$Companion;", "Lcom/intellij/jpa/jpb/model/core/multilanguage/HLanguageService$Provider;", "Lcom/intellij/jpa/jpb/model/action/creation/DtoCreator;", "<init>", "()V", "IS_JSON_IGNORE_UNKNOWN_PROPERTIES", "", "USE_JAVA_RECORDS_INITIAL_PROP_KEY", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion
    extends HLanguageService.Provider<DtoCreator> {
        private Companion() {
            super(DtoCreator.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

