/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.action.creation.customType;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.action.creation.customType.CustomTypeCreationInfo;
import com.intellij.jpa.jpb.model.action.creation.customType.HibernateCustomTypeRegistry;
import com.intellij.jpa.jpb.model.backend.events.ExceptionEvent;
import com.intellij.jpa.jpb.model.model.SourceLanguage;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ8\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u0004\u0018\u00010\r*\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016H\u0002J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/jpa/jpb/model/action/creation/customType/HibernateCustomTypeGenerator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "codeStyleManager", "Lcom/intellij/psi/codeStyle/JavaCodeStyleManager;", "kotlin.jvm.PlatformType", "generateType", "", "Lcom/intellij/psi/PsiClass;", "creationInfo", "Lcom/intellij/jpa/jpb/model/action/creation/customType/CustomTypeCreationInfo;", "generateDescriptor", "props", "Ljava/util/Properties;", "templateManager", "Lcom/intellij/ide/fileTemplates/FileTemplateManager;", "typeName", "", "directory", "Lcom/intellij/psi/PsiDirectory;", "language", "Lcom/intellij/jpa/jpb/model/model/SourceLanguage;", "templateHelper", "Lcom/intellij/jpa/jpb/model/reference/TemplateHelper;", "getClass", "Lcom/intellij/psi/PsiElement;", "getTypeName", "className", "getTemplate", "generationLanguage", "isDescriptor", "", "Companion", "intellij.javaee.jpa.jpb.model"})
public final class HibernateCustomTypeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final JavaCodeStyleManager codeStyleManager;
    @NotNull
    public static final String SQL_TYPE_DESCRIPTOR_FQN = "org.hibernate.type.descriptor.sql.SqlTypeDescriptor";
    @NotNull
    public static final String TYPE_FQN = "TYPE";
    @NotNull
    public static final String TYPE_NAME = "TYPE_NAME";
    @NotNull
    public static final String TYPE_SUFFIX = "Type";
    @NotNull
    public static final String PARAMETRIZED = "PARAMETRIZED";
    @NotNull
    public static final String JAVA_TYPE_DESCRIPTOR = "JAVA_TYPE_DESCRIPTOR";
    @NotNull
    public static final String SQL_TYPE_DESCRIPTOR = "SQL_DESCRIPTOR";
    @NotNull
    public static final String CONSTANT_INSTANCE = "CONSTANT_INSTANCE";

    public HibernateCustomTypeGenerator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<PsiClass> generateType(@NotNull CustomTypeCreationInfo creationInfo) {
        Intrinsics.checkNotNullParameter((Object)creationInfo, (String)"creationInfo");
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)this.project);
        Language language = creationInfo.getLanguage().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance(this.project, language);
        Properties properties = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties props = properties;
        PsiPackage creationPackage = JavaDirectoryService.getInstance().getPackage(creationInfo.getDirectory());
        String typeName = this.getTypeName(creationInfo.getClassName());
        HibernateCustomTypeRegistry sqlTypeRegistry = HibernateCustomTypeRegistry.Companion.getInstance(this.project);
        Object object = creationPackage;
        if (object == null || (object = object.getQualifiedName()) == null) {
            object = "";
        }
        props.setProperty("PACKAGE_NAME", (String)object);
        TemplateHelper templateHelper2 = templateHelper;
        props.setProperty(TYPE_FQN, templateHelper2 != null ? templateHelper2.convertType(creationInfo.getEntityTypeFqn(), this.project) : null);
        props.setProperty(TYPE_NAME, typeName);
        props.setProperty(PARAMETRIZED, String.valueOf(creationInfo.getParametrized()));
        Intrinsics.checkNotNull((Object)templateManager);
        PsiDirectory psiDirectory = creationInfo.getDirectory();
        SourceLanguage sourceLanguage = creationInfo.getLanguage();
        TemplateHelper templateHelper3 = templateHelper;
        Intrinsics.checkNotNull((Object)templateHelper3);
        PsiClass psiClass = this.generateDescriptor(props, templateManager, typeName, psiDirectory, sourceLanguage, templateHelper3);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass descriptorClass = psiClass;
        props.setProperty("NAME", creationInfo.getClassName());
        String string = sqlTypeRegistry.getSqlDescriptorByDbType(creationInfo.getSqlType());
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String descriptorByDbType = string;
        boolean isConstant = StringsKt.endsWith$default((String)descriptorByDbType, (String)"DEFAULT", (boolean)false, (int)2, null);
        props.setProperty(CONSTANT_INSTANCE, String.valueOf(isConstant));
        props.setProperty(SQL_TYPE_DESCRIPTOR, descriptorByDbType);
        props.setProperty(JAVA_TYPE_DESCRIPTOR, descriptorClass.getQualifiedName());
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(this.getTemplate(creationInfo.getLanguage(), false));
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)creationInfo.getClassName(), (Properties)props, (PsiDirectory)creationInfo.getDirectory());
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement createdClass = psiElement;
            PsiClass psiClass2 = this.getClass(createdClass, templateHelper);
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> HibernateCustomTypeGenerator.generateType$lambda$0(templateHelper, psiClass2, this));
            Object[] objectArray = new PsiClass[]{psiClass2, descriptorClass};
            return CollectionsKt.listOfNotNull((Object[])objectArray);
        }
        catch (Exception e) {
            new ExceptionEvent("Exception while trying to create custom type: '" + creationInfo.getClassName() + "'", e).post(this.project);
            return CollectionsKt.emptyList();
        }
    }

    @Nullable
    public final PsiClass generateDescriptor(@NotNull Properties props, @NotNull FileTemplateManager templateManager, @NotNull String typeName, @NotNull PsiDirectory directory, @NotNull SourceLanguage language, @NotNull TemplateHelper templateHelper) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)templateManager, (String)"templateManager");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)templateHelper, (String)"templateHelper");
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(this.getTemplate(language, true));
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        try {
            props.setProperty("NAME", typeName);
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)(typeName + "Descriptor"), (Properties)props, (PsiDirectory)directory);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement createdClass = psiElement;
            PsiClass psiClass = this.getClass(createdClass, templateHelper);
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> HibernateCustomTypeGenerator.generateDescriptor$lambda$0(templateHelper, psiClass, this));
            return psiClass;
        }
        catch (Exception e) {
            new ExceptionEvent("Exception while trying to create custom type: '" + typeName + "Descriptor'", e).post(this.project);
            return null;
        }
    }

    private final PsiClass getClass(PsiElement $this$getClass, TemplateHelper templateHelper) {
        return $this$getClass instanceof PsiFile ? templateHelper.getClass((PsiFile)$this$getClass) : ($this$getClass instanceof PsiClass ? (PsiClass)$this$getClass : null);
    }

    private final String getTypeName(String className) {
        return StringsKt.removeSuffix((String)className, (CharSequence)TYPE_SUFFIX);
    }

    private final String getTemplate(SourceLanguage generationLanguage, boolean isDescriptor) {
        return switch (WhenMappings.$EnumSwitchMapping$0[generationLanguage.ordinal()]) {
            case 1 -> {
                if (isDescriptor) {
                    yield "com.intellij.jpb.BasicTypeDescriptor.kt";
                }
                yield "com.intellij.jpb.BasicType.kt";
            }
            case 2 -> {
                if (isDescriptor) {
                    yield "com.intellij.jpb.BasicTypeDescriptor.java";
                }
                yield "com.intellij.jpb.BasicType.java";
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    private static final void generateType$lambda$0(TemplateHelper $templateHelper, PsiClass $psiClass, HibernateCustomTypeGenerator this$0) {
        PsiClass psiClass = $psiClass;
        Intrinsics.checkNotNull((Object)psiClass);
        $templateHelper.shortenReferences((PsiElement)psiClass);
        new OptimizeImportsProcessor(this$0.project, $psiClass.getContainingFile()).run();
    }

    private static final void generateDescriptor$lambda$0(TemplateHelper $templateHelper, PsiClass $psiClass, HibernateCustomTypeGenerator this$0) {
        PsiClass psiClass = $psiClass;
        Intrinsics.checkNotNull((Object)psiClass);
        $templateHelper.shortenReferences((PsiElement)psiClass);
        new OptimizeImportsProcessor(this$0.project, $psiClass.getContainingFile()).run();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jpa/jpb/model/action/creation/customType/HibernateCustomTypeGenerator$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/action/creation/customType/HibernateCustomTypeGenerator;", "project", "Lcom/intellij/openapi/project/Project;", "SQL_TYPE_DESCRIPTOR_FQN", "", "TYPE_FQN", "TYPE_NAME", "TYPE_SUFFIX", "PARAMETRIZED", "JAVA_TYPE_DESCRIPTOR", "SQL_TYPE_DESCRIPTOR", "CONSTANT_INSTANCE", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nHibernateCustomTypeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HibernateCustomTypeGenerator.kt\ncom/intellij/jpa/jpb/model/action/creation/customType/HibernateCustomTypeGenerator$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,120:1\n30#2,2:121\n*S KotlinDebug\n*F\n+ 1 HibernateCustomTypeGenerator.kt\ncom/intellij/jpa/jpb/model/action/creation/customType/HibernateCustomTypeGenerator$Companion\n*L\n110#1:121,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HibernateCustomTypeGenerator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<HibernateCustomTypeGenerator> serviceClass$iv = HibernateCustomTypeGenerator.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (HibernateCustomTypeGenerator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceLanguage.values().length];
            try {
                nArray[SourceLanguage.KOTLIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceLanguage.JAVA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

