/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jpa.jpb.model.backend.ed.FqnResolverManagerKt;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.inspection.AbstractJpaInspection;
import com.intellij.jpa.jpb.model.inspection.fix.DeleteCascadeTypeRemoveForManyToManyFix;
import com.intellij.jpa.jpb.model.inspection.fix.ReplaceAllWithoutRemoveCascadeForManyToManyFix;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0015H\u0014\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jpa/jpb/model/inspection/ManyToManyCascadeRemoveInspection;", "Lcom/intellij/jpa/jpb/model/inspection/AbstractJpaInspection;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getProblemDescriptorMessage", "", "isInspectionAvailable", "isApplyInspection", "psiClass", "Lcom/intellij/psi/PsiClass;", "getProblemPsiElements", "Lcom/intellij/psi/PsiElement;", "uClass", "Lorg/jetbrains/uast/UClass;", "(Lorg/jetbrains/uast/UClass;)[Lcom/intellij/psi/PsiElement;", "getFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "entityClass", "psiElement", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nManyToManyCascadeRemoveInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManyToManyCascadeRemoveInspection.kt\ncom/intellij/jpa/jpb/model/inspection/ManyToManyCascadeRemoveInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,90:1\n12033#2,10:91\n14060#2:101\n14061#2:103\n12043#2:104\n13225#2,2:113\n12033#2,10:115\n14060#2:125\n14061#2:128\n12043#2:129\n1#3:102\n1#3:127\n1391#4:105\n1480#4,5:106\n37#5,2:111\n37#5,2:130\n455#6:126\n*S KotlinDebug\n*F\n+ 1 ManyToManyCascadeRemoveInspection.kt\ncom/intellij/jpa/jpb/model/inspection/ManyToManyCascadeRemoveInspection\n*L\n30#1:91,10\n30#1:101\n30#1:103\n30#1:104\n47#1:113,2\n54#1:115,10\n54#1:125\n54#1:128\n54#1:129\n30#1:102\n54#1:127\n31#1:105\n31#1:106,5\n32#1:111,2\n79#1:130,2\n66#1:126\n*E\n"})
public final class ManyToManyCascadeRemoveInspection
extends AbstractJpaInspection {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (this.isInspectionAvailable(file)) {
            void $this$toTypedArray$iv;
            void $this$flatMapTo$iv$iv;
            Collection $this$flatMap$iv;
            void $this$mapNotNullTo$iv$iv;
            PsiClass[] classes;
            PsiClass[] psiClassArray = ((PsiClassOwner)file).getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
            Object $this$mapNotNull$iv = classes = psiClassArray;
            boolean $i$f$mapNotNull = false;
            PsiClass[] psiClassArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                UClass it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if ((UClass)UastContextKt.toUElement((PsiElement)((PsiElement)it), UClass.class) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                UClass it = (UClass)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ArraysKt.toList((Object[])this.createProblemDescriptors(it, manager, isOnTheFly, this.getProblemPsiElements(it)));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new ProblemDescriptor[0]);
        }
        return new ProblemDescriptor[0];
    }

    @Override
    @NotNull
    protected String getProblemDescriptorMessage() {
        String string = JpaModelBundle.message("inspection.ManyToManyCascadeRemove", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isInspectionAvailable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean inspectionAvailable = super.isInspectionAvailable(file);
        if (!inspectionAvailable) {
            return false;
        }
        if (!JpaUtils.isHibernateProject(file.getProject(), PsiUtilsKt.module(file))) return false;
        if (!(file instanceof PsiClassOwner)) return false;
        PsiClass[] psiClassArray = (PsiClass[])file;
        PsiClass[] psiClassArray2 = psiClassArray;
        if (psiClassArray == null) return false;
        PsiClass[] psiClassArray3 = psiClassArray2.getClasses();
        psiClassArray2 = psiClassArray3;
        if (psiClassArray3 == null) return false;
        PsiClass[] $this$any$iv = psiClassArray2;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            PsiClass element$iv;
            PsiClass it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (EntityUtil.isEntity(it)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    protected boolean isApplyInspection(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected PsiElement[] getProblemPsiElements(@NotNull UClass uClass) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        PsiElement psiElement = uClass.getSourcePsi();
        if (psiElement == null) {
            return new PsiElement[0];
        }
        PsiElement sourcePsi = psiElement;
        UField[] $this$mapNotNull$iv = uClass.getFields();
        boolean $i$f$mapNotNull = false;
        UField[] uFieldArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PsiReferenceExpression psiReferenceExpression;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            Project project = sourcePsi.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (it.findAnnotation(FqnResolverManagerKt.getJpaFqn(project, PsiUtilsKt.module((PsiElement)uClass), JpaAttributeAnnotation.ManyToMany)) == null) {
                psiReferenceExpression = null;
            } else {
                UAnnotation manyToManyAnnotation;
                PsiAnnotation psiAnnotation = manyToManyAnnotation.getJavaPsi();
                if (psiAnnotation == null || (psiAnnotation = psiAnnotation.findAttributeValue("cascade")) == null) {
                    psiReferenceExpression = null;
                } else {
                    Object v8;
                    block12: {
                        List list;
                        PsiAnnotation cascadeAttributeElement = psiAnnotation;
                        if (cascadeAttributeElement instanceof PsiReferenceExpression) {
                            list = CollectionsKt.listOf((Object)cascadeAttributeElement);
                        } else {
                            PsiElement $this$childrenOfType$iv = (PsiElement)cascadeAttributeElement;
                            boolean $i$f$childrenOfType = false;
                            List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, PsiReferenceExpression.class);
                            list = list2;
                            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
                        }
                        List referenceExpressions = list;
                        Iterable iterable = referenceExpressions;
                        for (Object t : iterable) {
                            boolean bl3;
                            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)t;
                            boolean bl4 = false;
                            if (referenceExpression.getReferenceName() == null) {
                                bl3 = false;
                            } else {
                                String string = referenceExpression.getReferenceName();
                                Intrinsics.checkNotNull((Object)string);
                                EntityAttribute.CascadeType cascadeType = (EntityAttribute.CascadeType)StringUtil.parseEnum((String)string, null, EntityAttribute.CascadeType.class);
                                bl3 = cascadeType == EntityAttribute.CascadeType.REMOVE || cascadeType == EntityAttribute.CascadeType.ALL;
                            }
                            if (!bl3) continue;
                            v8 = t;
                            break block12;
                        }
                        v8 = null;
                    }
                    psiReferenceExpression = v8;
                }
            }
            if (psiReferenceExpression == null) continue;
            PsiReferenceExpression it$iv$iv = psiReferenceExpression;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List problemElements = (List)destination$iv$iv;
        if (!((Collection)problemElements).isEmpty()) {
            Collection $this$toTypedArray$iv = problemElements;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new PsiElement[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected LocalQuickFix[] getFixes(@NotNull UClass entityClass, @NotNull PsiElement psiElement) {
        LocalQuickFix[] localQuickFixArray;
        Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof PsiReferenceExpression) || ((PsiReferenceExpression)psiElement).getReferenceName() == null) {
            return new LocalQuickFix[0];
        }
        String string = ((PsiReferenceExpression)psiElement).getReferenceName();
        Intrinsics.checkNotNull((Object)string);
        if (StringUtil.parseEnum((String)string, null, EntityAttribute.CascadeType.class) == EntityAttribute.CascadeType.ALL) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{new ReplaceAllWithoutRemoveCascadeForManyToManyFix()};
            localQuickFixArray = localQuickFixArray2;
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[]{new DeleteCascadeTypeRemoveForManyToManyFix()};
            localQuickFixArray = localQuickFixArray3;
        }
        return localQuickFixArray;
    }
}

