/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.inspection.fix;

import com.intellij.jpa.jpb.model.inspection.fix.AnnotationReplacer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u001b\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jpa/jpb/model/inspection/fix/JavaAnnotationReplacer;", "Lcom/intellij/jpa/jpb/model/inspection/fix/AnnotationReplacer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "replace", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "annotationFqn", "", "migrateValueAttr", "", "annotationFqns", "", "removeAnnotation", "optimizeImports", "removeAnnotationAttribute", "attributeName", "getAttributesAsString", "attributes", "", "Lcom/intellij/psi/PsiNameValuePair;", "([Lcom/intellij/psi/PsiNameValuePair;)Ljava/lang/String;", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nAnnotationReplacer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationReplacer.kt\ncom/intellij/jpa/jpb/model/inspection/fix/JavaAnnotationReplacer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1915#2,2:96\n1#3:98\n*S KotlinDebug\n*F\n+ 1 AnnotationReplacer.kt\ncom/intellij/jpa/jpb/model/inspection/fix/JavaAnnotationReplacer\n*L\n48#1:96,2\n*E\n"})
public final class JavaAnnotationReplacer
extends AnnotationReplacer {
    @NotNull
    private final Project project;

    public JavaAnnotationReplacer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void replace(@NotNull PsiElement psiElement, @NotNull String annotationFqn, boolean migrateValueAttr) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)annotationFqn, (String)"annotationFqn");
        this.replace(psiElement, CollectionsKt.listOf((Object)annotationFqn), migrateValueAttr);
    }

    @Override
    public void replace(@NotNull PsiElement psiElement, @NotNull List<String> annotationFqns, boolean migrateValueAttr) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(annotationFqns, (String)"annotationFqns");
        if (annotationFqns.isEmpty()) {
            return;
        }
        PsiAnnotation psiAnnotation = psiElement instanceof PsiAnnotation ? (PsiAnnotation)psiElement : null;
        if (psiAnnotation == null) {
            return;
        }
        PsiAnnotation problemAnnotation = psiAnnotation;
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.project);
        ApplicationManager.getApplication().runWriteAction(() -> JavaAnnotationReplacer.replace$lambda$0(this, migrateValueAttr, problemAnnotation, annotationFqns, javaCodeStyleManager));
    }

    @Override
    public void removeAnnotation(@NotNull PsiElement psiElement, boolean optimizeImports) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiAnnotation psiAnnotation = psiElement instanceof PsiAnnotation ? (PsiAnnotation)psiElement : null;
        if (psiAnnotation == null) {
            return;
        }
        PsiAnnotation problemAnnotation = psiAnnotation;
        PsiFile containingFile = problemAnnotation.getContainingFile();
        ApplicationManager.getApplication().runWriteAction(() -> JavaAnnotationReplacer.removeAnnotation$lambda$0(problemAnnotation, optimizeImports, this, containingFile));
    }

    @Override
    public void removeAnnotationAttribute(@NotNull PsiElement psiElement, @NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        if (psiElement instanceof PsiAnnotation) {
            ((PsiAnnotation)psiElement).setDeclaredAttributeValue(attributeName, null);
        }
    }

    private final String getAttributesAsString(PsiNameValuePair[] attributes) {
        return !(attributes.length == 0) ? ArraysKt.joinToString$default((Object[])attributes, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, JavaAnnotationReplacer::getAttributesAsString$lambda$0, (int)24, null) : "";
    }

    private static final void replace$lambda$0(JavaAnnotationReplacer this$0, boolean $migrateValueAttr, PsiAnnotation $problemAnnotation, List $annotationFqns, JavaCodeStyleManager $javaCodeStyleManager) {
        String string;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this$0.project);
        PsiElementFactory psiElementFactory = javaPsiFacade.getElementFactory();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
        PsiElementFactory elementFactory = psiElementFactory;
        if ($migrateValueAttr) {
            PsiNameValuePair[] psiNameValuePairArray = $problemAnnotation.getParameterList().getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePairArray, (String)"getAttributes(...)");
            string = this$0.getAttributesAsString(psiNameValuePairArray);
        } else {
            string = "";
        }
        String attributesStr = string;
        PsiElement container = $problemAnnotation.getParent();
        PsiAnnotation anchor = null;
        anchor = $problemAnnotation;
        Iterable $this$forEach$iv = $annotationFqns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiAnnotation annotation;
            String it = (String)element$iv;
            boolean bl = false;
            PsiAnnotationOwner psiAnnotationOwner = $problemAnnotation.getOwner();
            if (psiAnnotationOwner != null ? psiAnnotationOwner.hasAnnotation(it) : false) continue;
            Intrinsics.checkNotNullExpressionValue((Object)elementFactory.createAnnotationFromText("@" + it + attributesStr, $problemAnnotation.getContext()), (String)"createAnnotationFromText(...)");
            PsiElement insertedAnnotation = container.addAfter((PsiElement)annotation, (PsiElement)anchor);
            Intrinsics.checkNotNull((Object)insertedAnnotation, (String)"null cannot be cast to non-null type com.intellij.psi.PsiAnnotation");
            anchor = (PsiAnnotation)insertedAnnotation;
            $javaCodeStyleManager.shortenClassReferences(insertedAnnotation);
            $javaCodeStyleManager.optimizeImports(((PsiAnnotation)insertedAnnotation).getContainingFile());
        }
        $problemAnnotation.delete();
    }

    private static final void removeAnnotation$lambda$0(PsiAnnotation $problemAnnotation, boolean $optimizeImports, JavaAnnotationReplacer this$0, PsiFile $containingFile) {
        $problemAnnotation.delete();
        if ($optimizeImports) {
            JavaCodeStyleManager.getInstance((Project)this$0.project).optimizeImports($containingFile);
        }
    }

    private static final CharSequence getAttributesAsString$lambda$0(PsiNameValuePair pair) {
        Object object;
        PsiAnnotationMemberValue psiAnnotationMemberValue;
        Object object2;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)pair, (String)"pair");
                object2 = pair.getName();
                if (object2 == null) break block7;
                String it = object2;
                boolean bl = false;
                String string = it + " =";
                object2 = string;
                if (string != null) break block8;
            }
            object2 = "";
        }
        if ((psiAnnotationMemberValue = pair.getValue()) instanceof PsiLiteralExpression) {
            PsiAnnotationMemberValue psiAnnotationMemberValue2 = pair.getValue();
            Intrinsics.checkNotNull((Object)psiAnnotationMemberValue2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiLiteralExpression");
            Object value = ((PsiLiteralExpression)psiAnnotationMemberValue2).getValue();
            PsiAnnotationMemberValue psiAnnotationMemberValue3 = pair.getValue();
            PsiLiteralExpressionImpl psiLiteralExpressionImpl = psiAnnotationMemberValue3 instanceof PsiLiteralExpressionImpl ? (PsiLiteralExpressionImpl)psiAnnotationMemberValue3 : null;
            object = Intrinsics.areEqual((Object)(psiLiteralExpressionImpl != null ? psiLiteralExpressionImpl.getType() : null), (Object)PsiTypes.booleanType()) ? value : "\"" + value + "\"";
        } else if (psiAnnotationMemberValue instanceof PsiReferenceExpression) {
            PsiAnnotationMemberValue psiAnnotationMemberValue4 = pair.getValue();
            Intrinsics.checkNotNull((Object)psiAnnotationMemberValue4, (String)"null cannot be cast to non-null type com.intellij.psi.PsiReferenceExpression");
            object = ((PsiReferenceExpression)psiAnnotationMemberValue4).getText();
        } else {
            object = "";
        }
        return (String)object2 + object;
    }
}

