/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.inspection.fix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jpa.jpb.model.backend.ed.EntityWriter;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jpa/jpb/model/inspection/fix/MakeEmbeddableEntitySerializableFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/application/WriteActionAware;", "className", "", "<init>", "(Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.javaee.jpa.jpb.model"})
public final class MakeEmbeddableEntitySerializableFix
implements LocalQuickFix,
WriteActionAware {
    @NotNull
    private final String className;

    public MakeEmbeddableEntitySerializableFix(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.className = className;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{StringsKt.replace$default((String)this.className, (String)"?", (String)"", (boolean)false, (int)4, null)};
        String string = JpaModelBundle.message("makeCompositeClassSerializable.fix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiClassType psiClassType;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        EntityWriter writer = EntityWriter.getInstance(descriptor.getPsiElement());
        UElement element = UastContextKt.toUElement((PsiElement)descriptor.getPsiElement());
        if (element instanceof UTypeReferenceExpression) {
            PsiType psiType = ((UTypeReferenceExpression)element).getType();
            psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
                return;
            }
        } else {
            return;
        }
        PsiClassType psiClass = psiClassType;
        writer.addSerializableParentIfNeeded((PsiClass)psiClass);
        PsiField psiField = psiClass.findFieldByName("serialVersionUID", true);
        if (psiField == null) {
            writer.addSerialVersionUID((PsiClass)psiClass);
            psiField = Unit.INSTANCE;
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

