/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.reference.provider;

import com.intellij.jpa.jpb.model.reference.provider.JPsiReferenceProvider;
import com.intellij.jpa.jpb.model.reference.provider.TableColumnNameReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH&J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jpa/jpb/model/reference/provider/TableColumnNamesReferenceProvider;", "Lcom/intellij/jpa/jpb/model/reference/provider/JPsiReferenceProvider;", "<init>", "()V", "createReferences", "", "Lcom/intellij/psi/PsiReference;", "attributeValue", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "getTableName", "", "getColumnNames", "Companion", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nTableColumnNamesReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableColumnNamesReferenceProvider.kt\ncom/intellij/jpa/jpb/model/reference/provider/TableColumnNamesReferenceProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,41:1\n1342#2,2:42\n37#3,2:44\n*S KotlinDebug\n*F\n+ 1 TableColumnNamesReferenceProvider.kt\ncom/intellij/jpa/jpb/model/reference/provider/TableColumnNamesReferenceProvider\n*L\n24#1:42,2\n34#1:44,2\n*E\n"})
public abstract class TableColumnNamesReferenceProvider
extends JPsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex COLUMN_NAME_PATTERN = new Regex("([^\\s,]+)");

    @NotNull
    public final PsiReference[] createReferences(@NotNull PsiElement attributeValue) {
        String columnNames;
        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
        String string = this.getTableName(attributeValue);
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        String tableName = string;
        List result = new ArrayList();
        String string2 = this.getColumnNames(attributeValue);
        if (string2 == null) {
            string2 = "";
        }
        if (StringsKt.isBlank((CharSequence)(columnNames = string2))) {
            PsiReference[] psiReferenceArray = new PsiReference[1];
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            psiReferenceArray[0] = new TableColumnNameReference(tableName, columnNames, attributeValue, textRange);
            return psiReferenceArray;
        }
        Sequence foundColumnNames = Regex.findAll$default((Regex)COLUMN_NAME_PATTERN, (CharSequence)columnNames, (int)0, (int)2, null);
        List alreadyExistsNames = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)foundColumnNames, TableColumnNamesReferenceProvider::createReferences$lambda$0));
        Sequence $this$forEach$iv = foundColumnNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult matchResult = (MatchResult)element$iv;
            boolean bl = false;
            String columnName = matchResult.getValue();
            int start = matchResult.getRange().getFirst() + 1;
            TextRange textRange = new TextRange(start, start + columnName.length());
            result.add(new TableColumnNameReference(tableName, columnName, attributeValue, textRange, alreadyExistsNames){
                final /* synthetic */ List<String> $alreadyExistsNames;
                {
                    this.$alreadyExistsNames = $alreadyExistsNames;
                    super($tableName, $columnName, $attributeValue, $textRange);
                }

                protected boolean filterColumnName(String columnName) {
                    Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
                    return !this.$alreadyExistsNames.contains(columnName);
                }
            });
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    @Nullable
    public abstract String getTableName(@NotNull PsiElement var1);

    @Nullable
    public abstract String getColumnNames(@NotNull PsiElement var1);

    private static final String createReferences$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jpa/jpb/model/reference/provider/TableColumnNamesReferenceProvider$Companion;", "", "<init>", "()V", "COLUMN_NAME_PATTERN", "Lkotlin/text/Regex;", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

