/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.filters;

import com.intellij.coverage.filters.ModifiedFilesFilterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000f\u0010\u0011\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/coverage/filters/ModifiedFilesFilter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "hasFilteredFiles", "getHasFilteredFiles", "()Z", "resetFilteredFiles", "", "isFileModified", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInModifiedScope", "getBranchName", "", "Lorg/jetbrains/annotations/Nls;", "isModifiedLocally", "Companion", "intellij.platform.coverage"})
@ApiStatus.Internal
public class ModifiedFilesFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private volatile boolean hasFilteredFiles;

    public ModifiedFilesFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final boolean getHasFilteredFiles() {
        return this.hasFilteredFiles;
    }

    public final void resetFilteredFiles() {
        this.hasFilteredFiles = false;
    }

    public final boolean isFileModified(@NotNull VirtualFile file) {
        boolean isModified;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean it = bl = (isModified = this.isModifiedLocally(file) || this.isInModifiedScope(file));
        boolean bl2 = false;
        if (!isModified && !this.hasFilteredFiles) {
            this.hasFilteredFiles = true;
        }
        return bl;
    }

    public boolean isInModifiedScope(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return false;
    }

    @Nullable
    public String getBranchName() {
        return null;
    }

    private final boolean isModifiedLocally(VirtualFile file) {
        FileStatus fileStatus = FileStatusManager.getInstance((Project)this.project).getStatus(file);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        FileStatus status = fileStatus;
        boolean isCurrentlyChanged = status == FileStatus.MODIFIED || status == FileStatus.ADDED || status == FileStatus.UNKNOWN;
        return isCurrentlyChanged;
    }

    @JvmStatic
    @NotNull
    public static final ModifiedFilesFilter create(@NotNull Project project) {
        return Companion.create(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/coverage/filters/ModifiedFilesFilter$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/coverage/filters/ModifiedFilesFilter;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.coverage"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ModifiedFilesFilter create(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ModifiedFilesFilter filter = (ModifiedFilesFilter)ModifiedFilesFilterFactory.Companion.getEP_NAME().computeSafeIfAny(arg_0 -> Companion.create$lambda$0(project, arg_0));
            if (filter != null) {
                return filter;
            }
            return new ModifiedFilesFilter(project);
        }

        private static final ModifiedFilesFilter create$lambda$0(Project $project, ModifiedFilesFilterFactory it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.createFilter($project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

