/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.screenForwarding;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.platform.codeWithMe.screenForwarding.ScreenForwardingCommonSettings;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0006\u0010\u0002\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0003"}, d2={"defaultXpraLocationWindows", "", "getEffectiveXpraExecutablePath", "intellij.platform.split"})
public final class ScreenForwardingCommonUtilKt {
    @NotNull
    private static final String defaultXpraLocationWindows = "C:/Program Files/Xpra/Xpra_cmd.exe";

    @NotNull
    public static final String getEffectiveXpraExecutablePath() {
        String xpraExecutablePathFromSettings = ScreenForwardingCommonSettings.Companion.getInstance().getXpraExecutablePath();
        if (!StringsKt.isBlank((CharSequence)xpraExecutablePathFromSettings)) {
            Path path = Paths.get(xpraExecutablePathFromSettings, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path file = path;
            if (!Files.isExecutable(file)) {
                Object[] objectArray = new Object[]{xpraExecutablePathFromSettings};
                throw new FileNotFoundException(PlatformSplitBundle.INSTANCE.message("screen.forwarding.xpra.not.found.path.from.settings", objectArray));
            }
            return ((Object)file.toAbsolutePath()).toString();
        }
        if (PathEnvironmentVariableUtil.isOnPath((String)"xpra")) {
            return "xpra";
        }
        if (SystemInfoRt.isWindows) {
            Path path = Paths.get(defaultXpraLocationWindows, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            if (!Files.isExecutable(path)) {
                Object[] objectArray = new Object[]{defaultXpraLocationWindows};
                throw new FileNotFoundException(PlatformSplitBundle.INSTANCE.message("screen.forwarding.xpra.not.found.env.path.and.default.location", objectArray));
            }
            return defaultXpraLocationWindows;
        }
        throw new FileNotFoundException(PlatformSplitBundle.INSTANCE.message("screen.forwarding.xpra.not.found.env.path", new Object[0]));
    }
}

