/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.css;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.polySymbols.css.CssContextualSymbolScope;
import com.intellij.polySymbols.css.CssCustomPropertiesScope;
import com.intellij.polySymbols.css.CssPropertiesScope;
import com.intellij.polySymbols.css.CssSymbolQueryScopeContributor;
import com.intellij.polySymbols.query.PolySymbolLocationQueryScopeProvider;
import com.intellij.polySymbols.query.PolySymbolQueryScopeContributor;
import com.intellij.polySymbols.query.PolySymbolQueryScopeProviderRegistrar;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/polySymbols/css/CssSymbolQueryScopeContributor;", "Lcom/intellij/polySymbols/query/PolySymbolQueryScopeContributor;", "<init>", "()V", "registerProviders", "", "registrar", "Lcom/intellij/polySymbols/query/PolySymbolQueryScopeProviderRegistrar;", "intellij.css.backend"})
public final class CssSymbolQueryScopeContributor
implements PolySymbolQueryScopeContributor {
    public void registerProviders(@NotNull PolySymbolQueryScopeProviderRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        registrar.forAnywhere().contributeScopeProvider(CssSymbolQueryScopeContributor::registerProviders$lambda$0);
        registrar.forAnyPsiLocationInFile().contributeScopeProvider(CssSymbolQueryScopeContributor::registerProviders$lambda$1);
        Class[] classArray = new Class[]{XmlAttributeValue.class, XmlAttribute.class, XmlTag.class};
        registrar.forPsiLocations(classArray).contributeScopeProvider((PolySymbolLocationQueryScopeProvider)registerProviders.3.INSTANCE);
        classArray = new PsiElementPattern[2];
        Intrinsics.checkNotNullExpressionValue((Object)PlatformPatterns.psiElement(CssElement.class), (String)"psiElement(...)");
        Intrinsics.checkNotNullExpressionValue((Object)PlatformPatterns.psiElement(LeafPsiElement.class).withParent(CssElement.class), (String)"withParent(...)");
        registrar.forPsiLocations((PsiElementPattern[])classArray).contributeScopeProvider(CssSymbolQueryScopeContributor::registerProviders$lambda$2);
    }

    private static final List registerProviders$lambda$0(Project project, PsiElement location) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object)((Object)new CssPropertiesScope(project)));
    }

    private static final List registerProviders$lambda$1(PsiElement location) {
        List list;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        PsiFile containingFile = location.getContainingFile();
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile((PsiElement)containingFile);
        if (topLevelFile == null) {
            list = CollectionsKt.emptyList();
        } else if (!Intrinsics.areEqual((Object)topLevelFile, (Object)containingFile)) {
            Intrinsics.checkNotNull((Object)containingFile);
            list = CollectionsKt.listOf((Object)((Object)new CssCustomPropertiesScope(containingFile)));
        } else {
            list = CollectionsKt.listOf((Object)((Object)new CssCustomPropertiesScope(topLevelFile)));
        }
        return list;
    }

    private static final List registerProviders$lambda$2(PsiElement it) {
        CssElement cssElement = it instanceof CssElement ? (CssElement)it : null;
        if (cssElement == null) {
            PsiElement psiElement = it.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.css.CssElement");
            cssElement = (CssElement)psiElement;
        }
        return CollectionsKt.listOf((Object)((Object)new CssContextualSymbolScope(cssElement)));
    }
}

