/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.NestedConfigurationProperty;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBootFeatureUsagesCollector
extends ProjectUsagesCollector {
    private static final String[] files = new String[]{"application.properties", "bootstrap.properties", "additional-spring-configuration-metadata.json", "application.yml", "application.yaml", "devtools.properties", "devtools.yml", "devtools.yaml"};
    private static final EventLogGroup GROUP = new EventLogGroup("spring.boot", 3);
    private static final EventId SPRING_BOOT_DEV_TOOLS = GROUP.registerEvent("spring.boot.dev.tools");
    private static final StringEventField NAME = EventFields.String((String)"name", (List)ContainerUtil.map((Object[])files, file -> FileUtil.getNameWithoutExtension((String)file)));
    private static final StringEventField EXTENSION = EventFields.String((String)"extension", (List)ContainerUtil.append((List)ContainerUtil.map((Object[])files, file -> PathUtil.getFileExtension((String)file)), (Object[])new String[]{"unknown"}));
    public static final StringEventField FILES = EventFields.StringValidatedByRegexpReference((String)"files", (String)"count");
    public static final StringEventField MODULES = EventFields.StringValidatedByRegexpReference((String)"modules", (String)"count");
    private static final VarargEventId CONFIGURATION_FILE = GROUP.registerVarargEvent("configuration.file", new EventField[]{NAME, EXTENSION, EventFields.Count, FILES});
    private static final EventId2<Integer, String> CONFIGURATION_PROPERTIES = GROUP.registerEvent("configuration.properties", (EventField)EventFields.Count, (EventField)FILES);
    private static final EventId2<Integer, String> NESTED_CONFIGURATION_PROPERTIES = GROUP.registerEvent("nested.configuration.properties", (EventField)EventFields.Count, (EventField)FILES);
    private static final EventId2<Integer, String> CONFIGURATION_PROPERTIES_METHODS = GROUP.registerEvent("configuration.properties.methods", (EventField)EventFields.Count, (EventField)FILES);
    private static final EventId2<Integer, String> SPRING_BOOT_MODULES_PER_PROJECT = GROUP.registerEvent("spring.boot.modules.per.project", (EventField)EventFields.Count, (EventField)MODULES);
    private static final List<Integer> steps = Arrays.asList(1, 2, 3, 4, 5, 10, 100, 1000);

    public EventLogGroup getGroup() {
        return GROUP;
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    protected boolean requiresSmartMode() {
        return true;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            SpringBootFeatureUsagesCollector.$$$reportNull$$$0(0);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                SpringBootFeatureUsagesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        int springBootModulesPerProject = 0;
        LinkedHashSet<MetricEvent> metrics = new LinkedHashSet<MetricEvent>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            List configurationPropertiesMethods;
            ProgressManager.checkCanceled();
            if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) continue;
            ++springBootModulesPerProject;
            if (SpringBootLibraryUtil.hasDevtools((Module)module)) {
                metrics.add(SPRING_BOOT_DEV_TOOLS.metric());
            }
            GlobalSearchScope scope = module.getModuleScope(false);
            for (String file : files) {
                ProgressManager.checkCanceled();
                Collection files = FilenameIndex.getVirtualFilesByName((String)file, (GlobalSearchScope)scope);
                if (files.isEmpty()) continue;
                metrics.add(CONFIGURATION_FILE.metric(new EventPair[]{NAME.with((Object)FileUtil.getNameWithoutExtension((String)file)), EXTENSION.with((Object)StringUtil.notNullize((String)PathUtil.getFileExtension((String)file), (String)"unknown")), EventFields.Count.with((Object)files.size()), FILES.with((Object)StatisticsUtil.INSTANCE.getCountingStepName(files.size(), steps))}));
            }
            List configurationProperties = JamService.getJamService((Project)project).getJamClassElements(ConfigurationProperties.CLASS_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope);
            if (!configurationProperties.isEmpty()) {
                metrics.add(CONFIGURATION_PROPERTIES.metric((Object)configurationProperties.size(), (Object)StatisticsUtil.INSTANCE.getCountingStepName(configurationProperties.size(), steps)));
                List nestedConfigurationProperties = JamService.getJamService((Project)project).getJamFieldElements(NestedConfigurationProperty.FIELD_META, "org.springframework.boot.context.properties.NestedConfigurationProperty", scope);
                if (!nestedConfigurationProperties.isEmpty()) {
                    metrics.add(NESTED_CONFIGURATION_PROPERTIES.metric((Object)nestedConfigurationProperties.size(), (Object)StatisticsUtil.INSTANCE.getCountingStepName(nestedConfigurationProperties.size(), steps)));
                }
            }
            if ((configurationPropertiesMethods = JamService.getJamService((Project)project).getJamMethodElements(ConfigurationProperties.Method.METHOD_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope)).isEmpty()) continue;
            metrics.add(CONFIGURATION_PROPERTIES_METHODS.metric((Object)configurationPropertiesMethods.size(), (Object)StatisticsUtil.INSTANCE.getCountingStepName(configurationPropertiesMethods.size(), steps)));
        }
        metrics.add(SPRING_BOOT_MODULES_PER_PROJECT.metric((Object)springBootModulesPerProject, (Object)StatisticsUtil.INSTANCE.getCountingStepName(springBootModulesPerProject, steps)));
        LinkedHashSet<MetricEvent> linkedHashSet = metrics;
        if (linkedHashSet == null) {
            SpringBootFeatureUsagesCollector.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/SpringBootFeatureUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/SpringBootFeatureUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

