/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelProducer;
import com.intellij.spring.boot.model.autoconfigure.jam.SpringBootApplication;
import com.intellij.spring.boot.model.properties.jam.ConfigurationPropertiesScan;
import com.intellij.spring.boot.model.properties.jam.CustomConfigurationPropertiesScan;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringComponentScanModel;
import com.intellij.spring.model.jam.stereotype.CustomJamComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScan;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBootApplicationLocalModel
extends LocalAnnotationModel {
    @NotNull
    public List<SpringBeansPackagesScan> getPackagesScans() {
        List scans = super.getPackagesScans();
        List list = ContainerUtil.filter((Collection)scans, scan -> !SpringBootApplicationLocalModel.isDefaultSpringBootApplicationToSkip(scan, scans));
        if (list == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    protected Set<CommonSpringModel> getPackageScanModels(@NotNull LocalAnnotationModel localModel) {
        if (localModel == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(1);
        }
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        Module module = localModel.getModule();
        List scans = localModel.getPackagesScans();
        for (SpringBeansPackagesScan scan : scans) {
            if (SpringBootApplicationLocalModel.isDefaultSpringBootApplicationToSkip(scan, scans)) continue;
            models.add((CommonSpringModel)new SpringComponentScanModel(module, scan, localModel.getActiveProfiles(), this.myTestContext));
        }
        if (models.size() <= 1) {
            Set<CommonSpringModel> set = Set.copyOf(models);
            if (set == null) {
                SpringBootApplicationLocalModel.$$$reportNull$$$0(2);
            }
            return set;
        }
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    private static boolean isDefaultSpringBootApplicationToSkip(@NotNull SpringBeansPackagesScan scan, List<? extends SpringBeansPackagesScan> scans) {
        PsiElement element;
        if (scan == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(4);
        }
        if (scan instanceof CustomJamComponentScan && SpringBootApplicationLocalModel.isSpringBootApplication(element = scan.getIdentifyingPsiElement())) {
            PsiFile psiFile = element.getContainingFile();
            return scans.stream().filter(packageScan -> (packageScan instanceof CustomJamComponentScan || packageScan instanceof SpringJamComponentScan) && psiFile.equals((Object)packageScan.getContainingFile())).count() > 1L;
        }
        if (scan instanceof CustomConfigurationPropertiesScan && SpringBootApplicationLocalModel.isSpringBootApplication(element = scan.getIdentifyingPsiElement())) {
            PsiFile psiFile = element.getContainingFile();
            return scans.stream().filter(packageScan -> (packageScan instanceof CustomConfigurationPropertiesScan || packageScan instanceof ConfigurationPropertiesScan) && psiFile.equals((Object)packageScan.getContainingFile())).count() > 1L;
        }
        return false;
    }

    private static boolean isSpringBootApplication(PsiElement element) {
        return element instanceof PsiAnnotation && "org.springframework.boot.autoconfigure.SpringBootApplication".equals(((PsiAnnotation)element).getQualifiedName());
    }

    public SpringBootApplicationLocalModel(@NotNull PsiClass aClass, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (aClass == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(6);
        }
        if (activeProfiles == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(7);
        }
        this(aClass, module, activeProfiles, false);
    }

    public SpringBootApplicationLocalModel(@NotNull PsiClass aClass, @NotNull Module module, @NotNull Set<String> activeProfiles, boolean testContext) {
        if (aClass == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(8);
        }
        if (module == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(9);
        }
        if (activeProfiles == null) {
            SpringBootApplicationLocalModel.$$$reportNull$$$0(10);
        }
        super(aClass, module, activeProfiles, testContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootApplicationLocalModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scan";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesScans";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootApplicationLocalModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageScanModels";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPackageScanModels";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultSpringBootApplicationToSkip";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    public static class SpringBootApplicationLocalModelProducer
    implements SpringLocalModelProducer {
        @Nullable
        public LocalAnnotationModel create(@NotNull PsiClass aClass, @NotNull Module module, @NotNull Set<String> activeProfiles, boolean testContext) {
            if (aClass == null) {
                SpringBootApplicationLocalModelProducer.$$$reportNull$$$0(0);
            }
            if (module == null) {
                SpringBootApplicationLocalModelProducer.$$$reportNull$$$0(1);
            }
            if (activeProfiles == null) {
                SpringBootApplicationLocalModelProducer.$$$reportNull$$$0(2);
            }
            if (JamService.getJamService((Project)module.getProject()).getJamElement(SpringBootApplication.META.getJamKey(), (PsiElement)aClass) != null) {
                return new SpringBootApplicationLocalModel(aClass, module, activeProfiles, testContext);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "activeProfiles";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/model/SpringBootApplicationLocalModel$SpringBootApplicationLocalModelProducer";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

