/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.chart.EffectiveHelmParameters;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.EmptyConsumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J,\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmCreateChartAction;", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "isApplicable", "", "context", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "isEnabled", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "withExecutionRequest", "consumer", "Lkotlin/Function1;", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "buildExecutionRequest", "currentChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "initialDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "newChartName", "", "processOutput", "request", "Lcom/intellij/execution/process/ProcessOutput;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmCreateChartAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmCreateChartAction.kt\ncom/intellij/kubernetes/ui/actions/HelmCreateChartAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,156:1\n30#2,2:157\n30#2,2:160\n30#2,2:163\n1#3:159\n23#4:162\n*S KotlinDebug\n*F\n+ 1 HelmCreateChartAction.kt\ncom/intellij/kubernetes/ui/actions/HelmCreateChartAction\n*L\n40#1:157,2\n59#1:160,2\n49#1:163,2\n113#1:162\n*E\n"})
public final class HelmCreateChartAction
extends KubernetesActionBase
implements DumbAware {
    @Override
    protected boolean isApplicable(@NotNull KubernetesActionBase.ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return context2.getCurrentFile().isDirectory() && !(context2.getCurrentFile().getFileSystem() instanceof ArchiveFileSystem);
    }

    @Override
    protected boolean isEnabled(@NotNull KubernetesActionBase.ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ComponentManager $this$service$iv = (ComponentManager)context2.getProject();
        boolean $i$f$service = false;
        Class<HelmExecutionManager> serviceClass$iv = HelmExecutionManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return !((HelmExecutionManager)object).isBusy();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesActionBase.ActionContext actionContext = this.getContext(e);
        if (actionContext == null) {
            return;
        }
        KubernetesActionBase.ActionContext context2 = actionContext;
        this.withExecutionRequest(context2, (Function1<? super HelmExecutionManager.ExecutionRequest, Unit>)((Function1)arg_0 -> HelmCreateChartAction.actionPerformed$lambda$0(context2, this, arg_0)));
    }

    private final void withExecutionRequest(KubernetesActionBase.ActionContext context2, Function1<? super HelmExecutionManager.ExecutionRequest, Unit> consumer) {
        VirtualFile virtualFile;
        VirtualFile it = virtualFile = context2.getCurrentFile();
        boolean bl = false;
        Object object = it.isDirectory() ? virtualFile : null;
        if (object == null) {
            return;
        }
        VirtualFile initialDir = object;
        ComponentManager $this$service$iv = (ComponentManager)context2.getProject();
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart currentChart = ((ChartManager)object2).findChartByBaseDir(initialDir);
        CreateFileFromTemplateDialog.Builder builder = CreateFileFromTemplateDialog.createDialog((Project)context2.getProject());
        builder.setTitle(KubernetesBundle.message((String)"HelmCreateChartAction.task.title", (Object[])new Object[0])).addKind(KubernetesBundle.message((String)"HelmCreateChartAction.kind", (Object[])new Object[0]), KubernetesIcons.HelmChart, "", new InputValidator(currentChart, initialDir){
            final /* synthetic */ Chart $currentChart;
            final /* synthetic */ VirtualFile $initialDir;
            {
                this.$currentChart = $currentChart;
                this.$initialDir = $initialDir;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean checkInput(String inputString) {
                void $this$mapTo$iv$iv;
                if (inputString == null) return false;
                if (!Chart.Companion.isChartNameValid(inputString)) return false;
                if (this.$currentChart == null) {
                    if (this.$initialDir.findChild(inputString) == null) return true;
                }
                if (this.$currentChart == null) return false;
                Iterable $this$map$iv = this.$currentChart.getSubCharts();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Chart chart = (Chart)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getBaseDir().getName());
                }
                if (((List)destination$iv$iv).contains(inputString)) return false;
                return true;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        builder.show(KubernetesBundle.message((String)"HelmCreateChartAction.dialog.error", (Object[])new Object[0]), null, (CreateFileFromTemplateDialog.FileCreator)new CreateFileFromTemplateDialog.FileCreator<PsiFileSystemItem>(this, currentChart, context2, initialDir, consumer){
            final /* synthetic */ HelmCreateChartAction this$0;
            final /* synthetic */ Chart $currentChart;
            final /* synthetic */ KubernetesActionBase.ActionContext $context;
            final /* synthetic */ VirtualFile $initialDir;
            final /* synthetic */ Function1<HelmExecutionManager.ExecutionRequest, Unit> $consumer;
            {
                this.this$0 = $receiver;
                this.$currentChart = $currentChart;
                this.$context = $context;
                this.$initialDir = $initialDir;
                this.$consumer = $consumer;
            }

            public PsiFileSystemItem createFile(String name, String templateName) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
                HelmExecutionManager.ExecutionRequest request = HelmCreateChartAction.access$buildExecutionRequest(this.this$0, this.$currentChart, this.$context, this.$initialDir, name);
                if (request != null) {
                    this.$consumer.invoke((Object)request);
                }
                return null;
            }

            public String getActionName(String name, String templateName) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
                String string = KubernetesBundle.message((String)"action.Kubernetes.HelmCreateChart.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public boolean startInWriteAction() {
                return false;
            }
        }, EmptyConsumer.getInstance());
    }

    private final HelmExecutionManager.ExecutionRequest buildExecutionRequest(Chart currentChart, KubernetesActionBase.ActionContext context2, VirtualFile initialDir, String newChartName) {
        Ref.ObjectRef currentDir = new Ref.ObjectRef();
        currentDir.element = initialDir;
        try {
            if (currentChart != null) {
                WriteAction.run(() -> HelmCreateChartAction.buildExecutionRequest$lambda$0(currentDir, currentChart));
            }
        }
        catch (IOException e) {
            VirtualFile externallyCreated;
            VirtualFile virtualFile = ((VirtualFile)currentDir.element).findChild("charts");
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile it = virtualFile2 = virtualFile;
                boolean bl = false;
                v1 = it.isDirectory() ? virtualFile2 : null;
            } else {
                v1 = externallyCreated = null;
            }
            if (externallyCreated == null) {
                HelmCreateChartAction $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(HelmCreateChartAction.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Couldn't create charts directory", (Throwable)e);
                NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
                NotificationType notificationType = NotificationType.ERROR;
                String string = KubernetesBundle.message((String)"HelmCreateChartAction.notification.title", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = string;
                Object[] objectArray = new Object[]{((VirtualFile)currentDir.element).getPath()};
                String string3 = KubernetesBundle.message((String)"HelmCreateChartAction.mkdir.failure.message", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                String string4 = string3;
                notificationGroup.createNotification(string2, string4, notificationType).setSubtitle(KubernetesBundle.message((String)"HelmCreateChartAction.notification.subtitle", (Object[])new Object[0])).notify(context2.getProject());
                return null;
            }
            currentDir.element = externallyCreated;
        }
        String string = KubernetesBundle.message((String)"HelmCreateChartAction.task.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new HelmExecutionManager.ExecutionRequest(string, CollectionsKt.listOf((Object)"create"), EffectiveHelmParameters.Companion.getEMPTY_PARAMETERS$intellij_clouds_kubernetes_backend(), (VirtualFile)currentDir.element, newChartName, null, null, 96, null);
    }

    private final void processOutput(KubernetesActionBase.ActionContext context2, HelmExecutionManager.ExecutionRequest request, ProcessOutput processOutput) {
        block3: {
            VirtualFile virtualFile;
            VirtualFile virtualFile2;
            if (processOutput.getExitCode() != 0) {
                return;
            }
            request.getWorkingDir().refresh(false, false);
            if (request.getChartDirName() == null) {
                return;
            }
            VirtualFile virtualFile3 = request.getWorkingDir().findChild(request.getChartDirName());
            if (virtualFile3 == null) break block3;
            VirtualFile it = virtualFile2 = virtualFile3;
            boolean bl = false;
            Object object = virtualFile = it.isDirectory() ? virtualFile2 : null;
            if (virtualFile != null) {
                VirtualFile newChartDir = virtualFile;
                boolean bl2 = false;
                ReadAction.run(() -> HelmCreateChartAction.processOutput$lambda$1$0(context2, newChartDir));
            }
        }
    }

    private static final Unit actionPerformed$lambda$0$0(HelmCreateChartAction this$0, KubernetesActionBase.ActionContext $context, HelmExecutionManager.ExecutionRequest $request, ProcessOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this$0.processOutput($context, $request, output);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$0(KubernetesActionBase.ActionContext $context, HelmCreateChartAction this$0, HelmExecutionManager.ExecutionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FileDocumentManager.getInstance().saveAllDocuments();
        ComponentManager $this$service$iv = (ComponentManager)$context.getProject();
        boolean $i$f$service = false;
        Class<HelmExecutionManager> serviceClass$iv = HelmExecutionManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((HelmExecutionManager)object).executeQuickCommand(request, false, (Function1<? super ProcessOutput, Unit>)((Function1)arg_0 -> HelmCreateChartAction.actionPerformed$lambda$0$0(this$0, $context, request, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void buildExecutionRequest$lambda$0(Ref.ObjectRef $currentDir, Chart $currentChart) {
        VirtualFile virtualFile = $currentChart.getChartsDir();
        if (virtualFile == null) {
            VirtualFile virtualFile2 = ((VirtualFile)$currentDir.element).createChildDirectory(null, "charts");
            virtualFile = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildDirectory(...)");
        }
        $currentDir.element = virtualFile;
    }

    private static final void processOutput$lambda$1$0(KubernetesActionBase.ActionContext $context, VirtualFile $newChartDir) {
        PsiDirectory psiDir = PsiManager.getInstance((Project)$context.getProject()).findDirectory($newChartDir);
        ProjectView.getInstance((Project)$context.getProject()).select((Object)psiDir, $newChartDir, true);
    }

    public static final /* synthetic */ HelmExecutionManager.ExecutionRequest access$buildExecutionRequest(HelmCreateChartAction $this, Chart currentChart, KubernetesActionBase.ActionContext context2, VirtualFile initialDir, String newChartName) {
        return $this.buildExecutionRequest(currentChart, context2, initialDir, newChartName);
    }
}

